/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.switchyard.tools.cxf.Java2WSDLOperation;
import org.switchyard.tools.cxf.Java2WSDLOptions;
import org.switchyard.tools.ui.i18n.Messages;
import org.w3c.dom.Node;

public class CreateWSDLFromJavaOperation
implements IWorkspaceRunnable {
    private final MultiStatus _status = new MultiStatus("org.switchyard.tools.ui", 0, Messages.CreateWSDLFromJavaOperation_statusLabel_java2WSDLOperation, null);
    private final Java2WSDLOptions _options;
    private final IFile _wsdlFile;

    public CreateWSDLFromJavaOperation(Java2WSDLOptions options, IFile wsdlFile) {
        this._options = options;
        this._wsdlFile = wsdlFile;
    }

    public IStatus getStatus() {
        return this._status;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        Java2WSDLOperation java2wsdl = new Java2WSDLOperation(this._options);
        try {
            java2wsdl.run(monitor);
        }
        catch (InvocationTargetException e) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.CreateWSDLFromJavaOperation_exceptionMessage_wsdlGenerationFailed, e.getTargetException()));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.CreateWSDLFromJavaOperation_exceptionMessage_wsdlGenerationFailed, (Throwable)e));
        }
        this._status.add((IStatus)new Status(1, "org.switchyard.tools.ui", Messages.CreateWSDLFromJavaOperation_statusMessage_wsdlGeneratedSuccessfully));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            try {
                WSDLFactory.newInstance().newWSDLWriter().writeWSDL(java2wsdl.getGeneratedWSDL(), (OutputStream)baos);
                is = new ByteArrayInputStream(baos.toByteArray());
                String message = NLS.bind((String)Messages.CreateWSDLFromJavaOperation_operationLabel_writingWSDLFile, (Object)this._wsdlFile.getName());
                CreateFileOperation op = new CreateFileOperation(this._wsdlFile, null, is, message);
                op.execute(monitor, null);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.CreateWSDLFromJavaOperation_exceptionMessage_errorWritingWSDL, (Throwable)e));
            }
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
            }
            baos = null;
            is = null;
        }
        this._status.add((IStatus)new Status(1, "org.switchyard.tools.ui", Messages.CreateWSDLFromJavaOperation_statusMessage_wsdlWrittenSuccessfully));
        try {
            Transformer transformer = this.createTransformer();
            for (Map.Entry schemaEntry : java2wsdl.getGeneratedSchema().entrySet()) {
                IFile schemaFile = this._wsdlFile.getParent().getFile((IPath)new Path((String)schemaEntry.getKey()));
                if (schemaFile.exists()) continue;
                try {
                    try {
                        baos = new ByteArrayOutputStream();
                        DOMSource source = new DOMSource((Node)schemaEntry.getValue());
                        StreamResult result = new StreamResult(baos);
                        transformer.transform(source, result);
                        is = new ByteArrayInputStream(baos.toByteArray());
                        CreateFileOperation op = new CreateFileOperation(schemaFile, null, is, String.valueOf(Messages.CreateWSDLFromJavaOperation_operationLabel_writingSchemaFile) + schemaFile.getName());
                        op.execute(monitor, null);
                        String message = NLS.bind((String)Messages.CreateWSDLFromJavaOperation_statusMessage_schemaWrittenSuccessfully, (Object)schemaFile.getName());
                        this._status.add((IStatus)new Status(1, "org.switchyard.tools.ui", message));
                    }
                    catch (Exception e) {
                        String message = NLS.bind((String)Messages.CreateWSDLFromJavaOperation_statusMessage_errorWritingImportedSchema, (Object)schemaFile.getName());
                        this._status.add((IStatus)new Status(2, "org.switchyard.tools.ui", message, (Throwable)e));
                        try {
                            if (baos != null) {
                                baos.close();
                            }
                        }
                        catch (IOException e2) {
                            e2.fillInStackTrace();
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e3) {
                                e3.fillInStackTrace();
                            }
                        }
                        baos = null;
                        is = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                        }
                    }
                    baos = null;
                    is = null;
                    throw throwable;
                }
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                    }
                }
                baos = null;
                is = null;
            }
        }
        catch (Exception e) {
            this._status.add((IStatus)new Status(2, "org.switchyard.tools.ui", Messages.CreateWSDLFromJavaOperation_statusLabel_errorWritingSchemaFiles, (Throwable)e));
        }
    }

    private Transformer createTransformer() throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("encoding", "utf-8");
        return transformer;
    }
}

