/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.facets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetComponentProviderDelegate;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardRuntimeComponentProvider
extends RuntimeFacetComponentProviderDelegate {
    private static final Pattern DEPLOY_JAR_NAME_PATTERN = Pattern.compile("switchyard-deploy-(jboss-as7|wildfly)-(.*?)\\.jar");
    private static final String SWITCHYARD_AS_DEPLOY_MODULE_PATH = "modules/system/layers/soa/org/switchyard/main";
    private static final String FSW_PRODUCT_MANIFEST_PATH = "modules/system/layers/soa/org/jboss/as/product/soa/dir/META-INF/MANIFEST.MF";
    private static final Attributes.Name JBOSS_PRODUCT_RELEASE_NAME = new Attributes.Name("JBoss-Product-Release-Name");
    private static final Attributes.Name JBOSS_PRODUCT_RELEASE_VERSION = new Attributes.Name("JBoss-Product-Release-Version");

    public List<IRuntimeComponent> getRuntimeComponents(IRuntime runtime) {
        IPath runtimeLocation = runtime.getLocation();
        IRuntimeComponent switchYardRuntime = null;
        if (runtimeLocation == null) {
            switchYardRuntime = this.getDefaultRuntimeComponent(null);
        } else {
            SwitchYardRuntimeMetaData switchYardMetaData;
            block25: {
                switchYardMetaData = this.getSwitchYardVersionFromRuntime(runtimeLocation);
                File productManifest = runtimeLocation.append(FSW_PRODUCT_MANIFEST_PATH).toFile();
                if (productManifest.exists()) {
                    try {
                        FileInputStream is = new FileInputStream(productManifest);
                        try {
                            try {
                                String productName;
                                Manifest manifest = new Manifest(is);
                                if (manifest.getMainAttributes().containsKey(JBOSS_PRODUCT_RELEASE_NAME) && (productName = (String)String.class.cast(manifest.getMainAttributes().get(JBOSS_PRODUCT_RELEASE_NAME))).matches(".* Fuse Service Works")) {
                                    switchYardMetaData._name = productName;
                                    if (manifest.getMainAttributes().containsKey(JBOSS_PRODUCT_RELEASE_VERSION)) {
                                        switchYardMetaData._runtimeVersion = (String)String.class.cast(manifest.getMainAttributes().get(SwitchYardRuntimeComponentProvider.JBOSS_PRODUCT_RELEASE_VERSION));
                                    }
                                    if (switchYardMetaData._runtimeVersion != null) {
                                        if (switchYardMetaData._runtimeVersion.startsWith("6.0.")) {
                                            switchYardRuntime = RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"fuseServiceWorks.runtime").getVersion("6.0"), this.createRuntimeComponentProperties(switchYardMetaData));
                                        } else if (switchYardMetaData._runtimeVersion.startsWith("6.1.")) {
                                            switchYardRuntime = RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"fuseServiceWorks.runtime").getVersion("6.1"), this.createRuntimeComponentProperties(switchYardMetaData));
                                        }
                                    }
                                    if (switchYardRuntime == null) {
                                        switchYardRuntime = this.getDefaultFSWRuntimeComponent(null);
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.fillInStackTrace();
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (IOException e2) {
                                    e2.fillInStackTrace();
                                }
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException e) {
                                e.fillInStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.fillInStackTrace();
                    }
                }
            }
            if (switchYardRuntime == null && switchYardMetaData != null) {
                switchYardRuntime = switchYardMetaData._runtimeVersion.startsWith("1.0.") || switchYardMetaData._runtimeVersion.startsWith("0.") ? RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"switchyard.runtime").getVersion("1.0"), this.createRuntimeComponentProperties(switchYardMetaData)) : (switchYardMetaData._runtimeVersion.startsWith("1.1.") ? RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"switchyard.runtime").getVersion("1.1"), this.createRuntimeComponentProperties(switchYardMetaData)) : (switchYardMetaData._runtimeVersion.startsWith("2.0.") ? RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"switchyard.runtime").getVersion("2.0"), this.createRuntimeComponentProperties(switchYardMetaData)) : this.getDefaultRuntimeComponent(switchYardMetaData)));
            }
        }
        if (switchYardRuntime == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(switchYardRuntime);
    }

    private IRuntimeComponent getDefaultRuntimeComponent(SwitchYardRuntimeMetaData switchYardVersion) {
        try {
            return RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"switchyard.runtime").getLatestVersion(), this.createRuntimeComponentProperties(switchYardVersion));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private IRuntimeComponent getDefaultFSWRuntimeComponent(SwitchYardRuntimeMetaData switchYardMetaData) {
        try {
            return RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"fuseServiceWorks.runtime").getLatestVersion(), this.createRuntimeComponentProperties(switchYardMetaData));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Map<String, String> createRuntimeComponentProperties(SwitchYardRuntimeMetaData switchYardMetaData) {
        if (switchYardMetaData == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("switchyard.label", switchYardMetaData.createLabel());
        properties.put("switchyard.version", switchYardMetaData._libraryVersion);
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SwitchYardRuntimeMetaData getSwitchYardVersionFromRuntime(IPath runtimeLocation) {
        File mainDirectory = runtimeLocation.append(SWITCHYARD_AS_DEPLOY_MODULE_PATH).toFile();
        String[] files = mainDirectory.list();
        if (files == null) {
            return null;
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Matcher matcher = DEPLOY_JAR_NAME_PATTERN.matcher(file);
            if (matcher.matches()) {
                try {
                    JarFile runtimeJar = new JarFile(new File(mainDirectory, file));
                    try {
                        Manifest manifest = runtimeJar.getManifest();
                        if (manifest != null) {
                            SwitchYardRuntimeMetaData metadata = new SwitchYardRuntimeMetaData();
                            if (manifest.getMainAttributes().containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
                                metadata._libraryVersion = (String)String.class.cast(manifest.getMainAttributes().get(Attributes.Name.IMPLEMENTATION_VERSION));
                                metadata._runtimeVersion = metadata._libraryVersion;
                            } else {
                                metadata._libraryVersion = matcher.group(1);
                                metadata._runtimeVersion = metadata._libraryVersion;
                            }
                            metadata._name = (String)String.class.cast(manifest.getMainAttributes().get(Attributes.Name.IMPLEMENTATION_TITLE));
                            SwitchYardRuntimeMetaData switchYardRuntimeMetaData = metadata;
                            return switchYardRuntimeMetaData;
                        }
                    }
                    catch (IOException iOException) {
                        SwitchYardRuntimeMetaData metadata2 = new SwitchYardRuntimeMetaData();
                        metadata2._name = Messages.SwitchYardRuntimeComponentProvider_label_runtimeComponentName;
                        metadata2._libraryVersion = matcher.group(1);
                        metadata2._runtimeVersion = metadata2._libraryVersion;
                        SwitchYardRuntimeMetaData switchYardRuntimeMetaData2 = metadata2;
                        return switchYardRuntimeMetaData2;
                    }
                    finally {
                        try {
                            runtimeJar.close();
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    private static final class SwitchYardRuntimeMetaData {
        private String _libraryVersion;
        private String _name;
        private String _runtimeVersion;

        private SwitchYardRuntimeMetaData() {
        }

        private String createLabel() {
            String version = this._runtimeVersion == null || this._runtimeVersion.length() == 0 ? (this._libraryVersion == null || this._libraryVersion.length() == 0 ? null : this._libraryVersion) : this._runtimeVersion;
            return this._name + ' ' + version;
        }
    }
}

