/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer.impl;

import java.util.ArrayList;
import java.util.List;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.tools.ui.explorer.AbstractSwitchYardNode;
import org.switchyard.tools.ui.explorer.IReferenceNode;
import org.switchyard.tools.ui.explorer.IReferencesNode;
import org.switchyard.tools.ui.explorer.IServiceGateway;
import org.switchyard.tools.ui.explorer.impl.ServiceGateway;

public class ReferenceNode
extends AbstractSwitchYardNode
implements IReferenceNode {
    private CompositeReferenceModel _reference;
    private List<IServiceGateway> _gateways;

    public ReferenceNode(IReferencesNode parent, CompositeReferenceModel reference) {
        super(parent);
        this._reference = reference;
        List bindings = reference.getBindings();
        this._gateways = new ArrayList<IServiceGateway>(bindings.size());
        for (BindingModel binding : bindings) {
            this._gateways.add(new ServiceGateway(this, binding));
        }
    }

    @Override
    public String getName() {
        return this._reference.getName();
    }

    @Override
    public List<IServiceGateway> getGateways() {
        return this._gateways;
    }

    public CompositeReferenceModel getModel() {
        return this._reference;
    }

    public int hashCode() {
        return this._reference.getQName() == null ? super.hashCode() : this._reference.getQName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReferenceNode) {
            ReferenceNode other = (ReferenceNode)obj;
            return other.getRoot().equals(this.getRoot()) && other._reference.getQName() != null && this._reference.getQName() != null && other._reference.getQName().equals(this._reference.getQName());
        }
        return false;
    }
}

