/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.switchyard.tools.ui.i18n.Messages;

public class ClasspathResourceSelectionDialog
extends FilteredResourcesSelectionDialog {
    private Set<String> _fileExtensions;
    private IJavaModel _fJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

    public ClasspathResourceSelectionDialog(Shell parentShell, IContainer container) {
        this(parentShell, container, Collections.emptySet());
    }

    public ClasspathResourceSelectionDialog(Shell parentShell, IContainer container, String fileExtension) {
        this(parentShell, container, fileExtension == null ? Collections.emptySet() : Collections.singleton(fileExtension));
    }

    public ClasspathResourceSelectionDialog(Shell parentShell, IContainer container, Set<String> fileExtensions) {
        super(parentShell, false, container, 1);
        this._fileExtensions = fileExtensions == null ? Collections.emptySet() : fileExtensions;
        this.setTitle(Messages.ClasspathResourceSelectionDialog_dialogTitle);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ClasspathResourceFilter();
    }

    private class ClasspathResourceFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        private ClasspathResourceFilter() {
            super((FilteredResourcesSelectionDialog)ClasspathResourceSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            IResource resource = (IResource)item;
            return super.matchItem(item) && (ClasspathResourceSelectionDialog.this._fileExtensions == null || ClasspathResourceSelectionDialog.this._fileExtensions.isEmpty() || ClasspathResourceSelectionDialog.this._fileExtensions.contains(resource.getFullPath().getFileExtension())) && this.select(resource);
        }

        private boolean isParentOnClassPath(IJavaProject javaProject, IResource resource) {
            boolean flag = false;
            while (!flag && resource.getParent() != null) {
                flag = javaProject.isOnClasspath(resource);
                if (!flag) {
                    resource = resource.getParent();
                    continue;
                }
                return flag;
            }
            return flag;
        }

        private boolean select(IResource resource) {
            IProject project = resource.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                return javaProject != null && this.isParentOnClassPath(javaProject, resource) || project.getNature("org.eclipse.jdt.core.javanature") != null && ClasspathResourceSelectionDialog.this._fJavaModel.contains(resource);
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return filter instanceof ClasspathResourceFilter && super.equalsFilter(filter);
        }
    }
}

