/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util.directedit;

import org.eclipse.gef.commands.Command;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPart;

public class DirectEditPartCommand
extends Command {
    private String newName;
    private String oldName;
    private DirectEditPart directEditPart;

    public DirectEditPartCommand(DirectEditPart part, String s) {
        this.directEditPart = part;
        this.newName = s != null ? s : "";
    }

    public void execute() {
        this.oldName = this.directEditPart.getText();
        String undoLabel = DiagramUiConstants.Util.getString("DirectEditPartCommand.undoRenameLabel", (Object)this.oldName);
        boolean started = ModelerCore.startTxn((boolean)true, (boolean)true, (String)undoLabel, (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.directEditPart.setText(this.newName);
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public void undo() {
        String undoLabel = DiagramUiConstants.Util.getString("DirectEditPartCommand.undoRenameLabel", (Object)this.oldName);
        boolean started = ModelerCore.startTxn((boolean)true, (boolean)true, (String)undoLabel, (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.directEditPart.setText(this.oldName);
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }
}

