/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;

public class LassoSelectionTool
extends AbstractTool {
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private int mode;
    private boolean fillValue = false;
    private int lineStyle = 4;
    private Color lineColor = ColorConstants.blue;
    private int lineWidth = 5;
    private Shape lassoRectangleFigure;
    private List allChildren = new ArrayList();
    private List selectedEditParts;
    private Request targetRequest;
    private static final Request LASSO_REQUEST = new Request((Object)"selection");

    public LassoSelectionTool() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setLineStyle(this.lineStyle);
    }

    private List calculateNewSelection() {
        ArrayList<EditPart> newSelections = new ArrayList<EditPart>();
        List children = this.getAllChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            IFigure figure = ((GraphicalEditPart)child).getFigure();
            Rectangle r = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)r);
            if (DiagramUiUtilities.isLassoableFigure(figure) && figure.isVisible()) {
                if (this.geLassoSelectionRectangle().contains(r.getTopLeft()) && this.geLassoSelectionRectangle().contains(r.getBottomRight())) {
                    if (child.getTargetEditPart(LASSO_REQUEST) == child && DiagramUiUtilities.isLassoableEditPart(child) && !newSelections.contains(child)) {
                        newSelections.add(child);
                    }
                } else if (this.geLassoSelectionRectangle().intersects(r) && child.getTargetEditPart(LASSO_REQUEST) == child && DiagramUiUtilities.isLassoableEditPart(child) && !newSelections.contains(child)) {
                    newSelections.add(child);
                }
            }
            ++i;
        }
        return newSelections;
    }

    private Request createTargetRequest() {
        return LASSO_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseLassoFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren = new ArrayList();
        this.setState(0x40000000);
    }

    private void eraseLassoFeedback() {
        if (this.lassoRectangleFigure != null) {
            this.removeFeedback((IFigure)this.lassoRectangleFigure);
            this.lassoRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        ListIterator oldEditParts = this.selectedEditParts.listIterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = (EditPart)oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private List getAllChildren(EditPart editPart, List allChildren) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            allChildren.add(child);
            this.getAllChildren((EditPart)child, allChildren);
            ++i;
        }
        return allChildren;
    }

    private List getAllChildren() {
        if (this.allChildren.isEmpty()) {
            this.allChildren = this.getAllChildren((EditPart)this.getCurrentViewer().getRootEditPart(), new ArrayList());
        }
        return this.allChildren;
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Lasso Tool";
    }

    private IFigure getLassoFeedbackFigure() {
        if (this.lassoRectangleFigure == null) {
            this.lassoRectangleFigure = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)this.lassoRectangleFigure);
            this.lassoRectangleFigure.setFill(this.fillValue);
            this.lassoRectangleFigure.setLineStyle(this.lineStyle);
            this.lassoRectangleFigure.setLineWidth(this.lineWidth);
            this.lassoRectangleFigure.setForegroundColor(this.lineColor);
            this.addFeedback((IFigure)this.lassoRectangleFigure);
        }
        return this.lassoRectangleFigure;
    }

    private Rectangle geLassoSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private int getSelectionMode() {
        return this.mode;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            this.setSelectionMode(1);
            if (this.getCurrentInput().isControlKeyDown()) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseLassoFeedback();
            this.performLassoSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showLassoFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateNewSelection();
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseLassoFeedback();
        return true;
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    private void performLassoSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        List newSelections = this.calculateNewSelection();
        if (this.getSelectionMode() == 2) {
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                viewer.appendSelection(editPart);
                ++i;
            }
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(Cursors.CROSS);
        } else {
            this.setDefaultCursor(Cursors.NO);
        }
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    private void showLassoFeedback() {
        Rectangle rect = this.geLassoSelectionRectangle().getCopy();
        this.getLassoFeedbackFigure().translateToRelative((Translatable)rect);
        this.getLassoFeedbackFigure().setBounds(rect);
    }

    private void showTargetFeedback() {
        int i = 0;
        while (i < this.selectedEditParts.size()) {
            EditPart editPart = (EditPart)this.selectedEditParts.get(i);
            editPart.showTargetFeedback(this.getTargetRequest());
            ++i;
        }
    }

    public void setLineWidth(int newWidth) {
        this.lineWidth = newWidth;
    }

    public void setLineStyle(int newStyle) {
        this.lineStyle = newStyle;
    }

    public void setLineColor(Color newColor) {
        this.lineColor = newColor;
    }

    public void setFill(boolean shouldFill) {
        this.fillValue = shouldFill;
    }
}

