/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.pakkage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.DiagramUmlAssociation;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.model.AbstractLocalDiagramModelNode;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.LabelModelNode;

public class PackageDiagramNode
extends AbstractLocalDiagramModelNode {
    public PackageDiagramNode(EObject modelObject, String diagramName) {
        super(modelObject, diagramName);
    }

    @Override
    public String toString() {
        return "PackageDiagramNode(" + this.getName() + ")";
    }

    @Override
    public boolean wasLayedOut() {
        List children = this.getChildren();
        Iterator iter = children.iterator();
        DiagramModelNode nextChild = null;
        while (iter.hasNext()) {
            nextChild = (DiagramModelNode)iter.next();
            if (!nextChild.wasLayedOut()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void recoverObjectProperties() {
        List children = this.getChildren();
        Iterator iter = children.iterator();
        DiagramModelNode nextChild = null;
        while (iter.hasNext()) {
            nextChild = (DiagramModelNode)iter.next();
            if (!nextChild.wasLayedOut()) continue;
            nextChild.recoverObjectProperties();
        }
    }

    public void refreshAssociationLabels() {
        this.clearAssociationLabels();
        this.resetAssociationShowPreferences();
        this.addAssociationLabels();
    }

    public void clearAssociationLabels() {
        ArrayList<DiagramModelNode> labels = new ArrayList<DiagramModelNode>();
        List children = this.getChildren();
        Iterator iter = children.iterator();
        DiagramModelNode nextChild = null;
        while (iter.hasNext()) {
            nextChild = (DiagramModelNode)iter.next();
            if (!(nextChild instanceof LabelModelNode)) continue;
            labels.add(nextChild);
        }
        if (!labels.isEmpty()) {
            this.removeChildren(labels, false);
        }
    }

    private void addAssociationLabels() {
        List currentAssociations = this.getCurrentAssociations();
        if (!currentAssociations.isEmpty()) {
            Iterator iter = currentAssociations.iterator();
            NodeConnectionModel nextAssociation = null;
            while (iter.hasNext()) {
                nextAssociation = (NodeConnectionModel)iter.next();
                List labelNodes = nextAssociation.getLabelNodes();
                if (labelNodes == null || labelNodes.isEmpty()) continue;
                Iterator labelIter = labelNodes.iterator();
                LabelModelNode nextNode = null;
                while (labelIter.hasNext()) {
                    nextNode = (LabelModelNode)labelIter.next();
                    this.addChild(nextNode);
                }
            }
        }
    }

    public List getCurrentAssociations() {
        ArrayList<NodeConnectionModel> currentAssociations = new ArrayList<NodeConnectionModel>();
        for (DiagramModelNode childModelNode : this.getChildren()) {
            Vector sourceConnections = childModelNode.getSourceConnections();
            NodeConnectionModel nextAssociation2 = null;
            for (NodeConnectionModel nextAssociation2 : sourceConnections) {
                if (currentAssociations.contains(nextAssociation2)) continue;
                currentAssociations.add(nextAssociation2);
            }
            Vector targetConnections = childModelNode.getTargetConnections();
            for (NodeConnectionModel nextAssociation2 : targetConnections) {
                if (currentAssociations.contains(nextAssociation2)) continue;
                currentAssociations.add(nextAssociation2);
            }
        }
        return currentAssociations;
    }

    public void resetAssociationShowPreferences() {
        List currentAssociations = this.getCurrentAssociations();
        if (!currentAssociations.isEmpty()) {
            IPreferenceStore store = DiagramUiPlugin.getDefault().getPreferenceStore();
            boolean showRoles = store.getBoolean("showFkName");
            boolean showMulti = store.getBoolean("showFkMultiplicity");
            Iterator iter = currentAssociations.iterator();
            NodeConnectionModel nextAssociation = null;
            while (iter.hasNext()) {
                nextAssociation = (NodeConnectionModel)iter.next();
                if (!(nextAssociation instanceof DiagramUmlAssociation)) continue;
                ((DiagramUmlAssociation)nextAssociation).setShowRoles(showRoles);
                ((DiagramUmlAssociation)nextAssociation).setShowMultiplicity(showMulti);
            }
        }
    }
}

