/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.part;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlPackageFigure;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlPackageNode;
import org.teiid.designer.diagram.ui.part.AbstractNotationEditPart;
import org.teiid.designer.diagram.ui.util.DiagramNodeSelectionEditPolicy;
import org.teiid.designer.diagram.ui.util.SelectionTracker;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditFigure;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPart;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPartEditPolicy;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPartManager;
import org.teiid.designer.diagram.ui.util.directedit.LabelCellEditorLocator;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class UmlPackageEditPart
extends AbstractNotationEditPart
implements DirectEditPart {
    private DragTracker myDragTracker = null;
    private DirectEditManager manager;

    public UmlPackageEditPart() {
        this.init();
    }

    public UmlPackageEditPart(String diagramTypeId) {
        this.setDiagramTypeId(diagramTypeId);
        this.init();
    }

    public void init() {
        if (this.getAnchorManager() == null) {
            this.setAnchorManager(this.getEditPartFactory().getAnchorManager(this));
        }
    }

    @Override
    protected IFigure createFigure() {
        Point location = new Point(100, 100);
        Figure newFigure = this.getFigureGenerator().createFigure(this.getModel());
        newFigure.setLocation(location);
        return newFigure;
    }

    protected void createEditPolicies() {
        this.setPrimaryParent(true);
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new DiagramNodeSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPartEditPolicy());
    }

    @Override
    public void edit() {
        if (this.doubleClickedName()) {
            if (ModelerCore.getModelEditor().hasName(this.getModelObject()) && !ModelObjectUtilities.isReadOnly((EObject)this.getModelObject())) {
                this.performDirectEdit();
            }
        } else {
            ModelEditorManager.open((EObject)((DiagramModelNode)this.getModel()).getModelObject(), (boolean)true);
        }
    }

    @Override
    public void performDirectEdit() {
        if (this.manager == null) {
            this.manager = new DirectEditPartManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator(this.getLabel()));
        }
        this.manager.show();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.edit();
        }
    }

    private boolean doubleClickedName() {
        SelectionTracker tracker = (SelectionTracker)this.getDragTracker(null);
        if (tracker != null && tracker.getLastMouseLocation() != null) {
            Point point = new Point(tracker.getLastMouseLocation());
            Point viewportLoc = ((DiagramViewer)this.getViewer()).getViewportLocation();
            UmlPackageFigure cFigure = (UmlPackageFigure)this.getDiagramFigure();
            IFigure nameFigure = cFigure.getNameFigure();
            if (nameFigure != null) {
                Rectangle rect = new Rectangle(nameFigure.getBounds());
                rect.x = rect.x + cFigure.getBounds().x - 3 - viewportLoc.x;
                rect.y = rect.y + cFigure.getBounds().y - 3 - viewportLoc.y;
                rect.width += 6;
                rect.height += 6;
                if (rect.contains(point)) {
                    return true;
                }
            }
        }
        return false;
    }

    public DragTracker getDragTracker(Request req) {
        if (this.myDragTracker == null) {
            this.myDragTracker = new SelectionTracker((EditPart)this);
        }
        return this.myDragTracker;
    }

    protected void refreshVisuals() {
        Point loc = ((DiagramModelNode)this.getModel()).getPosition();
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        this.getFigure().repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("size")) {
            this.getChangeManager().refresh(9, true);
        }
        super.propertyChange(evt);
        if (prop.equals("name")) {
            this.layout();
        } else if (prop.equals("location")) {
            this.getChangeManager().refresh(4, true);
            this.getChangeManager().refresh(3, true);
        }
        if (prop.equals("path")) {
            this.refreshPath();
            this.layout();
        }
    }

    @Override
    public void resizeChildren() {
        this.getDiagramFigure().updateForSize(((DiagramModelNode)this.getModel()).getSize());
    }

    public void refreshPath() {
        ((UmlPackageFigure)this.getDiagramFigure()).updateForPath(((UmlPackageNode)this.getModel()).getPath());
    }

    @Override
    public String getText() {
        return ((DiagramModelNode)this.getModel()).getName();
    }

    @Override
    public void setText(String newName) {
        ((DiagramModelNode)this.getModel()).setName(newName);
    }

    @Override
    public String getEditString() {
        return ((DiagramModelNode)this.getModel()).getName();
    }

    @Override
    public DirectEditPartManager getEditManager() {
        return (DirectEditPartManager)this.manager;
    }

    private Label getLabel() {
        Label label = null;
        if (this.getFigure() instanceof DirectEditFigure) {
            label = ((DirectEditFigure)this.getFigure()).getLabelFigure();
        }
        return label;
    }
}

