/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.ActionWrapper;
import org.teiid.designer.diagram.ui.actions.AutoLayoutWrapper;
import org.teiid.designer.diagram.ui.actions.DiagramActionService;
import org.teiid.designer.diagram.ui.actions.DiagramGlobalActionsMap;
import org.teiid.designer.diagram.ui.actions.FontDownWrapper;
import org.teiid.designer.diagram.ui.actions.FontUpWrapper;
import org.teiid.designer.diagram.ui.actions.IDiagramActionConstants;
import org.teiid.designer.diagram.ui.actions.ZoomComboActionContributeItem;
import org.teiid.designer.diagram.ui.actions.ZoomComboWrapper;
import org.teiid.designer.diagram.ui.actions.ZoomInWrapper;
import org.teiid.designer.diagram.ui.actions.ZoomOutWrapper;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.IDiagramActionAdapter;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.actions.ControlledPopupMenuExtender;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorSite;

public final class DiagramActionContributor
extends AbstractModelEditorPageActionBarContributor
implements DiagramUiConstants,
IDiagramActionConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DiagramActionContributor.class);
    private ActionContributionItem zoomIn;
    private ActionContributionItem zoomOut;
    private ActionContributionItem zoomCombo;
    private ActionContributionItem fontUp;
    private ActionContributionItem fontDown;
    private ActionContributionItem autoLayout;
    private GroupMarker diagramGroupStart;
    private GroupMarker diagramGroupEnd;
    private DiagramGlobalActionsMap actionsMap;
    private List<ContributionItem> contributionItems;
    private HashMap<AbstractAction, String> allRegisteredActions = new HashMap();
    private String CONTEXT_MENU_ID = "diagramEditorPage.contextMenu";
    private IDiagramActionAdapter cachedAdapter;
    private boolean firstTime = true;
    private ControlledPopupMenuExtender popupMenuExtender = null;
    private boolean contributed = false;
    private IMenuManager editMenu;
    private List<IDiagramActionAdapter> contributors = new ArrayList<IDiagramActionAdapter>();

    public DiagramActionContributor(ModelEditorPage page) {
        super(page);
        this.actionsMap = new DiagramGlobalActionsMap();
        this.actionsMap.reset();
        this.contributionItems = new ArrayList<ContributionItem>();
        this.initActions();
    }

    public GlobalActionsMap getGlobalActions() {
        DiagramGlobalActionsMap gamAdapterMap = null;
        IDiagramActionAdapter diagramActionAdapter = this.getCurrentDiagramActionAdapter();
        if (diagramActionAdapter != null) {
            gamAdapterMap = (DiagramGlobalActionsMap)diagramActionAdapter.getGlobalActions();
            this.initDiagramGLobalActionDetails();
        }
        if (gamAdapterMap == null) {
            return this.actionsMap;
        }
        gamAdapterMap = this.provideMissingActions(gamAdapterMap);
        return gamAdapterMap;
    }

    private DiagramGlobalActionsMap provideMissingActions(DiagramGlobalActionsMap dgaMap) {
        this.actionsMap.put(IActionConstants.EclipseGlobalActions.PRINT, this.getAction(IActionConstants.EclipseGlobalActions.PRINT));
        if (dgaMap.get(IActionConstants.EclipseGlobalActions.PRINT) == null) {
            IAction actPrint = this.getAction(IActionConstants.EclipseGlobalActions.PRINT);
            dgaMap.put(IActionConstants.EclipseGlobalActions.PRINT, actPrint);
        }
        return dgaMap;
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
    }

    public void contributeToMenu(IMenuManager theMenuManager) {
        super.contributeToMenu(theMenuManager);
        IContributionItem item = theMenuManager.find(ModelerActionBarIdManager.getEditMenuId());
        if (item != null && item instanceof IMenuManager) {
            this.editMenu = (IMenuManager)item;
        }
    }

    private IAction getRegisteredAction(String theActionId) {
        String key;
        IAction result = null;
        ActionService actionService = this.getActionService();
        if (actionService.isRegistered(key = DiagramActionService.constructKey(theActionId, this.getEditorPage()))) {
            try {
                result = actionService.getAction(key);
            }
            catch (CoreException coreException) {
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "actionProblem", new Object[]{theActionId}));
            }
        }
        return result;
    }

    private void registerAction(AbstractAction theAction) {
        DiagramUiPlugin.registerDiagramActionForSelection((ISelectionListener)theAction);
        String actionKey = DiagramActionService.constructKey((IAction)theAction, this.getEditorPage());
        this.getActionService().registerAction(actionKey, (IAction)theAction);
        this.allRegisteredActions.put(theAction, actionKey);
    }

    protected void unregisterAction(AbstractAction theAction) {
        DiagramUiPlugin.unregisterDiagramActionForSelection((ISelectionListener)theAction);
        String actionKey = this.allRegisteredActions.get(theAction);
        this.getActionService().removeAction(actionKey);
    }

    private void initActions() {
        this.diagramGroupStart = new GroupMarker("diagramStart");
        this.contributionItems.add((ContributionItem)this.diagramGroupStart);
        Object action = (AbstractAction)this.getRegisteredAction(ZoomInWrapper.class.getName());
        if (action == null) {
            action = new ZoomInWrapper();
            this.registerAction((AbstractAction)action);
        }
        this.zoomIn = this.createActionContributionItem((IAction)action);
        action = (AbstractAction)this.getRegisteredAction(ZoomOutWrapper.class.getName());
        if (action == null) {
            action = new ZoomOutWrapper();
            this.registerAction((AbstractAction)action);
        }
        this.zoomOut = this.createActionContributionItem((IAction)action);
        action = (AbstractAction)this.getRegisteredAction(ZoomComboWrapper.class.getName());
        if (action == null) {
            action = new ZoomComboWrapper();
            this.registerAction((AbstractAction)action);
        }
        this.zoomCombo = new ZoomComboActionContributeItem((IAction)action, DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getPartService());
        this.contributionItems.add((ContributionItem)this.zoomCombo);
        action = (AbstractAction)this.getRegisteredAction(FontUpWrapper.class.getName());
        if (action == null) {
            action = new FontUpWrapper((DiagramEditor)this.getEditorPage());
            this.registerAction((AbstractAction)action);
        }
        this.fontUp = this.createActionContributionItem((IAction)action);
        action = (AbstractAction)this.getRegisteredAction(FontDownWrapper.class.getName());
        if (action == null) {
            action = new FontDownWrapper((DiagramEditor)this.getEditorPage());
            this.registerAction((AbstractAction)action);
        }
        this.fontDown = this.createActionContributionItem((IAction)action);
        action = (AbstractAction)this.getRegisteredAction(AutoLayoutWrapper.class.getName());
        if (action == null) {
            action = new AutoLayoutWrapper();
            this.registerAction((AbstractAction)action);
        }
        this.autoLayout = this.createActionContributionItem((IAction)action);
        this.diagramGroupEnd = new GroupMarker("diagramEnd");
        this.contributionItems.add((ContributionItem)this.diagramGroupEnd);
        this.actionsMap.put(IActionConstants.EclipseGlobalActions.PRINT, this.getAction(IActionConstants.EclipseGlobalActions.PRINT));
    }

    private IAction getAction(String sActionId) {
        try {
            return this.getActionService().getAction(sActionId);
        }
        catch (CoreException ce) {
            String message = String.valueOf(this.getClass().getName()) + ":  getAction() error  ";
            DiagramUiConstants.Util.log(4, (Throwable)ce, message);
            return null;
        }
    }

    private ActionContributionItem createActionContributionItem(IAction theAction) {
        ActionContributionItem item = new ActionContributionItem(theAction);
        item.setVisible(false);
        this.contributionItems.add((ContributionItem)item);
        return item;
    }

    public ActionService getActionService() {
        return DiagramUiPlugin.getDefault().getActionService(this.getEditorPage().getSite().getPage());
    }

    public void createContextMenu() {
        MenuManager mgr = new MenuManager(this.CONTEXT_MENU_ID, this.CONTEXT_MENU_ID);
        mgr.setRemoveAllWhenShown(true);
        Menu contextMenu = mgr.createContextMenu(this.getEditorPage().getControl());
        this.getEditorPage().getControl().setMenu(contextMenu);
        mgr.addMenuListener((IMenuListener)this);
    }

    public void menuAboutToShow(IMenuManager theMenuMgr) {
        ISelectionProvider selProvider = this.getEditorPage().getModelObjectSelectionProvider();
        boolean override = false;
        IDiagramActionAdapter diagramActionAdapter = this.getCurrentDiagramActionAdapter();
        if (diagramActionAdapter != null) {
            override = diagramActionAdapter.shouldOverrideMenu(selProvider.getSelection());
        }
        if (!override) {
            this.getActionService().contributeToContextMenu(theMenuMgr, this.getGlobalActions(), null);
        }
        if (diagramActionAdapter != null) {
            diagramActionAdapter.contributeToMenuManager(theMenuMgr, selProvider.getSelection());
        }
        if (!override) {
            if (theMenuMgr.find("additions") == null) {
                theMenuMgr.add((IContributionItem)new Separator("additions"));
            }
            if (this.popupMenuExtender == null) {
                IEditorPart editor = ((ModelEditorSite)this.getEditorPage().getEditorSite()).getEditor();
                this.popupMenuExtender = new ControlledPopupMenuExtender(this.CONTEXT_MENU_ID, (MenuManager)theMenuMgr, selProvider, (IWorkbenchPart)editor);
            }
            this.popupMenuExtender.menuAboutToShow(theMenuMgr);
        }
    }

    private IDiagramActionAdapter getCurrentDiagramActionAdapter() {
        ModelEditorPage mep = this.getEditorPage();
        IDiagramActionAdapter idapDiagramActionAdapter = (IDiagramActionAdapter)mep.getAdapter(IDiagramActionAdapter.class);
        return idapDiagramActionAdapter;
    }

    private void initDiagramGLobalActionDetails() {
        if (this.firstTime) {
            IAction action = null;
            int i = 0;
            while (i < DiagramGlobalActionsMap.ALL_DIAGRAM_GLOBAL_ACTIONS.length) {
                String actionId = DiagramGlobalActionsMap.ALL_DIAGRAM_GLOBAL_ACTIONS[i];
                try {
                    action = this.getActionService().getAction(actionId);
                }
                catch (CoreException coreException) {
                    System.out.println("[DiagramActionContributor] actionService.getAction failed");
                }
                if (action instanceof ActionWrapper) {
                    ((ActionWrapper)action).initialize();
                }
                ++i;
            }
            this.firstTime = false;
        }
    }

    public void pageActivated() {
        IDiagramActionAdapter diagramActionAdapter = this.getCurrentDiagramActionAdapter();
        if (diagramActionAdapter != this.cachedAdapter && this.cachedAdapter != null && this.cachedAdapter instanceof AbstractModelEditorPageActionBarContributor) {
            ((AbstractModelEditorPageActionBarContributor)this.cachedAdapter).pageDeactivated();
        }
        if (diagramActionAdapter != null && diagramActionAdapter instanceof AbstractModelEditorPageActionBarContributor) {
            this.cachedAdapter = diagramActionAdapter;
            this.initDiagramGLobalActionDetails();
            if (!this.contributors.contains(this.cachedAdapter)) {
                this.contributors.add(this.cachedAdapter);
                this.cachedAdapter.contributeExportedActions(this.editMenu);
            }
            ((AbstractModelEditorPageActionBarContributor)diagramActionAdapter).pageActivated();
            this.editMenu.update(true);
        }
        this.contributeToToolBar(this.actionBars.getToolBarManager());
        this.setActionsVisible(true);
        this.getActionBars().updateActionBars();
        if (this.zoomCombo != null) {
            ((ZoomComboActionContributeItem)this.zoomCombo).refreshText();
        }
    }

    public void pageDeactivated() {
        IDiagramActionAdapter diagramActionAdapter = this.getCurrentDiagramActionAdapter();
        if (diagramActionAdapter != null && diagramActionAdapter instanceof AbstractModelEditorPageActionBarContributor) {
            ((AbstractModelEditorPageActionBarContributor)diagramActionAdapter).pageDeactivated();
        }
        this.setActionsVisible(false);
        this.decontributeToToolBar(this.actionBars.getToolBarManager());
        this.getActionBars().updateActionBars();
    }

    private void setActionsVisible(boolean theShowFlag) {
        int size = this.contributionItems.size();
        int i = 0;
        while (i < size) {
            ContributionItem item = this.contributionItems.get(i);
            item.setVisible(theShowFlag);
            ++i;
        }
        if (this.getActionBars() != null && this.getActionBars().getToolBarManager() != null) {
            this.getActionBars().getToolBarManager().update(true);
        }
    }

    public void decontributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.remove((IContributionItem)this.diagramGroupStart);
        toolBarManager.remove((IContributionItem)this.zoomIn);
        toolBarManager.remove((IContributionItem)this.zoomCombo);
        toolBarManager.remove((IContributionItem)this.zoomOut);
        toolBarManager.remove((IContributionItem)this.fontUp);
        toolBarManager.remove((IContributionItem)this.fontDown);
        toolBarManager.remove((IContributionItem)this.autoLayout);
        toolBarManager.remove((IContributionItem)this.diagramGroupEnd);
        this.contributed = false;
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        if (!this.contributed) {
            super.contributeToToolBar(toolBarManager);
            if (toolBarManager.find(this.diagramGroupStart.getId()) == null) {
                toolBarManager.add((IContributionItem)this.diagramGroupStart);
            }
            toolBarManager.appendToGroup("diagramStart", (IContributionItem)this.zoomIn);
            toolBarManager.appendToGroup("diagramStart", (IContributionItem)this.zoomCombo);
            toolBarManager.appendToGroup("diagramStart", (IContributionItem)this.zoomOut);
            toolBarManager.appendToGroup("diagramStart", (IContributionItem)this.fontUp);
            toolBarManager.appendToGroup("diagramStart", (IContributionItem)this.fontDown);
            toolBarManager.appendToGroup("diagramStart", (IContributionItem)this.autoLayout);
            if (toolBarManager.find(this.diagramGroupEnd.getId()) == null) {
                toolBarManager.add((IContributionItem)this.diagramGroupEnd);
            }
            this.contributed = true;
        }
    }

    public void dispose() {
        if (this.popupMenuExtender != null) {
            this.popupMenuExtender.dispose();
        }
        for (AbstractAction theAction : this.allRegisteredActions.keySet()) {
            this.unregisterAction(theAction);
        }
        ActionService service = this.getActionService();
        IToolBarManager tbMgr = this.getActionBars().getToolBarManager();
        int size = this.contributionItems.size();
        int i = 0;
        while (i < size) {
            ContributionItem item = this.contributionItems.get(i);
            tbMgr.remove((IContributionItem)item);
            if (item instanceof ActionContributionItem) {
                service.removeAction(DiagramActionService.constructKey(((ActionContributionItem)item).getAction(), this.getEditorPage()));
            }
            ++i;
        }
        tbMgr.update(true);
    }

    public List<IAction> getAdditionalModelingActions(ISelection theSelection) {
        MenuManager menu = new MenuManager("TempMenu", "TempMenuID");
        ArrayList<IAction> theActions = new ArrayList<IAction>();
        this.contributeExportedActions((IMenuManager)menu);
        IContributionItem[] theItems = menu.getItems();
        if (theItems != null && theItems.length > 0) {
            int i = 0;
            while (i < theItems.length) {
                theActions.add((IAction)theItems[i]);
                ++i;
            }
        }
        return theActions;
    }

    public void contributeExportedActions(IMenuManager theMenuMgr) {
        if (this.CONTEXT_MENU_ID.equals(theMenuMgr.getId())) {
            return;
        }
        IDiagramActionAdapter diagramActionAdapter = this.getCurrentDiagramActionAdapter();
        if (diagramActionAdapter != null) {
            diagramActionAdapter.contributeExportedActions(theMenuMgr);
            theMenuMgr.update();
        }
    }

    public void tellZoomWrappersToClose() {
        ((ZoomInWrapper)this.zoomIn.getAction()).closeZoomManager();
        ((ZoomOutWrapper)this.zoomOut.getAction()).closeZoomManager();
    }
}

