/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.custom.CustomDiagramNode;
import org.teiid.designer.diagram.ui.custom.CustomDiagramNotificationHelper;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.LabelModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramModelFactory;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.AbstractDiagramEntity;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramLink;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CustomDiagramModelFactory
extends PackageDiagramModelFactory {
    private static final String KEY_CUSTOM_DIAGRAM_NAME = "DiagramNames.customDiagram";
    private static final String THIS_CLASS = "CustomDiagramModelFactory";
    private String errorMessage;

    @Override
    public DiagramModelNode createModel(Object baseObject, String sNotationId, IProgressMonitor monitor) {
        if (!(baseObject instanceof Diagram)) {
            return null;
        }
        HashMap<EObject, DiagramModelNode> nodeMap = new HashMap<EObject, DiagramModelNode>();
        this.setSNotationId(sNotationId);
        Diagram diagram = (Diagram)baseObject;
        CustomDiagramNode diagramModelNode = null;
        List contents = null;
        diagramModelNode = new CustomDiagramNode((EObject)diagram, Util.getString(KEY_CUSTOM_DIAGRAM_NAME, new Object[0]));
        contents = this.getDiagramContents(diagram);
        if (!contents.isEmpty()) {
            Iterator iter = contents.iterator();
            if (this.getGenerator() != null) {
                while (iter.hasNext()) {
                    this.errorMessage = null;
                    EObject eObj = (EObject)iter.next();
                    DiagramModelNode childModelNode = this.getGenerator().createModel(eObj, diagram);
                    if (childModelNode != null) {
                        nodeMap.put(eObj, childModelNode);
                        childModelNode.setParent(diagramModelNode);
                        diagramModelNode.addChild(childModelNode);
                        diagramModelNode.update("children");
                        diagramModelNode.update("layout");
                        continue;
                    }
                    String name = DiagramUiUtilities.getEObjectLabel(eObj);
                    this.errorMessage = String.valueOf(Util.getString("DiagramErrors.modelNodeFailure", new Object[0])) + " for object = " + name;
                    Util.log(2, this.errorMessage);
                }
            } else {
                Util.log(2, Util.getString("DiagramErrors.modelGeneratorFailure", new Object[0]));
            }
            if (!diagramModelNode.getChildren().isEmpty()) {
                HashMap<EObject, NodeConnectionModel> connMap = new HashMap<EObject, NodeConnectionModel>();
                ArrayList<NodeConnectionModel> realAssociations = new ArrayList<NodeConnectionModel>();
                List currentChildren = diagramModelNode.getChildren();
                for (DiagramModelNode childModelNode : currentChildren) {
                    List childAssList = childModelNode.getAssociations(nodeMap);
                    NodeConnectionModel nextConnection = null;
                    NodeConnectionModel nextRealConnection = null;
                    Iterator innerIter = null;
                    Iterator subIter = childAssList.iterator();
                    while (subIter.hasNext()) {
                        boolean connExists = false;
                        nextConnection = (NodeConnectionModel)subIter.next();
                        if (nextConnection.getModelObject() != null) {
                            Object existingConn = connMap.get(nextConnection.getModelObject());
                            if (existingConn != null) {
                                connExists = true;
                            }
                        } else {
                            innerIter = realAssociations.iterator();
                            while (innerIter.hasNext() && !connExists) {
                                nextRealConnection = (NodeConnectionModel)innerIter.next();
                                if (nextRealConnection == null || !nextRealConnection.equals(nextConnection)) continue;
                                connExists = true;
                            }
                        }
                        if (connExists) continue;
                        if (nextConnection.getModelObject() != null) {
                            connMap.put(nextConnection.getModelObject(), nextConnection);
                        }
                        realAssociations.add(nextConnection);
                    }
                }
                for (NodeConnectionModel nextAssociation : realAssociations) {
                    ((DiagramModelNode)nextAssociation.getSourceNode()).addSourceConnection(nextAssociation);
                    ((DiagramModelNode)nextAssociation.getTargetNode()).addTargetConnection(nextAssociation);
                    List labelNodes = nextAssociation.getLabelNodes();
                    if (labelNodes == null || labelNodes.isEmpty()) continue;
                    Iterator labelIter = labelNodes.iterator();
                    LabelModelNode nextNode = null;
                    while (labelIter.hasNext()) {
                        nextNode = (LabelModelNode)labelIter.next();
                        diagramModelNode.addChild(nextNode);
                    }
                }
            }
        }
        return diagramModelNode;
    }

    @Override
    protected boolean currentDiagramRemoved(Diagram theDiagram) {
        boolean isRemoved = false;
        if (theDiagram == null) {
            isRemoved = true;
        } else if (theDiagram.eResource() == null) {
            isRemoved = true;
            if (theDiagram.eContainer() == null && this.diagramIsTransient(theDiagram)) {
                isRemoved = false;
            }
        }
        return isRemoved;
    }

    private List getDiagramContents(Diagram customDiagram) {
        List<EObject> contents = new ArrayList();
        if (customDiagram != null) {
            EList diagramChildren = customDiagram.eContents();
            if (diagramChildren != null && !diagramChildren.isEmpty()) {
                AbstractDiagramEntity nextDE2 = null;
                for (AbstractDiagramEntity nextDE2 : diagramChildren) {
                    if (nextDE2 instanceof DiagramLink || nextDE2.getModelObject() == null) continue;
                    contents.add(nextDE2.getModelObject());
                }
            } else {
                contents = Collections.EMPTY_LIST;
            }
        }
        return contents;
    }

    private boolean isValidDiagram(DiagramModelNode diagramModelNode) {
        String type;
        ModelResource mr;
        boolean result = false;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (diagram != null && diagram.getTarget() != null && (mr = ModelUtilities.getModelResourceForModelObject((EObject)diagram)) != null && (type = diagram.getType()) != null && type.equals("customDiagramType")) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean notifyModel(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        boolean currentDiagramOK = true;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (this.currentDiagramRemoved(diagram)) {
            currentDiagramOK = false;
        }
        if (currentDiagramOK && this.isValidDiagram(diagramModelNode) && this.shouldHandleNotification(notification, diagramModelNode)) {
            boolean requiredStart = false;
            boolean succeeded = false;
            boolean handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction(diagram);
            try {
                try {
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramUnderConstruction(diagram);
                    }
                    requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Update Custom Diagram", (Object)this);
                    CustomDiagramNotificationHelper helper = new CustomDiagramNotificationHelper(notification, (Diagram)diagramModelNode.getModelObject(), this);
                    this.handleMoves(helper.getMovedEObjects(), diagramModelNode);
                    this.handleAdds(helper.getAddNotifications(), diagramModelNode);
                    this.handleRemoves(helper.getRemoveNotifications(), diagramModelNode);
                    this.handleChanges(helper.getChangedNotifications(), diagramModelNode);
                    this.add(new ArrayList(helper.getUndoAddedEObjects()), diagramModelNode);
                    succeeded = true;
                }
                catch (Exception ex) {
                    DiagramUiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".notifyModel()");
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                        }
                    }
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                    }
                }
            }
        }
        return currentDiagramOK;
    }

    private boolean shouldHandleNotification(Notification notification, DiagramModelNode diagramModelNode) {
        boolean shouldHandle = false;
        Diagram currentDiagram = (Diagram)diagramModelNode.getModelObject();
        ModelResource diagramMR = ModelUtilities.getModelResourceForModelObject((EObject)currentDiagram);
        if (diagramMR != null) {
            if (notification instanceof SourcedNotification) {
                Object source = ((SourcedNotification)notification).getSource();
                if (source == null || !source.equals(this)) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    Iterator iter = notifications.iterator();
                    Notification nextNotification = null;
                    while (iter.hasNext() && !shouldHandle) {
                        nextNotification = (Notification)iter.next();
                        Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                        if (targetObject == null || !(targetObject instanceof EObject)) continue;
                        shouldHandle = true;
                    }
                }
            } else {
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
                if (targetObject != null && targetObject instanceof EObject) {
                    shouldHandle = true;
                }
            }
        }
        return shouldHandle;
    }

    @Override
    public Diagram getDiagram(EObject someTarget) {
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)someTarget);
        try {
            List returnedDiagrams = modelResource.getModelDiagrams().getDiagrams(someTarget);
            if (returnedDiagrams.size() == 1) {
                return (Diagram)returnedDiagrams.get(0);
            }
            for (Diagram nextDiagram : returnedDiagrams) {
                if (nextDiagram.getType() == null || !nextDiagram.getType().equals("customDiagramType")) continue;
                return nextDiagram;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void add(EObject someTarget, DiagramModelNode customDiagramModelNode, boolean updateAssociations) {
        DiagramModelNode newNode = this.getGenerator().createModel(someTarget, (Diagram)customDiagramModelNode.getModelObject());
        if (newNode != null) {
            customDiagramModelNode.addChild(newNode);
            if (updateAssociations) {
                this.updateAssociations(customDiagramModelNode, customDiagramModelNode);
            }
        }
    }

    public void add(List targets, DiagramModelNode customDiagramModelNode) {
        Iterator iter = targets.iterator();
        EObject nextTarget = null;
        ArrayList<DiagramModelNode> newChildren = new ArrayList<DiagramModelNode>(targets.size());
        while (iter.hasNext()) {
            nextTarget = (EObject)iter.next();
            DiagramModelNode newNode = this.getGenerator().createModel(nextTarget, (Diagram)customDiagramModelNode.getModelObject());
            if (newNode == null) continue;
            newNode.setParent(customDiagramModelNode);
            newChildren.add(newNode);
        }
        if (!newChildren.isEmpty()) {
            customDiagramModelNode.addChildren(newChildren);
            this.updateAssociations(customDiagramModelNode, customDiagramModelNode);
        }
    }

    @Override
    protected void updateAssociations(DiagramModelNode diagramModelNode, DiagramModelNode diagramNode) {
        super.updateAssociations(diagramModelNode, diagramNode);
        HashMap nodeMap = this.getNodeMap(diagramNode);
        if (diagramModelNode instanceof CustomDiagramNode) {
            NodeConnectionModel nextAssociation2 = null;
            ArrayList realAssociations = new ArrayList();
            List currentChildren = diagramModelNode.getChildren();
            for (DiagramModelNode childModelNode : currentChildren) {
                List allAssociations;
                if (childModelNode == null || (allAssociations = childModelNode.getAssociations(nodeMap)) == null || allAssociations.isEmpty()) continue;
                Iterator subIter = allAssociations.iterator();
                Object nextAss = null;
                while (subIter.hasNext()) {
                    nextAss = subIter.next();
                    if (realAssociations.contains(nextAss)) continue;
                    realAssociations.add(nextAss);
                }
            }
            List staleAssociations = this.getStaleAssociations(realAssociations, diagramModelNode);
            ArrayList changedNodes = new ArrayList(this.cleanUpStaleAssociations(staleAssociations, diagramModelNode));
            HashMap<Object, String> updatedNodes = new HashMap<Object, String>();
            Iterator<Object> iter = changedNodes.iterator();
            while (iter.hasNext()) {
                updatedNodes.put(iter.next(), "x");
            }
            for (NodeConnectionModel nextAssociation2 : realAssociations) {
                List labelNodes;
                if (this.associationExists(diagramModelNode, nextAssociation2)) continue;
                ((DiagramModelNode)nextAssociation2.getSourceNode()).addSourceConnection(nextAssociation2);
                ((DiagramModelNode)nextAssociation2.getTargetNode()).addTargetConnection(nextAssociation2);
                if (updatedNodes.get(nextAssociation2.getSourceNode()) == null) {
                    updatedNodes.put(nextAssociation2.getSourceNode(), "x");
                }
                if (updatedNodes.get(nextAssociation2.getTargetNode()) == null) {
                    updatedNodes.put(nextAssociation2.getTargetNode(), "x");
                }
                if ((labelNodes = nextAssociation2.getLabelNodes()) == null || labelNodes.isEmpty()) continue;
                Iterator labelIter = labelNodes.iterator();
                LabelModelNode nextNode = null;
                while (labelIter.hasNext()) {
                    nextNode = (LabelModelNode)labelIter.next();
                    diagramModelNode.addChild(nextNode);
                }
            }
            for (NodeConnectionModel nextAssociation2 : this.getCurrentAssociations(diagramModelNode)) {
                nextAssociation2.updateLabels();
                ((DiagramModelNode)nextAssociation2.getSourceNode()).updateAssociations();
                ((DiagramModelNode)nextAssociation2.getTargetNode()).updateAssociations();
            }
            if (!updatedNodes.isEmpty()) {
                iter = updatedNodes.keySet().iterator();
                DiagramModelNode nextNode = null;
                while (iter.hasNext()) {
                    nextNode = (DiagramModelNode)iter.next();
                    nextNode.updateAssociations();
                }
            }
        }
    }

    public void remove(List targets, DiagramModelNode customDiagramModelNode) {
        Iterator iter = targets.iterator();
        EObject nextTarget = null;
        ArrayList<DiagramModelNode> oldChildren = new ArrayList<DiagramModelNode>(targets.size());
        while (iter.hasNext()) {
            nextTarget = (EObject)iter.next();
            DiagramModelNode oldNode = this.getModelNode(customDiagramModelNode, nextTarget);
            if (oldNode == null) continue;
            this.removeAllAssociationsFromNode(oldNode, customDiagramModelNode);
            oldChildren.add(oldNode);
        }
        if (!oldChildren.isEmpty()) {
            customDiagramModelNode.removeChildren(oldChildren, true);
        }
    }

    public void clear(DiagramModelNode customDiagramModelNode) {
        ArrayList currentChildren = new ArrayList(customDiagramModelNode.getChildren());
        if (!currentChildren.isEmpty()) {
            Iterator iter = currentChildren.iterator();
            DiagramModelNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = (DiagramModelNode)iter.next();
                if (nextNode == null) continue;
                this.removeAllAssociationsFromNode(nextNode, customDiagramModelNode);
            }
            if (!currentChildren.isEmpty()) {
                customDiagramModelNode.removeChildren(currentChildren, true);
            }
        }
    }

    private void performAdd(Notification notification, DiagramModelNode customDiagramModelNode) {
        boolean performedChange = false;
        if (NotificationUtilities.isEObjectNotifier((Notification)notification)) {
            Object target = ModelerCore.getModelEditor().getChangedObject(notification);
            if (!(target instanceof EObject) || target instanceof Diagram || target instanceof AbstractDiagramEntity) {
                return;
            }
            EObject targetObject = (EObject)target;
            if (NotificationUtilities.addedChildrenParentIsNotifier((Notification)notification)) {
                EObject parentEObject;
                DiagramModelNode parentNode;
                EObject[] newChildren;
                boolean isNested = false;
                DiagramModelNode targetNode = this.getNodeInDiagram(customDiagramModelNode, targetObject);
                if (targetNode == null) {
                    isNested = true;
                    targetNode = this.getModelNode(customDiagramModelNode, targetObject);
                }
                if (targetNode != null && (newChildren = NotificationUtilities.getAddedChildren((Notification)notification)).length > 0) {
                    EObject childParent = newChildren[0].eContainer();
                    DiagramModelNode parentNode2 = this.getModelNode(customDiagramModelNode, childParent);
                    if (parentNode2 != null) {
                        if (parentNode2 instanceof UmlClassifierNode) {
                            ((UmlClassifierNode)parentNode2).reconcile();
                        } else {
                            int iChild = 0;
                            while (iChild < newChildren.length) {
                                DiagramModelNode newNode = this.getGenerator().createChildModel(parentNode2, newChildren[iChild]);
                                if (newNode != null) {
                                    performedChange = true;
                                }
                                ++iChild;
                            }
                        }
                    }
                    if (performedChange) {
                        this.updateAssociations(parentNode2, customDiagramModelNode);
                    }
                }
                if (isNested && (parentNode = this.getModelNode(customDiagramModelNode, parentEObject = targetObject.eContainer())) != null) {
                    parentNode.updateForChild(false);
                }
            }
        }
    }

    private void performRemove(Notification notification, DiagramModelNode customDiagramModelNode) {
        if (NotificationUtilities.isEObjectNotifier((Notification)notification)) {
            Object target = ModelerCore.getModelEditor().getChangedObject(notification);
            if (!(target instanceof EObject) || target instanceof Diagram || target instanceof AbstractDiagramEntity) {
                return;
            }
            EObject targetObject = (EObject)target;
            DiagramModelNode parentNode = this.getModelNode(customDiagramModelNode, targetObject);
            DiagramModelNode removedNode = null;
            EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            int iChild = 0;
            while (iChild < removedChildren.length) {
                removedNode = this.getModelNode(customDiagramModelNode, removedChildren[iChild]);
                if (removedNode != null) {
                    if (parentNode != null) {
                        if (!(parentNode instanceof UmlClassifierNode)) {
                            parentNode.removeChild(removedNode, false);
                        }
                        this.updateAssociations(parentNode, customDiagramModelNode);
                    } else {
                        this.removeAllAssociationsFromNode(removedNode, customDiagramModelNode);
                        customDiagramModelNode.removeChild(removedNode, false);
                    }
                }
                ++iChild;
            }
            if (parentNode != null && parentNode instanceof UmlClassifierNode) {
                ((UmlClassifierNode)parentNode).reconcile();
            }
        } else {
            Object target = ModelerCore.getModelEditor().getChangedObject(notification);
            if (target instanceof Resource) {
                DiagramModelNode removedNode = null;
                EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
                int iChild = 0;
                while (iChild < removedChildren.length) {
                    removedNode = this.getModelNode(customDiagramModelNode, removedChildren[iChild]);
                    if (removedNode != null) {
                        this.removeAllAssociationsFromNode(removedNode, customDiagramModelNode);
                        customDiagramModelNode.removeChild(removedNode, false);
                    }
                    ++iChild;
                }
            }
        }
    }

    @Override
    protected void performChange(Notification notification, DiagramModelNode customDiagramModelNode) {
        super.performChange(notification, customDiagramModelNode);
        EObject targetObject = NotificationUtilities.getEObject((Notification)notification);
        if (targetObject != null) {
            List diagramChildren = this.getDiagramContents((Diagram)customDiagramModelNode.getModelObject());
            Iterator iter = diagramChildren.iterator();
            EObject modelEObject = null;
            Object nextObj = null;
            while (iter.hasNext()) {
                DiagramModelNode targetNode;
                nextObj = iter.next();
                if (!(nextObj instanceof EObject) || !ModelObjectUtilities.isDescendant((EObject)targetObject, (EObject)(modelEObject = (EObject)nextObj)) || (targetNode = this.getModelNode(customDiagramModelNode, modelEObject)) == null) continue;
                this.getGenerator().performUpdate(targetNode, null);
                targetNode.update("size");
                targetNode.update("name");
            }
        }
    }

    private void handleMoves(Collection movedEObjects, DiagramModelNode customDiagramModelNode) {
        if (movedEObjects != null && !movedEObjects.isEmpty()) {
            DiagramModelNode targetNode = null;
            EObject nextEObj2 = null;
            for (EObject nextEObj2 : movedEObjects) {
                targetNode = this.getModelNode(customDiagramModelNode, nextEObj2);
                if (targetNode == null) continue;
                this.getGenerator().performUpdate(targetNode, null);
            }
        }
    }

    private void handleRemoves(Collection removeNotifications, DiagramModelNode customDiagramModelNode) {
        if (removeNotifications != null && !removeNotifications.isEmpty()) {
            Notification nextNotification2 = null;
            for (Notification nextNotification2 : removeNotifications) {
                this.performRemove(nextNotification2, customDiagramModelNode);
            }
        }
    }

    private void handleAdds(Collection addNotifications, DiagramModelNode customDiagramModelNode) {
        if (addNotifications != null && !addNotifications.isEmpty()) {
            Notification nextNotification2 = null;
            for (Notification nextNotification2 : addNotifications) {
                this.performAdd(nextNotification2, customDiagramModelNode);
            }
        }
    }

    private void handleChanges(Collection changeNotifications, DiagramModelNode customDiagramModelNode) {
        if (changeNotifications != null && !changeNotifications.isEmpty()) {
            Notification nextNotification2 = null;
            for (Notification nextNotification2 : changeNotifications) {
                this.performChange(nextNotification2, customDiagramModelNode);
            }
        }
    }
}

