/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.PluginConstants;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;

public class CustomDiagramLabelProvider
extends LabelProvider
implements ILightweightLabelDecorator,
DiagramUiConstants,
PluginConstants.Images {
    private ILabelProvider defaultProvider;

    private ILabelProvider getDefaultProvider() {
        if (this.defaultProvider == null) {
            this.defaultProvider = new WorkbenchLabelProvider();
        }
        return this.defaultProvider;
    }

    public Image getImage(Object element) {
        block4: {
            try {
                if (element instanceof Diagram) {
                    if (((Diagram)element).getType() != null && ((Diagram)element).getType().equals("customDiagramType")) {
                        return DiagramUiPlugin.getDefault().getImage("icons/full/cview16/custom_diagram.gif");
                    }
                    break block4;
                }
                return this.getDefaultProvider().getImage(element);
            }
            catch (Exception err) {
                Util.log((Throwable)err);
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof Diagram && ((Diagram)element).getType() != null && ((Diagram)element).getType().equals("customDiagramType")) {
            String name = ModelerCore.getModelEditor().getName((EObject)element);
            if (name != null) {
                return name;
            }
            return Util.getString("DiagramNames.customDiagram", new Object[0]);
        }
        return this.getDefaultProvider().getText(element);
    }

    public void decorate(Object element, IDecoration decoration) {
        IResource resrc = this.getResource(element);
        if (resrc == null || !resrc.exists() || resrc instanceof IProject && !((IProject)resrc).isOpen()) {
            return;
        }
        try {
            IMarker[] markers = resrc.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            ImageDescriptor icon = null;
            int ndx = markers.length;
            while (--ndx >= 0) {
                Object attr = MarkerUtilities.getMarkerAttribute((IMarker)markers[ndx], (String)"severity");
                if (attr == null) continue;
                int severity = (Integer)attr;
                if (severity == 2) {
                    icon = DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/ovr16/error_co.gif");
                    break;
                }
                if (icon != null || severity != 1) continue;
                icon = DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/ovr16/warning_co.gif");
            }
            if (icon != null) {
                decoration.addOverlay(icon);
            }
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
        }
    }

    private IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IAdaptable) {
            return (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }
}

