/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.custom.CustomDiagramNode;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigureFactory;
import org.teiid.designer.diagram.ui.notation.NotationFigureGenerator;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;

public class CustomDiagramFigureFactory
extends AbstractDiagramFigureFactory
implements DiagramUiConstants {
    private static final int CUSTOM_DIAGRAM = 0;

    @Override
    public Figure createFigure(Object modelObject, String sNotationId) {
        FreeformLayer newFigure = null;
        switch (this.getObjectType(modelObject)) {
            case 0: {
                newFigure = new FreeformLayer();
                newFigure.setLayoutManager((LayoutManager)new FreeformLayout());
                newFigure.setOpaque(true);
                RGB currentBkgdColor = PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.custom.backgroundcolor");
                newFigure.setBackgroundColor(GlobalUiColorManager.getColor((RGB)currentBkgdColor));
                break;
            }
            default: {
                NotationFigureGenerator generator = DiagramUiPlugin.getDiagramNotationManager().getFigureGenerator(sNotationId);
                if (generator != null) {
                    newFigure = generator.createFigure(modelObject);
                    break;
                }
                ModelerCore.Util.log(4, Util.getString("DiagramErrors.figureGeneratorFailure", new Object[0]));
            }
        }
        return newFigure;
    }

    protected int getObjectType(Object modelObject) {
        int objectType = -1;
        if (modelObject != null && modelObject instanceof CustomDiagramNode) {
            objectType = 0;
        }
        return objectType;
    }
}

