/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.connection;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Font;
import org.teiid.designer.core.metamodel.aspect.uml.UmlAssociation;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.connection.BinaryAssociation;
import org.teiid.designer.diagram.ui.connection.LinkBendpoint;
import org.teiid.designer.diagram.ui.connection.NodeConnectionAnchor;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.figure.DiagramFigure;
import org.teiid.designer.diagram.ui.figure.LabeledRectangleFigure;
import org.teiid.designer.diagram.ui.model.AssociationLabelModelNode;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.LabelModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramLinkAdapter;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramLink;
import org.teiid.designer.metamodels.diagram.DiagramLinkType;

public class DiagramUmlAssociation
implements NodeConnectionModel {
    private DiagramLink diagramLink;
    private BinaryAssociation bAssociation;
    private DiagramModelNode sourceNode;
    private DiagramModelNode targetNode;
    private boolean showRoles = true;
    private boolean showMultiplicity = true;
    private boolean showName = true;
    private List sourceLabelNodes;
    private List targetLabelNodes;
    private LabelModelNode sourceRoleName;
    private LabelModelNode targetRoleName;
    private LabelModelNode sourceMultiplicity;
    private LabelModelNode targetMultiplicity;
    private LabelModelNode name;
    private LabelModelNode stereotype;
    private static Font currentLabelFont = ScaledFontManager.getFont(-1);
    private String sName;
    private static final String STEREOTYPE_BEGIN = "<<";
    private static final String STEREOTYPE_END = ">>";
    private static final int DELTA_X = 6;
    private static final int DELTA_Y = 4;
    private static final int ABOVE_THE_LINE = 1;
    private static final int BELOW_THE_LINE = 2;
    private static final int LEFT_OF_SEGMENT = 1;
    private static final int CENTERED_ON_SEGMENT = 2;
    private static final int RIGHT_OF_SEGMENT = 3;
    private static final int CENTERED_ON_RIGHT_ENDPOINT = 4;
    private static final int CENTERED_ON_LEFT_ENDPOINT = 5;
    private String sRouterStyle;
    protected List bendpoints = new ArrayList();
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public DiagramUmlAssociation(DiagramModelNode source, DiagramModelNode target, BinaryAssociation bAss) {
        this.bAssociation = bAss;
        this.setSourceNode(source);
        this.setTargetNode(target);
        this.init();
    }

    public DiagramUmlAssociation(DiagramModelNode sourceNode, DiagramModelNode targetNode, BinaryAssociation bAss, String sName) {
        this.bAssociation = bAss;
        this.sName = sName;
        this.setSourceNode(sourceNode);
        this.setTargetNode(targetNode);
        this.init();
    }

    private void init() {
        DiagramLink dLink;
        if (this.bAssociation.getRoleName(0) != null) {
            this.sourceRoleName = new AssociationLabelModelNode(this.bAssociation.getRoleName(0), 1);
        }
        if (this.bAssociation.getRoleName(1) != null) {
            this.targetRoleName = new AssociationLabelModelNode(this.bAssociation.getRoleName(1), 2);
        }
        if (this.bAssociation.getMultiplicity(0) != null) {
            this.sourceMultiplicity = new AssociationLabelModelNode(this.bAssociation.getMultiplicity(0), 3);
        }
        if (this.bAssociation.getMultiplicity(1) != null) {
            this.targetMultiplicity = new AssociationLabelModelNode(this.bAssociation.getMultiplicity(1), 4);
        }
        if (this.sName != null) {
            this.name = new AssociationLabelModelNode(this.sName, 0);
        }
        this.createAdditionalLabelNodes();
        Diagram diagram = this.getDiagram();
        if (diagram != null && (dLink = DiagramUiUtilities.findDiagramLink(diagram, this.getModelObject())) != null) {
            List positions = DiagramLinkAdapter.getBendpoints(dLink);
            this.createBendpoints(positions);
        }
    }

    private void createBendpoints(List positions) {
        int nPts = positions.size();
        int i = 0;
        while (i < nPts) {
            AbsoluteBendpoint ab = new AbsoluteBendpoint((Point)positions.get(i));
            this.getBendpoints().add(i, ab);
            ++i;
        }
    }

    protected void createAdditionalLabelNodes() {
        String[] targetStrings;
        String[] sourceStrings = this.bAssociation.getProperties(0);
        if (sourceStrings != null && sourceStrings.length > 0) {
            this.sourceLabelNodes = new ArrayList(sourceStrings.length);
            int i = 0;
            while (i < sourceStrings.length) {
                AssociationLabelModelNode newLabel = new AssociationLabelModelNode(sourceStrings[i], -1);
                this.sourceLabelNodes.add(newLabel);
                ++i;
            }
        }
        if ((targetStrings = this.bAssociation.getProperties(1)) != null && targetStrings.length > 0) {
            this.targetLabelNodes = new ArrayList(targetStrings.length);
            int i = 0;
            while (i < targetStrings.length) {
                AssociationLabelModelNode newLabel = new AssociationLabelModelNode(targetStrings[i], -1);
                this.targetLabelNodes.add(newLabel);
                ++i;
            }
        }
    }

    @Override
    public void updateLabels() {
        if (this.sourceRoleName != null) {
            this.sourceRoleName.setName(this.bAssociation.getRoleName(0));
        }
        if (this.targetRoleName != null) {
            this.targetRoleName.setName(this.bAssociation.getRoleName(1));
        }
        if (this.sourceMultiplicity != null) {
            this.sourceMultiplicity.setName(this.bAssociation.getMultiplicity(0));
        }
        if (this.targetMultiplicity != null) {
            this.targetMultiplicity.setName(this.bAssociation.getMultiplicity(1));
        }
        if (this.sourceLabelNodes != null) {
            this.sourceLabelNodes.isEmpty();
        }
        if (this.targetLabelNodes != null) {
            this.targetLabelNodes.isEmpty();
        }
    }

    @Override
    public void setName(String sName) {
        this.sName = sName;
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public void layout() {
    }

    public boolean routerStyleChanged() {
        return false;
    }

    public boolean changedRouterFromOtoM(String oldStyle, String newStyle) {
        return oldStyle != null && newStyle != null && newStyle.equalsIgnoreCase(DiagramLinkType.MANUAL_LITERAL.getName()) && oldStyle.equalsIgnoreCase(DiagramLinkType.ORTHOGONAL_LITERAL.getName());
    }

    @Override
    public void setRouterStyle(String newStyle) {
        if (this.sRouterStyle == null || !this.sRouterStyle.equals(newStyle)) {
            this.sRouterStyle = newStyle;
        }
    }

    @Override
    public void setRouterStyle(int iRouterStyle) {
    }

    @Override
    public int getRouterStyle() {
        return DiagramEditorUtil.getCurrentDiagramRouterStyle();
    }

    public String getFormattedStereoType() {
        return STEREOTYPE_BEGIN + this.bAssociation.getStereotype() + STEREOTYPE_END;
    }

    @Override
    public Object getSourceNode() {
        return this.sourceNode;
    }

    @Override
    public Object getTargetNode() {
        return this.targetNode;
    }

    @Override
    public void setSourceNode(Object node) {
        this.sourceNode = (DiagramModelNode)node;
    }

    @Override
    public void setTargetNode(Object node) {
        this.targetNode = (DiagramModelNode)node;
    }

    public LabelModelNode getNameLabel() {
        return this.name;
    }

    public LabelModelNode getSourceMultiplicityLabel() {
        return this.sourceMultiplicity;
    }

    public LabelModelNode getSourceRoleNameLabel() {
        return this.sourceRoleName;
    }

    public LabelModelNode getStereotypeLabel() {
        return this.stereotype;
    }

    public LabelModelNode getTargetMultiplicityLabel() {
        return this.targetMultiplicity;
    }

    public LabelModelNode getTargetRoleNameLabel() {
        return this.targetRoleName;
    }

    public void setName(LabelModelNode node) {
        this.name = node;
    }

    public void setSourceMultiplicity(LabelModelNode node) {
        this.sourceMultiplicity = node;
    }

    public void setSourceRoleName(LabelModelNode node) {
        this.sourceRoleName = node;
    }

    public void setStereotype(LabelModelNode node) {
        this.stereotype = node;
    }

    public void setTargetMultiplicity(LabelModelNode node) {
        this.targetMultiplicity = node;
    }

    public void setTargetRoleName(LabelModelNode node) {
        this.targetRoleName = node;
    }

    @Override
    public List getLabelNodes() {
        ArrayList<LabelModelNode> currentLabels = new ArrayList<LabelModelNode>();
        if (this.sourceRoleName != null && this.showRoles) {
            currentLabels.add(this.sourceRoleName);
        }
        if (this.targetRoleName != null && this.showRoles) {
            currentLabels.add(this.targetRoleName);
        }
        if (this.sourceMultiplicity != null && this.showMultiplicity) {
            currentLabels.add(this.sourceMultiplicity);
        }
        if (this.targetMultiplicity != null && this.showMultiplicity) {
            currentLabels.add(this.targetMultiplicity);
        }
        if (this.name != null && this.showName) {
            currentLabels.add(this.name);
        }
        if (this.stereotype != null) {
            currentLabels.add(this.stereotype);
        }
        if (this.sourceLabelNodes != null && !this.sourceLabelNodes.isEmpty()) {
            currentLabels.addAll(this.sourceLabelNodes);
        }
        if (this.targetLabelNodes != null && !this.targetLabelNodes.isEmpty()) {
            currentLabels.addAll(this.targetLabelNodes);
        }
        if (currentLabels.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return currentLabels;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    @Override
    public void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    public int getLinkType() {
        return DiagramEditorUtil.getCurrentDiagramRouterStyle();
    }

    private void updateFonts(DiagramEditPart adepParentEditPart) {
        Font newFont = ScaledFontManager.getFont(-1);
        if (ScaledFontManager.fontsAreDifferent(newFont, currentLabelFont)) {
            LabelModelNode nextNode;
            Iterator iter;
            currentLabelFont = newFont;
            this.updateFontOnLabelFigure(adepParentEditPart, this.sourceRoleName, currentLabelFont);
            this.updateFontOnLabelFigure(adepParentEditPart, this.targetRoleName, currentLabelFont);
            this.updateFontOnLabelFigure(adepParentEditPart, this.sourceMultiplicity, currentLabelFont);
            this.updateFontOnLabelFigure(adepParentEditPart, this.targetMultiplicity, currentLabelFont);
            this.updateFontOnLabelFigure(adepParentEditPart, this.name, currentLabelFont);
            this.updateFontOnLabelFigure(adepParentEditPart, this.stereotype, currentLabelFont);
            if (this.sourceLabelNodes != null && !this.sourceLabelNodes.isEmpty()) {
                iter = this.sourceLabelNodes.iterator();
                nextNode = null;
                while (iter.hasNext()) {
                    nextNode = (LabelModelNode)iter.next();
                    this.updateFontOnLabelFigure(adepParentEditPart, nextNode, currentLabelFont);
                }
            }
            if (this.targetLabelNodes != null && !this.targetLabelNodes.isEmpty()) {
                iter = this.targetLabelNodes.iterator();
                nextNode = null;
                while (iter.hasNext()) {
                    nextNode = (LabelModelNode)iter.next();
                    this.updateFontOnLabelFigure(adepParentEditPart, nextNode, currentLabelFont);
                }
            }
        }
    }

    private void updateFontOnLabelFigure(DiagramEditPart adepParentEditPart, LabelModelNode lmnLabel, Font fntNew) {
        DiagramFigure df1;
        DiagramEditPart depLabelled;
        DiagramEditPart dep = (DiagramEditPart)adepParentEditPart.getParent();
        if (dep != null && (depLabelled = dep.getEditPart(lmnLabel)) != null && (df1 = depLabelled.getDiagramFigure()) != null && df1 instanceof LabeledRectangleFigure) {
            ((LabeledRectangleFigure)df1).updateForFont(fntNew);
            depLabelled.updateModelSize();
        }
    }

    @Override
    public void layout(ConnectionAnchor sourceAnchor, ConnectionAnchor targetAnchor, DiagramEditPart adepParentEditPart) {
        LabelModelNode nextNode;
        Iterator iter;
        if (!(sourceAnchor instanceof NodeConnectionAnchor) || !(targetAnchor instanceof NodeConnectionAnchor)) {
            return;
        }
        this.updateFonts(adepParentEditPart);
        NodeConnectionAnchor ncaSourceAnchor = (NodeConnectionAnchor)sourceAnchor;
        NodeConnectionAnchor ncaTargetAnchor = (NodeConnectionAnchor)targetAnchor;
        Point pSourceAnchor = null;
        Point pTargetAnchor = null;
        int sourceX = ncaSourceAnchor.getOffsetH() + ((DiagramModelNode)this.getSourceNode()).getX();
        int sourceY = ncaSourceAnchor.getOffsetV() + ((DiagramModelNode)this.getSourceNode()).getY();
        int targetX = ncaTargetAnchor.getOffsetH() + ((DiagramModelNode)this.getTargetNode()).getX();
        int targetY = ncaTargetAnchor.getOffsetV() + ((DiagramModelNode)this.getTargetNode()).getY();
        pSourceAnchor = new Point(sourceX, sourceY);
        pTargetAnchor = new Point(targetX, targetY);
        double deltaX = 6.0;
        double deltaY = 4.0;
        int sourceSide = 0;
        int targetSide = 0;
        Point sourceStartPt = pSourceAnchor;
        Point targetEndPt = pTargetAnchor;
        sourceSide = ncaSourceAnchor.getDirection();
        targetSide = ncaTargetAnchor.getDirection();
        double sourceAngleInRadians = this.getSourceAngleInRadians(sourceSide);
        double targetAngleInRadians = this.getTargetAngleInRadians(targetSide);
        int tmpPtX = 0;
        int tmpPtY = 0;
        double startX = 0.0;
        double startY = 0.0;
        double strHeight = 0.0;
        double strWidth = 0.0;
        double tmpAngle = 0.0;
        if (this.canShowSourceMultiplicity()) {
            strHeight = this.sourceMultiplicity.getHeight();
            strWidth = this.sourceMultiplicity.getWidth();
            startX = sourceStartPt.x;
            startY = sourceStartPt.y;
            tmpAngle = this.getLinkType() == 0 ? Math.toDegrees(sourceAngleInRadians) : 360.0 - Math.toDegrees(sourceAngleInRadians);
            switch (sourceSide) {
                case 0: {
                    if (tmpAngle >= 60.0 && tmpAngle <= 120.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    if (tmpAngle < 60.0) {
                        tmpPtX = (int)(startX - strWidth);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    tmpPtX = (int)startX;
                    tmpPtY = (int)(startY - deltaY - strHeight);
                    break;
                }
                case 2: {
                    if (tmpAngle >= 240.0 && tmpAngle <= 300.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    if (tmpAngle < 240.0) {
                        tmpPtX = (int)(startX - strWidth);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    tmpPtX = (int)startX;
                    tmpPtY = (int)(startY + deltaY);
                    break;
                }
                case 1: {
                    if (tmpAngle <= 20.0 || tmpAngle >= 340.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    if (tmpAngle > 20.0 && tmpAngle <= 91.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)startY;
                        break;
                    }
                    tmpPtX = (int)(startX + deltaX);
                    tmpPtY = (int)(startY - strHeight);
                    break;
                }
                case 3: {
                    if (tmpAngle <= 200.0 && tmpAngle >= 160.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    if (tmpAngle > 89.0 && tmpAngle < 160.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY - strHeight);
                        break;
                    }
                    tmpPtX = (int)(startX - deltaX - strWidth);
                    tmpPtY = (int)(startY - strHeight);
                    break;
                }
            }
            switch (sourceSide) {
                case 0: {
                    if (this.sourceLabelNodes == null || this.sourceLabelNodes.isEmpty()) break;
                    iter = this.sourceLabelNodes.iterator();
                    nextNode = null;
                    while (iter.hasNext()) {
                        nextNode = (LabelModelNode)iter.next();
                        nextNode.setPosition(new Point(tmpPtX + this.sourceMultiplicity.getWidth() - nextNode.getWidth(), tmpPtY));
                        tmpPtY -= nextNode.getHeight();
                    }
                    break;
                }
                case 2: {
                    if (this.sourceLabelNodes == null || this.sourceLabelNodes.isEmpty()) break;
                    iter = this.sourceLabelNodes.iterator();
                    nextNode = null;
                    while (iter.hasNext()) {
                        nextNode = (LabelModelNode)iter.next();
                        nextNode.setPosition(new Point(tmpPtX + this.sourceMultiplicity.getWidth() - nextNode.getWidth(), tmpPtY));
                        tmpPtY += nextNode.getHeight();
                    }
                    break;
                }
                case 3: {
                    if (this.sourceLabelNodes == null || this.sourceLabelNodes.isEmpty()) break;
                    iter = this.sourceLabelNodes.iterator();
                    nextNode = null;
                    while (iter.hasNext()) {
                        nextNode = (LabelModelNode)iter.next();
                        nextNode.setPosition(new Point(tmpPtX - nextNode.getWidth() + this.sourceMultiplicity.getWidth(), tmpPtY));
                        tmpPtY -= nextNode.getHeight();
                    }
                    break;
                }
                case 1: {
                    if (this.sourceLabelNodes == null || this.sourceLabelNodes.isEmpty()) break;
                    iter = this.sourceLabelNodes.iterator();
                    nextNode = null;
                    while (iter.hasNext()) {
                        nextNode = (LabelModelNode)iter.next();
                        nextNode.setPosition(new Point(tmpPtX, tmpPtY));
                        tmpPtY -= nextNode.getHeight();
                    }
                    break;
                }
            }
            this.sourceMultiplicity.setPosition(new Point(tmpPtX, tmpPtY));
        }
        if (this.canShowTargetMultiplicity()) {
            strHeight = this.targetMultiplicity.getHeight();
            strWidth = this.targetMultiplicity.getWidth();
            startX = targetEndPt.x;
            startY = targetEndPt.y;
            tmpAngle = this.getLinkType() == 0 ? Math.toDegrees(targetAngleInRadians + Math.PI) : 360.0 - Math.toDegrees(targetAngleInRadians + Math.PI);
            if (tmpAngle < 0.0) {
                tmpAngle += 360.0;
            } else if (tmpAngle > 360.0) {
                tmpAngle -= 360.0;
            }
            switch (targetSide) {
                case 0: {
                    if (tmpAngle >= 60.0 && tmpAngle <= 120.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    if (tmpAngle < 60.0) {
                        tmpPtX = (int)(startX - strWidth);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    tmpPtX = (int)startX;
                    tmpPtY = (int)(startY - deltaY - strHeight);
                    break;
                }
                case 2: {
                    if (tmpAngle >= 240.0 && tmpAngle <= 300.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    if (tmpAngle < 240.0) {
                        tmpPtX = (int)(startX - strWidth);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    tmpPtX = (int)startX;
                    tmpPtY = (int)(startY + deltaY);
                    break;
                }
                case 1: {
                    if (tmpAngle <= 20.0 || tmpAngle >= 340.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    if (tmpAngle > 20.0 && tmpAngle <= 91.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)startY;
                        break;
                    }
                    tmpPtX = (int)(startX + deltaX);
                    tmpPtY = (int)(startY - strHeight);
                    break;
                }
                case 3: {
                    if (tmpAngle <= 200.0 && tmpAngle >= 160.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    if (tmpAngle > 89.0 && tmpAngle < 160.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)startY;
                        break;
                    }
                    tmpPtX = (int)(startX - deltaX - strWidth);
                    tmpPtY = (int)(startY - strHeight);
                    break;
                }
            }
            switch (targetSide) {
                case 0: {
                    if (this.targetLabelNodes == null || this.targetLabelNodes.isEmpty()) break;
                    iter = this.targetLabelNodes.iterator();
                    nextNode = null;
                    while (iter.hasNext()) {
                        nextNode = (LabelModelNode)iter.next();
                        nextNode.setPosition(new Point(tmpPtX + this.targetMultiplicity.getWidth() - nextNode.getWidth(), tmpPtY));
                        tmpPtY -= nextNode.getHeight();
                    }
                    break;
                }
                case 2: {
                    if (this.targetLabelNodes == null || this.targetLabelNodes.isEmpty()) break;
                    iter = this.targetLabelNodes.iterator();
                    nextNode = null;
                    while (iter.hasNext()) {
                        nextNode = (LabelModelNode)iter.next();
                        nextNode.setPosition(new Point(tmpPtX + this.targetMultiplicity.getWidth() - nextNode.getWidth(), tmpPtY));
                        tmpPtY += nextNode.getHeight();
                    }
                    break;
                }
                case 3: {
                    if (this.targetLabelNodes == null || this.targetLabelNodes.isEmpty()) break;
                    iter = this.targetLabelNodes.iterator();
                    nextNode = null;
                    while (iter.hasNext()) {
                        nextNode = (LabelModelNode)iter.next();
                        nextNode.setPosition(new Point(tmpPtX - nextNode.getWidth() + this.targetMultiplicity.getWidth(), tmpPtY));
                        tmpPtY -= nextNode.getHeight();
                    }
                    break;
                }
                case 1: {
                    if (this.targetLabelNodes == null || this.targetLabelNodes.isEmpty()) break;
                    iter = this.targetLabelNodes.iterator();
                    nextNode = null;
                    while (iter.hasNext()) {
                        nextNode = (LabelModelNode)iter.next();
                        nextNode.setPosition(new Point(tmpPtX, tmpPtY));
                        tmpPtY -= nextNode.getHeight();
                    }
                    break;
                }
            }
            this.targetMultiplicity.setPosition(new Point(tmpPtX, tmpPtY));
        }
        if (this.canShowSourceRole()) {
            strHeight = this.sourceRoleName.getHeight();
            strWidth = this.sourceRoleName.getWidth();
            startX = sourceStartPt.x;
            startY = sourceStartPt.y;
            tmpAngle = this.getLinkType() == 0 ? Math.toDegrees(sourceAngleInRadians) : 360.0 - Math.toDegrees(sourceAngleInRadians);
            switch (sourceSide) {
                case 0: {
                    if (tmpAngle >= 60.0 && tmpAngle <= 120.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    if (tmpAngle < 60.0) {
                        tmpPtX = (int)(startX - strWidth);
                        tmpPtY = (int)(startY - deltaY - strHeight * 2.0);
                        break;
                    }
                    tmpPtX = (int)startX;
                    tmpPtY = (int)(startY - deltaY - strHeight * 2.0);
                    break;
                }
                case 2: {
                    if (tmpAngle >= 240.0 && tmpAngle <= 300.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    if (tmpAngle < 240.0) {
                        tmpPtX = (int)startX;
                        tmpPtY = (int)(startY + deltaY + strHeight);
                        break;
                    }
                    tmpPtX = (int)(startX - strWidth);
                    tmpPtY = (int)(startY + deltaY + strHeight);
                    break;
                }
                case 1: {
                    if (tmpAngle <= 20.0 || tmpAngle >= 340.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    if (tmpAngle > 20.0 && tmpAngle <= 91.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY + strHeight);
                        break;
                    }
                    tmpPtX = (int)(startX + deltaX);
                    tmpPtY = (int)(startY - strHeight * 2.0);
                    break;
                }
                case 3: {
                    if (tmpAngle <= 200.0 && tmpAngle >= 160.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    if (tmpAngle > 89.0 && tmpAngle < 160.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY + strHeight);
                        break;
                    }
                    tmpPtX = (int)(startX - deltaX - strWidth);
                    tmpPtY = (int)(startY - strHeight * 2.0);
                    break;
                }
            }
            this.sourceRoleName.setPosition(new Point(tmpPtX, tmpPtY));
        }
        if (this.canShowTargetRole()) {
            strHeight = this.targetRoleName.getHeight();
            strWidth = this.targetRoleName.getWidth();
            startX = targetEndPt.x;
            startY = targetEndPt.y;
            tmpAngle = this.getLinkType() == 0 ? Math.toDegrees(targetAngleInRadians + Math.PI) : 360.0 - Math.toDegrees(targetAngleInRadians + Math.PI);
            if (tmpAngle < 0.0) {
                tmpAngle += 360.0;
            } else if (tmpAngle > 360.0) {
                tmpAngle -= 360.0;
            }
            switch (targetSide) {
                case 0: {
                    if (tmpAngle >= 60.0 && tmpAngle <= 120.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    if (tmpAngle < 60.0) {
                        tmpPtX = (int)(startX - strWidth);
                        tmpPtY = (int)(startY - deltaY - strHeight * 2.0);
                        break;
                    }
                    tmpPtX = (int)startX;
                    tmpPtY = (int)(startY - deltaY - strHeight * 2.0);
                    break;
                }
                case 2: {
                    if (tmpAngle >= 240.0 && tmpAngle <= 300.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    if (tmpAngle < 240.0) {
                        tmpPtX = (int)startX;
                        tmpPtY = (int)(startY + deltaY + strHeight);
                        break;
                    }
                    tmpPtX = (int)(startX - strWidth);
                    tmpPtY = (int)(startY + deltaY + strHeight);
                    break;
                }
                case 1: {
                    if (tmpAngle <= 20.0 || tmpAngle >= 340.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    if (tmpAngle > 20.0 && tmpAngle <= 91.0) {
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY + strHeight);
                        break;
                    }
                    tmpPtX = (int)(startX + deltaX);
                    tmpPtY = (int)(startY - strHeight * 2.0);
                    break;
                }
                case 3: {
                    if (tmpAngle <= 200.0 && tmpAngle >= 160.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    if (tmpAngle > 89.0 && tmpAngle < 160.0) {
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY + strHeight);
                        break;
                    }
                    tmpPtX = (int)(startX - deltaX - strWidth);
                    tmpPtY = (int)(startY - strHeight * 2.0);
                    break;
                }
            }
            this.targetRoleName.setPosition(new Point(tmpPtX, tmpPtY));
        }
    }

    @Override
    public void placeStereotypeAndName(int iSourceSide, int iTargetSide, PointList plConnectionPoints) {
        if (!this.canShowStereotype() && !this.canShowName()) {
            return;
        }
        int iPointsInConnection = plConnectionPoints.size();
        Point ptFirstSegPoint = null;
        Point ptLastSegPoint = null;
        switch (iPointsInConnection) {
            case 2: {
                if (this.isVerticalConnection(iSourceSide, iTargetSide)) {
                    Point ptMidPoint = plConnectionPoints.getMidpoint();
                    int iStereotypeX = ptMidPoint.x + 6;
                    int iStereotypeY = ptMidPoint.y;
                    int iNameX = iStereotypeX;
                    int iNameY = iStereotypeY + this.name.getHeight() + 7;
                    if (this.name != null) {
                        this.name.setPosition(new Point(iNameX, iNameY));
                    }
                    if (this.stereotype == null) break;
                    this.stereotype.setPosition(new Point(iStereotypeX, iStereotypeY));
                    break;
                }
                ptFirstSegPoint = plConnectionPoints.getFirstPoint();
                ptLastSegPoint = plConnectionPoints.getMidpoint();
                if (this.name != null) {
                    this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.name, 1, 2);
                }
                if (this.stereotype == null) break;
                this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.stereotype, 2, 2);
                break;
            }
            case 3: {
                int iLeftCenterRightPosition = 0;
                if (plConnectionPoints.getFirstPoint().y == plConnectionPoints.getMidpoint().y) {
                    if (plConnectionPoints.getFirstPoint().x < plConnectionPoints.getMidpoint().x) {
                        ptFirstSegPoint = plConnectionPoints.getFirstPoint();
                        ptLastSegPoint = plConnectionPoints.getMidpoint();
                        iLeftCenterRightPosition = 3;
                    } else if (plConnectionPoints.getMidpoint().x < plConnectionPoints.getFirstPoint().x) {
                        ptFirstSegPoint = plConnectionPoints.getMidpoint();
                        ptLastSegPoint = plConnectionPoints.getFirstPoint();
                        iLeftCenterRightPosition = 1;
                    }
                    if (this.name != null) {
                        this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.name, 1, iLeftCenterRightPosition);
                    }
                    if (this.stereotype == null) break;
                    this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.stereotype, 2, iLeftCenterRightPosition);
                    break;
                }
                if (plConnectionPoints.getLastPoint().y != plConnectionPoints.getMidpoint().y) break;
                if (plConnectionPoints.getLastPoint().x < plConnectionPoints.getMidpoint().x) {
                    ptFirstSegPoint = plConnectionPoints.getLastPoint();
                    ptLastSegPoint = plConnectionPoints.getMidpoint();
                    iLeftCenterRightPosition = 3;
                } else if (plConnectionPoints.getMidpoint().x < plConnectionPoints.getLastPoint().x) {
                    ptFirstSegPoint = plConnectionPoints.getMidpoint();
                    ptLastSegPoint = plConnectionPoints.getLastPoint();
                    iLeftCenterRightPosition = 1;
                }
                if (this.name != null) {
                    this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.name, 1, iLeftCenterRightPosition);
                }
                if (this.stereotype == null) break;
                this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.stereotype, 2, iLeftCenterRightPosition);
                break;
            }
            case 4: {
                if (this.isVerticalConnection(iSourceSide, iTargetSide)) {
                    ptFirstSegPoint = plConnectionPoints.getPoint(1);
                    ptLastSegPoint = plConnectionPoints.getPoint(2);
                    this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.name, 1, 2);
                    this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.stereotype, 2, 2);
                    break;
                }
                ptFirstSegPoint = plConnectionPoints.getPoint(0);
                ptLastSegPoint = plConnectionPoints.getPoint(1);
                if (this.name != null) {
                    this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.name, 1, 4);
                }
                if (this.stereotype == null) break;
                this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.stereotype, 2, 4);
                break;
            }
            case 5: {
                int iLeftCenterRightPosition = 0;
                if (plConnectionPoints.getPoint((int)1).y == plConnectionPoints.getPoint((int)2).y) {
                    if (plConnectionPoints.getPoint((int)1).x < plConnectionPoints.getPoint((int)2).x) {
                        ptFirstSegPoint = plConnectionPoints.getPoint(1);
                        ptLastSegPoint = plConnectionPoints.getPoint(2);
                        iLeftCenterRightPosition = 3;
                    } else if (plConnectionPoints.getPoint((int)2).x < plConnectionPoints.getPoint((int)1).x) {
                        ptFirstSegPoint = plConnectionPoints.getPoint(2);
                        ptLastSegPoint = plConnectionPoints.getPoint(1);
                        iLeftCenterRightPosition = 1;
                    }
                    if (this.name != null) {
                        this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.name, 1, iLeftCenterRightPosition);
                    }
                    if (this.stereotype == null) break;
                    this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.stereotype, 2, iLeftCenterRightPosition);
                    break;
                }
                if (plConnectionPoints.getPoint((int)3).y != plConnectionPoints.getPoint((int)2).y) break;
                if (plConnectionPoints.getPoint((int)3).x < plConnectionPoints.getPoint((int)2).x) {
                    ptFirstSegPoint = plConnectionPoints.getPoint(3);
                    ptLastSegPoint = plConnectionPoints.getPoint(2);
                    iLeftCenterRightPosition = 3;
                } else if (plConnectionPoints.getPoint((int)2).x < plConnectionPoints.getPoint((int)3).x) {
                    ptFirstSegPoint = plConnectionPoints.getPoint(2);
                    ptLastSegPoint = plConnectionPoints.getPoint(3);
                    iLeftCenterRightPosition = 1;
                }
                if (this.name != null) {
                    this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.name, 1, iLeftCenterRightPosition);
                }
                if (this.stereotype == null) break;
                this.setNewPositionForLabelOnSegment(ptFirstSegPoint, ptLastSegPoint, this.stereotype, 2, iLeftCenterRightPosition);
                break;
            }
        }
    }

    private boolean isVerticalConnection(int iSourceSide, int iTargetSide) {
        return iSourceSide == 0 && iTargetSide == 2 || iTargetSide == 0 && iSourceSide == 2;
    }

    private void setNewPositionForLabelOnSegment(Point ptSegmentStart, Point ptSegmentEnd, LabelModelNode lmnLabel, int iAboveBelowPosition, int iLeftCenterRightPosition) {
        Point ptResult = null;
        int strHeight = lmnLabel.getHeight();
        int strWidth = lmnLabel.getWidth();
        int iY = 0;
        int iX = 0;
        switch (iLeftCenterRightPosition) {
            case 1: {
                iX = ptSegmentStart.x - strWidth - 6;
                break;
            }
            case 2: {
                int iMiddleOfSegX = ptSegmentEnd.x - ptSegmentStart.x;
                iX = iMiddleOfSegX - strWidth / 2;
                if (iX >= ptSegmentStart.x) break;
                iX = ptSegmentStart.x + 6;
                break;
            }
            case 3: {
                iX = ptSegmentEnd.x + 6;
                break;
            }
            case 4: {
                iX = ptSegmentEnd.x - strWidth / 2;
                break;
            }
            case 5: {
                iX = ptSegmentStart.x - strWidth / 2;
                break;
            }
        }
        iY = iAboveBelowPosition == 1 ? ptSegmentStart.y - 4 - strHeight : ptSegmentStart.y + 4;
        ptResult = new Point(iX, iY);
        lmnLabel.setPosition(ptResult);
    }

    private double getSourceAngleInRadians(int iSourceSide) {
        double sourceAngleInRadians = 0.0;
        if (this.getLinkType() == 0) {
            sourceAngleInRadians = iSourceSide == 3 ? Math.PI : (iSourceSide == 1 ? 0.0 : (iSourceSide == 0 ? 1.5707963267948966 : 4.71238898038469));
        }
        return sourceAngleInRadians;
    }

    private double getTargetAngleInRadians(int iTargetSide) {
        double targetAngleInRadians = 0.0;
        if (this.getLinkType() == 0) {
            targetAngleInRadians = iTargetSide == 3 ? 0.0 : (iTargetSide == 1 ? Math.PI : (iTargetSide == 0 ? 4.71238898038469 : 1.5707963267948966));
        }
        return targetAngleInRadians;
    }

    private boolean canShowName() {
        return this.sName != null && this.sName.length() > 0 && this.name != null;
    }

    private boolean canShowStereotype() {
        return this.getStereotypeLabel() != null && this.getStereotypeLabel().getName() != null && this.getStereotypeLabel().getName().length() > 0 && this.stereotype != null;
    }

    private boolean canShowTargetMultiplicity() {
        return this.targetMultiplicity != null && this.targetMultiplicity.getName() != null && this.targetMultiplicity.getName().length() > 0;
    }

    private boolean canShowSourceMultiplicity() {
        return this.sourceMultiplicity != null && this.sourceMultiplicity.getName() != null && this.sourceMultiplicity.getName().length() > 0;
    }

    private boolean canShowTargetRole() {
        return this.targetRoleName != null && this.targetRoleName.getName() != null && this.targetRoleName.getName().length() > 0;
    }

    private boolean canShowSourceRole() {
        return this.sourceRoleName != null && this.sourceRoleName.getName() != null && this.sourceRoleName.getName().length() > 0;
    }

    @Override
    public int getSourceDecoratorId() {
        if (this.getBAssociation().getAggregation(0) == 303) {
            return 5;
        }
        if (this.getBAssociation().getAggregation(0) == 302) {
            return 4;
        }
        if (this.getBAssociation().getNavigability(0) == 501) {
            return 6;
        }
        if (this.getBAssociation().getNavigability(0) == 503) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getTargetDecoratorId() {
        if (this.getBAssociation().getAggregation(1) == 303) {
            return 5;
        }
        if (this.getBAssociation().getAggregation(1) == 302) {
            return 4;
        }
        if (this.getBAssociation().getNavigability(1) == 501) {
            return 6;
        }
        if (this.getBAssociation().getNavigability(1) == 503) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getLineStyle() {
        return 1;
    }

    public BinaryAssociation getBAssociation() {
        return this.bAssociation;
    }

    @Override
    public EObject getModelObject() {
        return this.getBAssociation().getReference();
    }

    @Override
    public List getToolTipStrings() {
        if (this.getBAssociation().getReference() != null && this.getBAssociation().getRelationshipAspect() != null && this.getBAssociation().getRelationshipAspect() instanceof UmlAssociation) {
            ArrayList<String> stringList = new ArrayList<String>(3);
            String toolTip = "UmlAssociation";
            UmlAssociation theAspect = (UmlAssociation)this.getBAssociation().getRelationshipAspect();
            String tempS = theAspect.getToolTip((Object)this.getBAssociation().getReference());
            if (tempS != null) {
                toolTip = tempS;
            }
            stringList.add(toolTip);
            return stringList;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object someOtherObject) {
        if (someOtherObject instanceof DiagramUmlAssociation) {
            BinaryAssociation thisBass = this.getBAssociation();
            BinaryAssociation otherBass = ((DiagramUmlAssociation)someOtherObject).getBAssociation();
            if (thisBass != null && otherBass != null) {
                return thisBass.equals(otherBass);
            }
        }
        return false;
    }

    @Override
    public List getBendpoints() {
        return this.bendpoints;
    }

    @Override
    public void insertBendpoint(int index, Bendpoint point) {
        this.getBendpoints().add(index, point);
        if (this.getDiagramLink() != null) {
            DiagramLinkAdapter.addBendpoint(this.getDiagramLink(), index, point.getLocation());
        }
        this.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public void removeBendpoint(int index) {
        this.getBendpoints().remove(index);
        if (this.getDiagramLink() != null) {
            DiagramLinkAdapter.removeBendpoint(this.getDiagramLink(), index);
        }
        this.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public void clearBendpoints() {
        this.getBendpoints().clear();
        if (this.getDiagramLink() != null) {
            DiagramLinkAdapter.clearBendpoints(this.getDiagramLink());
        }
        this.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public void setBendpoint(int index, Bendpoint bPoint) {
        this.getBendpoints().set(index, bPoint);
        if (this.getDiagramLink() != null) {
            DiagramLinkAdapter.setBendpoint(this.getDiagramLink(), index, bPoint.getLocation());
        }
        this.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public void setBendpoints(Vector newPoints) {
        ArrayList<LinkBendpoint> newBendpoints = new ArrayList<LinkBendpoint>(newPoints.size());
        Object nextObj2 = null;
        for (Object nextObj2 : newPoints) {
            if (nextObj2 instanceof Bendpoint) {
                newBendpoints.add((LinkBendpoint)((Object)nextObj2));
                continue;
            }
            if (!(nextObj2 instanceof Point)) continue;
            newBendpoints.add(new LinkBendpoint((Point)nextObj2));
        }
        this.bendpoints = new ArrayList(newBendpoints);
        if (this.getDiagramLink() != null) {
            ArrayList<Point> points = new ArrayList<Point>(newBendpoints.size());
            int i = 0;
            while (i < newBendpoints.size()) {
                points.add(i, ((Bendpoint)newBendpoints.get(i)).getLocation());
                ++i;
            }
            DiagramLinkAdapter.setBendpoints(this.getDiagramLink(), points);
        }
        this.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public DiagramLink getDiagramLink() {
        if (!this.getBendpoints().isEmpty() && this.diagramLink == null) {
            this.diagramLink = DiagramUiUtilities.findDiagramLink(this.getDiagram(), this.getModelObject());
            if (this.diagramLink == null) {
                this.diagramLink = DiagramUiUtilities.createDiagramLink(this.getModelObject(), this.getDiagram());
            }
        }
        return this.diagramLink;
    }

    public Diagram getDiagram() {
        DiagramModelNode parentDiagramNode = this.sourceNode.getParent();
        if (parentDiagramNode != null && parentDiagramNode.getModelObject() instanceof Diagram) {
            return (Diagram)parentDiagramNode.getModelObject();
        }
        return null;
    }

    public void setDiagramLink(DiagramLink link) {
        this.diagramLink = link;
    }

    @Override
    public void refreshBendPoints() {
        this.firePropertyChange("bendpoint", null, null);
    }

    public void setShowMultiplicity(boolean theShowMultiplicity) {
        this.showMultiplicity = theShowMultiplicity;
    }

    public void setShowName(boolean theShowName) {
        this.showName = theShowName;
    }

    public void setShowRoles(boolean theShowRoles) {
        this.showRoles = theShowRoles;
    }
}

