/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;

public class ScaledFontManager {
    private static final int DEFAULT_FONT_SIZE = 9;
    private static final int TITLE_FONT_SIZE = 14;
    private static final int MIN_FONT_SIZE = 4;
    private static final int MAX_FONT_SIZE = 40;
    private static boolean fontWasSet = false;
    private static int currentSize = 9;
    private static String currentName = "Veranda";
    private static int currentStyle = 0;
    private static Font currentFont = new Font(null, currentName, 9, 0);
    private static Font smallerFont = new Font(null, currentName, 8, 0);
    private static Font plainFont = new Font(null, currentName, 9, 0);
    private static Font boldFont = new Font(null, currentName, 9, 1);
    private static Font titleFont = new Font(null, currentName, 14, 1);
    private static Font italicsFont = new Font(null, currentName, 9, 2);
    private static Font boldItalicsFont = new Font(null, currentName, 9, 3);

    public ScaledFontManager() {
        this.setFontFromPreferences();
    }

    private void setFontFromPreferences() {
        if (!fontWasSet) {
            IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"modeler.preference.diagram.font");
            currentName = fontData.getName();
            currentSize = fontData.getHeight();
            currentStyle = fontData.getStyle();
            currentFont = new Font(null, currentName, currentSize, currentStyle);
            fontWasSet = true;
            ScaledFontManager.resetSecondaryFonts();
        }
    }

    private static void saveFontPreference() {
        PreferenceConverter.setValue((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.font", (FontData)ScaledFontManager.getFont().getFontData()[0]);
        DiagramUiPlugin.getDefault().savePreferences();
    }

    public static void increase() {
        int currSize = ScaledFontManager.getSize();
        if (currSize < 40) {
            ScaledFontManager.setSize(currSize + 1);
            ScaledFontManager.saveFontPreference();
        }
    }

    public static void decrease() {
        int currSize = ScaledFontManager.getSize();
        if (currSize > 4) {
            ScaledFontManager.setSize(currSize - 1);
            ScaledFontManager.saveFontPreference();
        }
    }

    public static boolean canIncrease() {
        int currSize = ScaledFontManager.getSize();
        return currSize < 40;
    }

    public static boolean canIncrease(int iSize) {
        return iSize < 40;
    }

    public static boolean canDecrease() {
        int currSize = ScaledFontManager.getSize();
        return currSize > 4;
    }

    public static boolean canDecrease(int iSize) {
        return iSize > 4;
    }

    public static Font getFont() {
        return currentFont;
    }

    public static Font getFont(int style) {
        Font someFont = plainFont;
        switch (style) {
            case 3: {
                someFont = boldItalicsFont;
                break;
            }
            case 2: {
                someFont = italicsFont;
                break;
            }
            case 1: {
                someFont = boldFont;
                break;
            }
            case 0: {
                someFont = plainFont;
                break;
            }
            case -1: {
                someFont = smallerFont;
                break;
            }
            case 4: {
                someFont = titleFont;
                break;
            }
        }
        return someFont;
    }

    public static String getName() {
        return currentName;
    }

    public static int getSize() {
        return currentSize;
    }

    public static int getStyle() {
        return currentStyle;
    }

    public static void setFont(String typeName, int size, int style) {
        if (currentSize != size || !currentName.equalsIgnoreCase(typeName) || currentStyle != style) {
            currentName = typeName;
            currentSize = size;
            currentStyle = style;
            currentFont.dispose();
            currentFont = new Font(null, currentName, ScaledFontManager.getSize(), ScaledFontManager.getStyle());
            ScaledFontManager.resetSecondaryFonts();
        }
    }

    private static void resetSecondaryFonts() {
        if (plainFont != null) {
            if (ScaledFontManager.fontIsChanged(plainFont, currentName, currentSize, 0)) {
                plainFont.dispose();
                plainFont = new Font(null, currentName, currentSize, 0);
            }
        } else {
            plainFont = new Font(null, currentName, currentSize, 0);
        }
        if (boldFont != null) {
            if (ScaledFontManager.fontIsChanged(boldFont, currentName, currentSize, 1)) {
                boldFont.dispose();
                boldFont = new Font(null, currentName, currentSize, 1);
            }
        } else {
            boldFont = new Font(null, currentName, currentSize, 1);
        }
        if (italicsFont != null) {
            if (ScaledFontManager.fontIsChanged(italicsFont, currentName, currentSize, 2)) {
                italicsFont.dispose();
                italicsFont = new Font(null, currentName, currentSize, 2);
            }
        } else {
            italicsFont = new Font(null, currentName, currentSize, 2);
        }
        if (boldItalicsFont != null) {
            if (ScaledFontManager.fontIsChanged(boldItalicsFont, currentName, currentSize, 3)) {
                boldItalicsFont.dispose();
                boldItalicsFont = new Font(null, currentName, currentSize, 3);
            }
        } else {
            boldItalicsFont = new Font(null, currentName, currentSize, 3);
        }
        if (smallerFont != null) {
            if (ScaledFontManager.fontIsChanged(smallerFont, currentName, currentSize - 1, 0)) {
                smallerFont.dispose();
                smallerFont = new Font(null, currentName, currentSize - 1, 0);
            }
        } else {
            smallerFont = new Font(null, currentName, currentSize - 1, 0);
        }
    }

    private static boolean fontIsChanged(Font oldFont, String newName, int newHeight, int newStyle) {
        FontData data = oldFont.getFontData()[0];
        return data.getHeight() != newHeight || data.getStyle() != newStyle || !data.getName().equalsIgnoreCase(newName);
    }

    public static boolean fontsAreDifferent(Font font1, Font font2) {
        if (font2.isDisposed()) {
            return true;
        }
        FontData data1 = font1.getFontData()[0];
        FontData data2 = font2.getFontData()[0];
        return data1.getHeight() != data2.getHeight() || data1.getStyle() != data2.getStyle() || !data1.getName().equalsIgnoreCase(data2.getName());
    }

    public static void setFont(Font newFont) {
        currentFont.dispose();
        currentFont = newFont;
        FontData data = currentFont.getFontData()[0];
        currentName = data.getName();
        currentSize = data.getHeight();
        currentStyle = data.getStyle();
        ScaledFontManager.resetSecondaryFonts();
    }

    public static void setName(String newName) {
        currentName = newName;
    }

    public static void setStyle(int newStyle) {
        currentStyle = newStyle;
        ScaledFontManager.resetFont();
    }

    public static void setSize(int newSize) {
        currentSize = newSize;
        ScaledFontManager.resetFont();
    }

    public static void resetFont() {
        ScaledFontManager.setFont(new Font(null, ScaledFontManager.getName(), ScaledFontManager.getSize(), ScaledFontManager.getStyle()));
    }
}

