/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.model.schema.impl;

import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.BaseRelationship;
import org.teiid.designer.schema.tools.model.schema.impl.SchemaModelCopyTraversalContext;

public class SimpleRelationship
extends BaseRelationship {
    private SchemaObject parent;
    private SchemaObject child;
    private int minOccurs;
    private int maxOccurs;

    public SimpleRelationship(SchemaObject parent, SchemaObject child, int minOccurs, int maxOccurs) {
        this.parent = parent;
        this.child = child;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    @Override
    public String getParentRelativeXpath() {
        return "..";
    }

    @Override
    public String getChildRelativeXpath() {
        String xpath = this.child.getRelativeXpath();
        return xpath;
    }

    @Override
    public SchemaObject getParent() {
        return this.parent;
    }

    @Override
    public SchemaObject getChild() {
        return this.child;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public String toString() {
        String childName = this.getChild().getSimpleName();
        String parentName = this.getParent().getSimpleName();
        return String.valueOf(parentName) + "_" + childName;
    }

    public Object copy(SchemaModelCopyTraversalContext ctx) {
        SchemaObject parentCopy = ctx.getElement(this.parent);
        SchemaObject childCopy = ctx.getElement(this.child);
        return new SimpleRelationship(parentCopy, childCopy, this.minOccurs, this.maxOccurs);
    }

    @Override
    public void printDebug() {
        StringBuffer buff = new StringBuffer();
        buff.append("\t \t SimpleRelationship:");
        buff.append("ParentSimpleName = " + this.parent.getSimpleName());
        buff.append(" ");
        buff.append("ChildSimpleName = " + this.child.getSimpleName());
        buff.append(" ");
        buff.append("MinOccurs = " + this.minOccurs);
        buff.append(" ");
        buff.append("MaxOccurs = " + this.maxOccurs);
        buff.append(" ");
        buff.append("Type = " + this.getType());
        System.out.println(buff.toString());
    }

    @Override
    public void setType(int relationshipType) {
        super.setType(relationshipType);
    }

    @Override
    public int getType() {
        return super.getType();
    }
}

