/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.model.jdbc.internal;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Namespace;
import org.teiid.designer.schema.tools.model.jdbc.Column;
import org.teiid.designer.schema.tools.model.jdbc.Table;
import org.teiid.designer.schema.tools.model.jdbc.internal.DatabaseElementImpl;
import org.teiid.designer.schema.tools.model.schema.Relationship;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.SchemaModelImpl;

public class TableImpl
extends DatabaseElementImpl
implements Table {
    private String m_catalog;
    private String m_schema;
    private ArrayList m_namespaces;
    private ArrayList m_columns;
    protected SchemaObject element;
    public SchemaModel schemaModel;
    private boolean isBase;
    private final String[] wellKnownNamespaces = new String[]{"http://schemas.xmlsoap.org/soap/envelope/", "http://www.metamatrix.com/dummy", "http://schemas.xmlsoap.org/soap/encoding/", "http://www.w3.org/1999/XMLSchema-instance", "http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2001/XMLSchema", "http://soap-authentication.org/2001/10/", "http://schemas.xmlsoap.org/wsdl/", "http://schemas.xmlsoap.org/wsdl/soap/"};

    public TableImpl() {
        this.m_catalog = null;
        this.m_namespaces = new ArrayList();
        this.m_columns = new ArrayList();
    }

    public TableImpl(String name, String catalog, String inputXPath, String outputXPath) {
        super(name, inputXPath, outputXPath);
        this.setCatalog(catalog);
        this.m_namespaces = new ArrayList();
        this.m_columns = new ArrayList();
    }

    @Override
    public void setElement(SchemaObject element) {
        this.element = element;
    }

    @Override
    public void setSchemaModel(SchemaModel schemaModel) {
        this.schemaModel = schemaModel;
    }

    @Override
    public String getNamespaceDeclaration() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.m_namespaces.size()) {
            Namespace ns = (Namespace)this.m_namespaces.get(i);
            if (!this.testForWellKnownNS(ns)) {
                String pre = ns.getPrefix() == null || ns.getPrefix().trim().equals("") ? "xmlns" : "xmlns:" + ns.getPrefix();
                buff.append(pre);
                buff.append("='");
                buff.append(ns.getURI());
                buff.append("' ");
            }
            ++i;
        }
        return buff.toString().trim();
    }

    private boolean testForWellKnownNS(Namespace ns) {
        boolean isWellKnown = false;
        String nsUri = ns.getURI();
        int i = 0;
        while (i < this.wellKnownNamespaces.length) {
            if (this.wellKnownNamespaces[i].equals(nsUri)) {
                isWellKnown = true;
                break;
            }
            ++i;
        }
        return isWellKnown;
    }

    @Override
    public void addNamespace(Namespace ns) {
        this.m_namespaces.add(ns);
    }

    @Override
    public String getCatalog() {
        return this.m_catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    @Override
    public void addColumn(Column column) {
        this.m_columns.add(column);
    }

    @Override
    public Column[] getColumns() {
        List columns = null;
        columns = this.element != null && !this.isBase() ? this.element.getAllModelColumns() : new ArrayList();
        columns.addAll(this.m_columns);
        Column[] column = new Column[columns.size()];
        columns.toArray(column);
        return column;
    }

    @Override
    public Table[] getChildTables() {
        ArrayList<Table> children = new ArrayList<Table>();
        if (this.element != null) {
            for (Relationship relationship : this.element.getChildren()) {
                SchemaObject child = relationship.getChild();
                Table table = this.schemaModel.findTable(child.getSimpleName());
                children.add(table);
            }
        }
        Table[] tables = new Table[children.size()];
        children.toArray(tables);
        return tables;
    }

    @Override
    public Table[] getParentTables() {
        ArrayList<Table> parents = new ArrayList<Table>();
        for (Relationship relationship : this.element.getParents()) {
            SchemaObject parent = relationship.getParent();
            Table table = this.schemaModel.findTable(parent.getSimpleName());
            if (table == null) continue;
            parents.add(table);
        }
        Table[] tables = new Table[parents.size()];
        parents.toArray(tables);
        return tables;
    }

    @Override
    public int getRelationToParent() {
        String key = String.valueOf(this.element.getSimpleName()) + ':' + this.element.getNamespace();
        return ((SchemaModelImpl)this.schemaModel).getRelationToParent(key);
    }

    public Relationship getRelationObjectToParent(Table parent) {
        Relationship result = null;
        SchemaObject parentElement = parent.getElement();
        List parents = this.element.getParents();
        for (Relationship parentRelation : parents) {
            if (!parentRelation.getParent().getSimpleName().equals(parentElement.getSimpleName())) continue;
            result = parentRelation;
            break;
        }
        return result;
    }

    @Override
    public String getSchema() {
        return this.m_schema;
    }

    @Override
    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    @Override
    public SchemaObject getElement() {
        return this.element;
    }

    public boolean isBase() {
        return this.isBase;
    }

    @Override
    public void setBase(boolean isBase) {
        this.isBase = isBase;
    }

    @Override
    public int getMaxOccurs() {
        return this.element.getMaxOccurs();
    }

    public String toString() {
        return this.getName();
    }
}

