/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.mm.algorithms.styles.AdaptedGradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredArea;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredLocation;
import org.eclipse.graphiti.mm.algorithms.styles.LocationType;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.util.ColorUtil;
import org.eclipse.graphiti.util.IGradientType;
import org.eclipse.graphiti.util.IPredefinedRenderingStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedColoredAreas
implements IPredefinedRenderingStyle {
    private static GradientColoredAreas getBlueWhiteGlossDefaultAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "F8FBFE", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "F8FBFE", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "EDF5FC", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START, "EDF5FC", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "DEEDFA", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START, "DEEDFA", 3, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "D4E7F8", 3, LocationType.LOCATION_TYPE_ABSOLUTE_START, "FAFBFC", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "E2E5E9", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END, "E2E5E9", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(0));
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getBlueWhiteGlossPrimarySelectedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(1));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "EEF6FD", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "EEF6FD", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "D0E6F9", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START, "D0E6F9", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "ACD2F4", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START, "ACD2F4", 3, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "81B9EA", 3, LocationType.LOCATION_TYPE_ABSOLUTE_START, "AAD0F2", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "9ABFE0", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END, "9ABFE0", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getBlueWhiteGlossSecondarySelectedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(2));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "F5F9FE", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "F5F9FE", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "E2EFFC", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START, "E2EFFC", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "CBE3F9", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START, "CBE3F9", 3, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "BBDAF7", 3, LocationType.LOCATION_TYPE_ABSOLUTE_START, "C5E0F7", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "B2CDE5", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END, "B2CDE5", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getBlueWhiteGlossActionAllowedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(3));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "99CC00", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "339966", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getBlueWhiteGlossActionForbiddenAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(4));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "FFCC00", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "FF6600", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    public static AdaptedGradientColoredAreas getBlueWhiteGlossAdaptions() {
        AdaptedGradientColoredAreas agca = StylesFactory.eINSTANCE.createAdaptedGradientColoredAreas();
        agca.setDefinedStyleId("blue-white-gloss");
        agca.setGradientType(IGradientType.VERTICAL);
        agca.getAdaptedGradientColoredAreas().add(0, (Object)PredefinedColoredAreas.getBlueWhiteGlossDefaultAreas());
        agca.getAdaptedGradientColoredAreas().add(1, (Object)PredefinedColoredAreas.getBlueWhiteGlossPrimarySelectedAreas());
        agca.getAdaptedGradientColoredAreas().add(2, (Object)PredefinedColoredAreas.getBlueWhiteGlossSecondarySelectedAreas());
        agca.getAdaptedGradientColoredAreas().add(3, (Object)PredefinedColoredAreas.getBlueWhiteGlossActionAllowedAreas());
        agca.getAdaptedGradientColoredAreas().add(4, (Object)PredefinedColoredAreas.getBlueWhiteGlossActionForbiddenAreas());
        return agca;
    }

    private static GradientColoredAreas getBlueWhiteDefaultAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(0));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "D4E7F8", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "FAFBFC", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getBlueWhitePrimarySelectedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(1));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "81B9EA", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "AAD0F2", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getBlueWhiteSecondarySelectedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(2));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "BBDAF7", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "C5E0F7", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    public static AdaptedGradientColoredAreas getBlueWhiteAdaptions() {
        AdaptedGradientColoredAreas agca = StylesFactory.eINSTANCE.createAdaptedGradientColoredAreas();
        agca.setDefinedStyleId("blue-white");
        agca.setGradientType(IGradientType.VERTICAL);
        agca.getAdaptedGradientColoredAreas().add(0, (Object)PredefinedColoredAreas.getBlueWhiteDefaultAreas());
        agca.getAdaptedGradientColoredAreas().add(1, (Object)PredefinedColoredAreas.getBlueWhitePrimarySelectedAreas());
        agca.getAdaptedGradientColoredAreas().add(2, (Object)PredefinedColoredAreas.getBlueWhiteSecondarySelectedAreas());
        return agca;
    }

    private static GradientColoredAreas getLightYellowDefaultAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(0));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "FEFEF4", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "FEFEF4", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getLightYellowPrimarySelectedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(1));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "E5E5C2", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "E5E5C2", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getLightYellowSecondarySelectedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(2));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "FAFAD9", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "FAFAD9", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    public static AdaptedGradientColoredAreas getLightYellowAdaptions() {
        AdaptedGradientColoredAreas agca = StylesFactory.eINSTANCE.createAdaptedGradientColoredAreas();
        agca.setDefinedStyleId("light-yellow");
        agca.setGradientType(IGradientType.VERTICAL);
        agca.getAdaptedGradientColoredAreas().add(0, (Object)PredefinedColoredAreas.getLightYellowDefaultAreas());
        agca.getAdaptedGradientColoredAreas().add(1, (Object)PredefinedColoredAreas.getLightYellowPrimarySelectedAreas());
        agca.getAdaptedGradientColoredAreas().add(2, (Object)PredefinedColoredAreas.getLightYellowSecondarySelectedAreas());
        return agca;
    }

    private static GradientColoredAreas getLightGrayDefaultAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(0));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "F5F5ED", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "F5F5ED", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getLightGrayPrimarySelectedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(1));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "D6D6D0", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "D6D6D0", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    private static GradientColoredAreas getLightGraySecondarySelectedAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(2));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "E5E5Df", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "E5E5Df", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    public static AdaptedGradientColoredAreas getLightGrayAdaptions() {
        AdaptedGradientColoredAreas agca = StylesFactory.eINSTANCE.createAdaptedGradientColoredAreas();
        agca.setDefinedStyleId("light-gray");
        agca.setGradientType(IGradientType.VERTICAL);
        agca.getAdaptedGradientColoredAreas().add(0, (Object)PredefinedColoredAreas.getLightGrayDefaultAreas());
        agca.getAdaptedGradientColoredAreas().add(1, (Object)PredefinedColoredAreas.getLightGrayPrimarySelectedAreas());
        agca.getAdaptedGradientColoredAreas().add(2, (Object)PredefinedColoredAreas.getLightGraySecondarySelectedAreas());
        return agca;
    }

    private static GradientColoredAreas getCopperWhiteGlossDefaultAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(0));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "F9F5F2", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "F9F5F2", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "EDE0D8", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START, "EDE0D8", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "E4D0C4", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START, "F5F0E8", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "E6DDD0", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END, "E6DDD0", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    public static AdaptedGradientColoredAreas getCopperWhiteGlossAdaptions() {
        AdaptedGradientColoredAreas agca = StylesFactory.eINSTANCE.createAdaptedGradientColoredAreas();
        agca.setDefinedStyleId("copper-white-gloss");
        agca.setGradientType(IGradientType.VERTICAL);
        agca.getAdaptedGradientColoredAreas().add(0, (Object)PredefinedColoredAreas.getCopperWhiteGlossDefaultAreas());
        return agca;
    }

    private static GradientColoredAreas getSilverWhiteGlossDefaultAreas() {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(0));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "EEEEED", 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, "EEEEED", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "E1E1E0", 1, LocationType.LOCATION_TYPE_ABSOLUTE_START, "E1E1E0", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "D2D1CF", 2, LocationType.LOCATION_TYPE_ABSOLUTE_START, "F2F0EF", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        PredefinedColoredAreas.addGradientColoredArea((EList<GradientColoredArea>)gcas, "DFDEDD", 2, LocationType.LOCATION_TYPE_ABSOLUTE_END, "DFDEDD", 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    public static AdaptedGradientColoredAreas getSilverWhiteGlossAdaptions() {
        AdaptedGradientColoredAreas agca = StylesFactory.eINSTANCE.createAdaptedGradientColoredAreas();
        agca.setDefinedStyleId("silver-white-gloss");
        agca.setGradientType(IGradientType.VERTICAL);
        agca.getAdaptedGradientColoredAreas().add(0, (Object)PredefinedColoredAreas.getSilverWhiteGlossDefaultAreas());
        return agca;
    }

    public static AdaptedGradientColoredAreas getAdaptedGradientColoredAreas(String id) {
        if ("blue-white-gloss".equals(id)) {
            return PredefinedColoredAreas.getBlueWhiteGlossAdaptions();
        }
        if ("blue-white".equals(id)) {
            return PredefinedColoredAreas.getBlueWhiteAdaptions();
        }
        if ("light-yellow".equals(id)) {
            return PredefinedColoredAreas.getLightYellowAdaptions();
        }
        if ("light-gray".equals(id)) {
            return PredefinedColoredAreas.getLightGrayAdaptions();
        }
        if ("copper-white-gloss".equals(id)) {
            return PredefinedColoredAreas.getCopperWhiteGlossAdaptions();
        }
        if ("silver-white-gloss".equals(id)) {
            return PredefinedColoredAreas.getSilverWhiteGlossAdaptions();
        }
        return null;
    }

    protected static void addGradientColoredArea(EList<GradientColoredArea> gcas, String colorStart, int locationValueStart, LocationType locationTypeStart, String colorEnd, int locationValueEnd, LocationType locationTypeEnd) {
        GradientColoredArea gca = PredefinedColoredAreas.createGradientColoredArea(colorStart, locationValueStart, locationTypeStart, colorEnd, locationValueEnd, locationTypeEnd);
        gcas.add((Object)gca);
    }

    protected static GradientColoredArea createGradientColoredArea(String colorStart, int locationValueStart, LocationType locationTypeStart, String colorEnd, int locationValueEnd, LocationType locationTypeEnd) {
        GradientColoredArea ret = StylesFactory.eINSTANCE.createGradientColoredArea();
        ret.setStart(StylesFactory.eINSTANCE.createGradientColoredLocation());
        ret.getStart().setColor(StylesFactory.eINSTANCE.createColor());
        ret.getStart().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Blue(), (Object)ColorUtil.getBlueFromHex(colorStart));
        ret.getStart().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Green(), (Object)ColorUtil.getGreenFromHex(colorStart));
        ret.getStart().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Red(), (Object)ColorUtil.getRedFromHex(colorStart));
        ret.getStart().setLocationType(locationTypeStart);
        ret.getStart().setLocationValue(Integer.valueOf(locationValueStart));
        ret.setEnd(StylesFactory.eINSTANCE.createGradientColoredLocation());
        ret.getEnd().setColor(StylesFactory.eINSTANCE.createColor());
        ret.getEnd().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Blue(), (Object)ColorUtil.getBlueFromHex(colorEnd));
        ret.getEnd().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Green(), (Object)ColorUtil.getGreenFromHex(colorEnd));
        ret.getEnd().getColor().eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Red(), (Object)ColorUtil.getRedFromHex(colorEnd));
        ret.getEnd().setLocationType(locationTypeEnd);
        ret.getEnd().setLocationValue(Integer.valueOf(locationValueEnd));
        return ret;
    }

    public static int getLocation(GradientColoredLocation gradientColoredLocation, int length, double zoom) {
        if (gradientColoredLocation.getLocationType() == LocationType.LOCATION_TYPE_ABSOLUTE_START) {
            return (int)Math.round((double)gradientColoredLocation.getLocationValue().intValue() * zoom);
        }
        if (gradientColoredLocation.getLocationType() == LocationType.LOCATION_TYPE_ABSOLUTE_END) {
            return length - (int)Math.round((double)gradientColoredLocation.getLocationValue().intValue() * zoom);
        }
        if (gradientColoredLocation.getLocationType() == LocationType.LOCATION_TYPE_RELATIVE) {
            double ret = (double)gradientColoredLocation.getLocationValue().intValue() / 100.0 * (double)length;
            return (int)Math.round(ret);
        }
        throw new IllegalStateException("Unknown location type '" + gradientColoredLocation.getLocationType() + "'");
    }
}

