/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.tb;

import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.tb.AbstractContextEntry;
import org.eclipse.graphiti.tb.IContextMenuEntry;

public class DynamicContextMenuEntry
extends AbstractContextEntry
implements IContextMenuEntry {
    private static final IContextMenuEntry[] NO_CONTEXT_MENU_ENTRIES = new IContextMenuEntry[0];
    private int minimumSubmenuEntries = 3;
    private ArrayList<IContextMenuEntry> children = new ArrayList();

    public DynamicContextMenuEntry(IFeature feature, IContext context) {
        super(feature, context);
    }

    public IContextMenuEntry[] getChildren() {
        IContextMenuEntry[] ret = this.children.toArray(NO_CONTEXT_MENU_ENTRIES);
        return ret;
    }

    public void add(IContextMenuEntry entry) {
        this.children.add(entry);
    }

    public boolean isSubmenu() {
        return (this.getText() != null || this.getFeature() != null) && this.getChildren().length >= this.getMinimumSubmenuEntries();
    }

    public void setMinimumSubmenuEntries(int minimumSubmenuEntries) {
        this.minimumSubmenuEntries = minimumSubmenuEntries;
    }

    public int getMinimumSubmenuEntries() {
        return this.minimumSubmenuEntries;
    }
}

