/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.datatypes.impl;

import org.eclipse.graphiti.datatypes.IAdvancedLocation;
import org.eclipse.graphiti.datatypes.ILocation;

public class LocationImpl
implements IAdvancedLocation {
    private int x;
    private int y;

    public LocationImpl(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public LocationImpl(ILocation location) {
        this(location.getX(), location.getY());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LocationImpl) {
            LocationImpl l = (LocationImpl)o;
            return l.x == this.x && l.y == this.y;
        }
        return false;
    }

    public int hashCode() {
        return this.x * this.y ^ this.x + this.y;
    }

    public String toString() {
        return "Location(" + this.x + ", " + this.y + ")";
    }

    public ILocation getLocationCopy() {
        return new LocationImpl(this);
    }

    public ILocation setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public ILocation setLocation(ILocation location) {
        return this.setLocation(location.getX(), location.getY());
    }

    public void scale(double amount) {
        this.x = (int)Math.floor((double)this.x * amount);
        this.y = (int)Math.floor((double)this.y * amount);
    }

    public ILocation translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }
}

