/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.contextbuttons;

import java.awt.Rectangle;
import org.eclipse.graphiti.internal.contextbuttons.AbstractContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.contextbuttons.PositionedContextButton;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class StandardContextButtonPadDeclaration
extends AbstractContextButtonPadDeclaration {
    private static final IColorConstant PAD_OUTER_LINE_COLOR = new ColorConstant(173, 191, 204);
    private static final IColorConstant PAD_MIDDLE_LINE_COLOR = new ColorConstant(255, 255, 255);
    private static final IColorConstant PAD_INNER_LINE_COLOR = new ColorConstant(245, 249, 251);
    private static final IColorConstant PAD_FILL_COLOR = new ColorConstant(235, 243, 247);
    private static final IColorConstant BUTTON_OUTER_LINE_COLOR = new ColorConstant(46, 101, 140);
    private static final IColorConstant BUTTON_MIDDLE_LINE_COLOR = new ColorConstant(255, 255, 255);
    private static final IColorConstant BUTTON_FILL_COLOR = PAD_FILL_COLOR;

    public StandardContextButtonPadDeclaration(IContextButtonPadData contextButtonPadData) {
        super(contextButtonPadData);
    }

    protected int getButtonSize() {
        return 20;
    }

    protected int getButtonPadding() {
        return 1;
    }

    protected int getCollapseButtonPadding() {
        return 10;
    }

    protected int getPadPaddingOutside() {
        return 10;
    }

    protected int getPadPaddingInside() {
        return 4;
    }

    protected int getPadHorizontalOverlap() {
        return 4;
    }

    protected int getPadVerticalOverlap() {
        return 4;
    }

    public int getPadAppendageLength() {
        return 8;
    }

    public int getPadLineWidth() {
        return 1;
    }

    public int getPadCornerRadius() {
        return 12;
    }

    public IColorConstant getPadOuterLineColor() {
        return PAD_OUTER_LINE_COLOR;
    }

    public IColorConstant getPadMiddleLineColor() {
        return PAD_MIDDLE_LINE_COLOR;
    }

    public IColorConstant getPadInnerLineColor() {
        return PAD_INNER_LINE_COLOR;
    }

    public IColorConstant getPadFillColor() {
        return PAD_FILL_COLOR;
    }

    public double getPadDefaultOpacity() {
        return 0.9;
    }

    public PositionedContextButton createButton(IContextButtonEntry entry, Rectangle position) {
        PositionedContextButton ret = new PositionedContextButton(entry, position);
        ret.setLine(1, 4);
        ret.setColors(BUTTON_OUTER_LINE_COLOR, BUTTON_MIDDLE_LINE_COLOR, BUTTON_FILL_COLOR);
        ret.setOpacity(0.0, 0.7, 1.0);
        return ret;
    }
}

