/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDElementDeclarationImpl;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportWsdlSchemaHandler;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.SchemaTreeModel;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.ColumnsInfoPanel;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ResponseSchemaContentsGroup {
    TreeViewer schemaTreeViewer;
    Action createColumnAction;
    Action setRootPathAction;
    ColumnsInfoPanel columnsInfoPanel;
    int type;
    final OperationsDetailsPage detailsPage;

    public ResponseSchemaContentsGroup(Composite parent, int type, OperationsDetailsPage detailsPage) {
        this.type = type;
        this.detailsPage = detailsPage;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        Group schemaContentsGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.SchemaContents, (int)0, (int)1, (int)4);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 120;
        schemaContentsGroup.setLayoutData((Object)gd);
        this.schemaTreeViewer = new TreeViewer((Composite)schemaContentsGroup, 4);
        this.schemaTreeViewer.setContentProvider(this.detailsPage.getSchemaContentProvider());
        this.schemaTreeViewer.setLabelProvider((IBaseLabelProvider)this.detailsPage.getSchemaLabelProvider());
        this.schemaTreeViewer.setAutoExpandLevel(3);
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.schemaTreeViewer.getControl().setLayoutData((Object)data);
        this.schemaTreeViewer.setInput(null);
        final MenuManager columnMenuManager = new MenuManager();
        this.schemaTreeViewer.getControl().setMenu(columnMenuManager.createContextMenu((Control)parent));
        this.schemaTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                columnMenuManager.removeAll();
                IStructuredSelection selection = (IStructuredSelection)ResponseSchemaContentsGroup.this.schemaTreeViewer.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() instanceof SchemaTreeModel.SchemaNode) {
                    Object element = ((SchemaTreeModel.SchemaNode)selection.getFirstElement()).getElement();
                    if (ImportWsdlSchemaHandler.shouldCreateResponseColumn(element)) {
                        columnMenuManager.add((IAction)ResponseSchemaContentsGroup.this.createColumnAction);
                    } else if (element instanceof XSDElementDeclarationImpl) {
                        XSDTypeDefinition type = ((XSDElementDeclarationImpl)element).getTypeDefinition();
                        if (type instanceof XSDComplexTypeDefinition) {
                            columnMenuManager.add((IAction)ResponseSchemaContentsGroup.this.setRootPathAction);
                        }
                    } else if (element instanceof XSDParticleImpl) {
                        columnMenuManager.add((IAction)ResponseSchemaContentsGroup.this.setRootPathAction);
                    }
                }
            }
        });
        this.schemaTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof SchemaTreeModel.SchemaNode && ImportWsdlSchemaHandler.shouldCreateResponseColumn(element = ((SchemaTreeModel.SchemaNode)selection.getFirstElement()).getElement())) {
                    ResponseSchemaContentsGroup.this.createResponseColumn();
                }
            }
        });
        this.createColumnAction = new Action(Messages.AddAsNewElement){

            public void run() {
                ResponseSchemaContentsGroup.this.createResponseColumn();
            }
        };
        this.setRootPathAction = new Action(Messages.SetAsRootPath){

            public void run() {
                ResponseSchemaContentsGroup.this.setRootPath();
            }
        };
    }

    private void setRootPath() {
        IStructuredSelection selection = (IStructuredSelection)this.schemaTreeViewer.getSelection();
        Object obj = selection.getFirstElement();
        String pathValue = ((SchemaTreeModel.SchemaNode)obj).getChildren().iterator().next().getFullPath();
        if (pathValue.endsWith("/")) {
            pathValue = pathValue.substring(0, pathValue.length() - 1);
        }
        this.columnsInfoPanel.getRootPathText().setText(pathValue);
        this.getResponseInfo().setRootPath(pathValue);
        this.columnsInfoPanel.refresh();
    }

    public void setColumnsInfoPanel(ColumnsInfoPanel panel) {
        this.columnsInfoPanel = panel;
    }

    public String createResponseColumn() {
        return this.detailsPage.getSchemaHandler().createResponseColumn(this.type, (IStructuredSelection)this.schemaTreeViewer.getSelection(), this.getResponseInfo());
    }

    public void setInput(Object value) {
        this.schemaTreeViewer.setInput(value);
        this.columnsInfoPanel.disableButtons();
    }

    private ProcedureInfo getResponseInfo() {
        return this.detailsPage.getProcedureGenerator().getResponseInfo();
    }

    public void setEnabled(boolean enable) {
        this.schemaTreeViewer.getTree().setEnabled(enable);
        this.columnsInfoPanel.setEnabled(enable);
    }
}

