/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureInfo;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.table.CheckBoxEditingSupport;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;

public class EditColumnsPanel {
    TableViewerBuilder columnsViewer;
    ProcedureInfo procedureInfo;
    int type;
    final OperationsDetailsPage detailsPage;
    private final int NAME_PROP = 0;
    private final int DEFAULT_VALUE_PROP = 1;
    private final int XML_PATH_PROP = 2;
    private static final String EMPTY = "";

    public EditColumnsPanel(Composite parent, int style, int type, OperationsDetailsPage detailsPage) {
        this.type = type;
        this.detailsPage = detailsPage;
        this.createPanel(parent);
    }

    public ProcedureInfo getProcedureInfo() {
        return this.procedureInfo;
    }

    public void setProcedureInfo(ProcedureInfo info) {
        this.procedureInfo = info;
        this.refresh();
    }

    private void createPanel(Composite parent) {
        this.columnsViewer = new TableViewerBuilder(parent, 2820);
        GridDataFactory.fillDefaults().hint(-1, 80).applyTo((Control)this.columnsViewer.getControl());
        TableViewerColumn column = this.columnsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(String.valueOf(Messages.Name) + this.getSpaces(25));
        column.setEditingSupport((EditingSupport)new ColumnInfoTextEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer(), 0));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        column = this.columnsViewer.createColumn(16384, 10, 20, true);
        column.getColumn().setText(Messages.Ordinality);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new OrdinalityEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column = this.columnsViewer.createColumn(16384, 25, 40, true);
        column.getColumn().setText(String.valueOf(Messages.DataType) + this.getSpaces(2));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new DatatypeComboEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column = this.columnsViewer.createColumn(16384, 20, 40, true);
        column.getColumn().setText(String.valueOf(Messages.DefaultValue) + this.getSpaces(2));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(3));
        column.setEditingSupport((EditingSupport)new ColumnInfoTextEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer(), 1));
        column = this.columnsViewer.createColumn(16384, 15, 40, true);
        column.getColumn().setText(Messages.Path);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(4));
        column.setEditingSupport((EditingSupport)new ColumnInfoTextEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer(), 2));
    }

    public void refresh() {
        this.columnsViewer.getTable().removeAll();
        if (this.type == 0) {
            ColumnInfo[] columnInfoArray = this.procedureInfo.getBodyColumnInfoList();
            int n = columnInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo row = columnInfoArray[n2];
                this.columnsViewer.add((Object)row);
                ++n2;
            }
        } else {
            ColumnInfo[] columnInfoArray = this.procedureInfo.getHeaderColumnInfoList();
            int n = columnInfoArray.length;
            int n3 = 0;
            while (n3 < n) {
                ColumnInfo row = columnInfoArray[n3];
                this.columnsViewer.add((Object)row);
                ++n3;
            }
        }
    }

    public void refresh(Object element) {
        this.columnsViewer.refresh(element);
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.columnsViewer.addSelectionChangedListener(listener);
    }

    public ColumnInfo getSelectedColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.columnsViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof ColumnInfo) {
                return (ColumnInfo)obj;
            }
            ++n2;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.columnsViewer.getTable().getSelectionIndex();
    }

    public void selectRow(int index) {
        if (index > -1) {
            this.columnsViewer.getTable().select(index);
        } else {
            this.columnsViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    private void notifyColumnDataChanged() {
        this.detailsPage.notifyColumnDataChanged();
    }

    private String getSpaces(int nSpaces) {
        StringBuffer sb = new StringBuffer(nSpaces);
        int i = 0;
        while (i < nSpaces) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public void setEnabled(boolean enable) {
        this.columnsViewer.getTable().setEnabled(enable);
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof ColumnInfo) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((ColumnInfo)element).getName();
                    }
                    case 1: {
                        return EditColumnsPanel.EMPTY;
                    }
                    case 2: {
                        return ((ColumnInfo)element).getDatatype();
                    }
                    case 3: {
                        return ((ColumnInfo)element).getDefaultValue();
                    }
                    case 4: {
                        return ((ColumnInfo)element).getRelativePath();
                    }
                }
            }
            return EditColumnsPanel.EMPTY;
        }

        public String getToolTipText(Object element) {
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            if (this.columnNumber == 1) {
                if (element instanceof ColumnInfo) {
                    if (((ColumnInfo)element).getOrdinality()) {
                        return UiPlugin.getDefault().getImage("icons/full/cview16/checked_box.png");
                    }
                    return UiPlugin.getDefault().getImage("icons/full/cview16/unchecked_box.png");
                }
                return null;
            }
            return null;
        }
    }

    class ColumnInfoTextEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;
        private int columnNumber;

        public ColumnInfoTextEditingSupport(ColumnViewer viewer, int type) {
            super(viewer);
            this.columnNumber = type;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof ColumnInfo) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((ColumnInfo)element).getName();
                    }
                    case 1: {
                        return ((ColumnInfo)element).getDefaultValue();
                    }
                    case 2: {
                        return ((ColumnInfo)element).getRelativePath();
                    }
                }
            }
            return EditColumnsPanel.EMPTY;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof ColumnInfo) {
                switch (this.columnNumber) {
                    case 0: {
                        String oldValue = ((ColumnInfo)element).getName();
                        String newValue = (String)value;
                        if (newValue == null || newValue.length() <= 0 || newValue.equalsIgnoreCase(oldValue)) break;
                        ((ColumnInfo)element).setName(newValue);
                        EditColumnsPanel.this.notifyColumnDataChanged();
                        break;
                    }
                    case 1: {
                        String oldValue = ((ColumnInfo)element).getDefaultValue();
                        String newValue = (String)value;
                        if (newValue == null || newValue.length() <= 0 || newValue.equalsIgnoreCase(oldValue)) break;
                        ((ColumnInfo)element).setDefaultValue(newValue);
                        EditColumnsPanel.this.procedureInfo.columnChanged((ColumnInfo)element);
                        EditColumnsPanel.this.notifyColumnDataChanged();
                        break;
                    }
                    case 2: {
                        String oldValue = ((ColumnInfo)element).getRelativePath();
                        String newValue = (String)value;
                        if (newValue == null || newValue.length() <= 0 || newValue.equalsIgnoreCase(oldValue)) break;
                        ((ColumnInfo)element).setRelativePath(newValue);
                        EditColumnsPanel.this.notifyColumnDataChanged();
                    }
                }
            }
        }
    }

    class DatatypeComboEditingSupport
    extends ComboBoxEditingSupport {
        private String[] datatypes;

        public DatatypeComboEditingSupport(ColumnViewer viewer) {
            super(viewer);
            IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
            Set unsortedDatatypes = service.getAllDataTypeNames();
            ArrayList<Object> dTypes = new ArrayList<Object>();
            Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
            Arrays.sort(sortedStrings);
            Object[] objectArray = sortedStrings;
            int n = sortedStrings.length;
            int n2 = 0;
            while (n2 < n) {
                Object dType = objectArray[n2];
                dTypes.add(dType);
                ++n2;
            }
            this.datatypes = dTypes.toArray(new String[dTypes.size()]);
        }

        protected String getElementValue(Object element) {
            return ((ColumnInfo)element).getDatatype();
        }

        protected String[] refreshItems(Object element) {
            return this.datatypes;
        }

        protected void setElementValue(Object element, String newValue) {
            if (!((ColumnInfo)element).getOrdinality()) {
                ((ColumnInfo)element).setDatatype(newValue);
                EditColumnsPanel.this.notifyColumnDataChanged();
            }
        }
    }

    class OrdinalityEditingSupport
    extends CheckBoxEditingSupport {
        public OrdinalityEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setElementValue(Object element, Object newValue) {
            if (element instanceof ColumnInfo && newValue instanceof Boolean) {
                ColumnInfo info = (ColumnInfo)element;
                if (info.getOrdinality()) {
                    EditColumnsPanel.this.procedureInfo.setOrdinality(info, false);
                    EditColumnsPanel.this.notifyColumnDataChanged();
                } else {
                    EditColumnsPanel.this.procedureInfo.setOrdinality(info, true);
                    EditColumnsPanel.this.notifyColumnDataChanged();
                }
            }
        }
    }
}

