/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.xerces.util.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.ui.dialogs.ConnectionProfileWorker;
import org.teiid.designer.datatools.ui.dialogs.IProfileChangedListener;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.util.ModelGeneratorWsdlUiUtil;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportWsdlSoapWizard;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.WsdlOperationsPanel;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class WsdlDefinitionPage
extends WizardPage
implements IChangeListener,
Listener,
IProfileChangedListener,
FileUtils.Constants,
ModelGeneratorWsdlUiConstants,
ModelGeneratorWsdlUiConstants.Images,
ModelGeneratorWsdlUiConstants.HelpContexts {
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    private Button buttonValidateWSDL;
    private Text wsdlURIText;
    private Text endPointNameText;
    private Text endPointURIText;
    private Button newCPButton;
    private Button editCPButton;
    private WSDLImportWizardManager importManager;
    private MultiStatus wsdlStatus;
    private boolean initializing = false;
    private Combo connectionProfilesCombo;
    private ILabelProvider profileLabelProvider;
    private ConnectionProfileWorker profileWorker;
    boolean synchronizing = false;
    WsdlOperationsPanel operationsPanel;
    ImportWsdlSoapWizard wizard;

    public WsdlDefinitionPage(WSDLImportWizardManager theImportManager, ImportWsdlSoapWizard wizard) {
        super(WsdlDefinitionPage.class.getSimpleName(), Messages.WsdlDefinitionPage_title, null);
        this.importManager = theImportManager;
        this.wizard = wizard;
        this.setImageDescriptor(ModelGeneratorWsdlUiUtil.getImageDescriptor("icons/full/wizban/new_wsdl_wiz.gif"));
        this.importManager.addChangeListener(this);
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.buttonValidateWSDL) {
                this.handleValidateWSDLButtonPressed();
                validate = true;
            }
            if (validate) {
                this.setPageStatus();
            }
        }
    }

    private void updateWidgetEnablements() {
        this.updateValidateWSDLButtonEnablement();
    }

    private void updateValidateWSDLButtonEnablement() {
        if (this.wsdlStatus != null && this.wsdlStatus.isOK()) {
            this.buttonValidateWSDL.setEnabled(false);
        } else if (this.importManager.getWSDLFileUri() != null) {
            this.buttonValidateWSDL.setEnabled(true);
        } else {
            this.buttonValidateWSDL.setEnabled(false);
        }
    }

    public void createControl(Composite theParent) {
        this.profileWorker = new ConnectionProfileWorker(this.getShell(), "org.teiid.designer.datatools.profiles.ws.WSSoapConnectionProfile", (IProfileChangedListener)this);
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnlMain.setLayout((Layout)layout);
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, "org.teiid.designer.modelgenerator.wsdl.ui.wsdlSelectionPage");
        this.createSourceSelectionComposite(pnlMain);
        this.createWsdlOperationsPanel(pnlMain);
        this.setPageStatus();
    }

    private void createSourceSelectionComposite(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(1, false));
        Group profileGroup = WidgetFactory.createGroup((Composite)pnl, (String)Messages.WsdlDefinitionPage_profileLabel_text, (int)0, (int)2, (int)3);
        profileGroup.setLayoutData((Object)new GridData(768));
        this.profileLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                if (source == null) {
                    return "";
                }
                return ((IConnectionProfile)source).getName();
            }
        };
        this.connectionProfilesCombo = WidgetFactory.createCombo((Composite)profileGroup, (int)8, (int)768, (List)this.profileWorker.getProfiles(), (ILabelProvider)this.profileLabelProvider, (boolean)true);
        this.connectionProfilesCombo.setForeground(Display.getCurrent().getSystemColor(10));
        this.connectionProfilesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WsdlDefinitionPage.this.handleConnectionProfileSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.connectionProfilesCombo.setVisibleItemCount(10);
        this.newCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)Messages.New);
        this.newCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WsdlDefinitionPage.this.profileWorker.create();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)Messages.Edit);
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WsdlDefinitionPage.this.profileWorker.edit();
            }
        });
        Group wsdlURIGroup = WidgetFactory.createGroup((Composite)pnl, (String)Messages.WsdlDefinitionPage_wsdlLabel_text, (int)4, (int)2, (int)2);
        wsdlURIGroup.setLayoutData((Object)new GridData(768));
        this.wsdlURIText = new Text((Composite)wsdlURIGroup, 2052);
        this.wsdlURIText.setToolTipText(Messages.WsdlDefinitionPage_workspaceTextField_tooltip);
        this.wsdlURIText.setForeground(wsdlURIGroup.getDisplay().getSystemColor(10));
        this.wsdlURIText.setBackground(wsdlURIGroup.getDisplay().getSystemColor(19));
        this.wsdlURIText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.wsdlURIText);
        this.buttonValidateWSDL = WidgetFactory.createButton((Composite)wsdlURIGroup, (String)Messages.WsdlDefinitionPage_validateWsdlButton_text, (int)128, (int)1);
        this.buttonValidateWSDL.setToolTipText(Messages.WsdlDefinitionPage_validateWsdlButton_tooltip);
        this.buttonValidateWSDL.addListener(13, (Listener)this);
        Group endPointGroup = WidgetFactory.createGroup((Composite)pnl, (String)Messages.WsdlDefinitionPage_endPointLabel_text, (int)4, (int)2, (int)4);
        endPointGroup.setLayoutData((Object)new GridData(768));
        Label endPointNameLabel = WidgetFactory.createLabel((Composite)endPointGroup, (String)Messages.WsdlDefinitionPage_endPointNameLabel_label);
        endPointNameLabel.setToolTipText(Messages.WsdlDefinitionPage_endPointNameTextField_tooltip);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)endPointNameLabel);
        this.endPointNameText = new Text((Composite)endPointGroup, 2052);
        this.endPointNameText.setToolTipText(Messages.WsdlDefinitionPage_endPointNameTextField_tooltip);
        this.endPointNameText.setForeground(endPointGroup.getDisplay().getSystemColor(10));
        this.endPointNameText.setBackground(endPointGroup.getDisplay().getSystemColor(19));
        this.endPointNameText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.endPointNameText);
        Label endPointURILabel = WidgetFactory.createLabel((Composite)endPointGroup, (String)Messages.WsdlDefinitionPage_endPointURILabel_label);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)endPointURILabel);
        this.endPointURIText = new Text((Composite)endPointGroup, 2052);
        this.endPointURIText.setToolTipText(Messages.WsdlDefinitionPage_endPointURITextField_tooltip);
        this.endPointURIText.setForeground(endPointGroup.getDisplay().getSystemColor(10));
        this.endPointURIText.setBackground(endPointGroup.getDisplay().getSystemColor(19));
        this.endPointURIText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.endPointURIText);
        this.updateWidgetEnablements();
    }

    private void handleConnectionProfileSelected() {
        String name;
        int selIndex = this.connectionProfilesCombo.getSelectionIndex();
        if (selIndex >= 0 && (name = this.connectionProfilesCombo.getItem(selIndex)) != null) {
            if (this.importManager.getConnectionProfile() != null && this.importManager.getConnectionProfile().getName().equals(name)) {
                this.operationsPanel.notifyWsdlChanged(false);
                return;
            }
            IConnectionProfile currentProfile = this.importManager.getConnectionProfile();
            IConnectionProfile profile = this.profileWorker.getProfile(name);
            boolean profileChanged = true;
            if (currentProfile != null && currentProfile.getName().equals(profile.getName())) {
                profileChanged = false;
            }
            this.profileWorker.setSelection(profile);
            this.setConnectionProfileInternal(profile);
            if (profileChanged) {
                this.wsdlStatus = null;
            }
            this.operationsPanel.notifyWsdlChanged(true);
        }
        this.notifyChanged();
    }

    private void createWsdlOperationsPanel(Composite theParent) {
        this.operationsPanel = new WsdlOperationsPanel(theParent, this, this.importManager);
    }

    public void dispose() {
        this.saveState();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("ModelGeneratorWsdlUi");
            settings = temp == null ? settings.addNewSection("ModelGeneratorWsdlUi") : temp;
        }
        return settings;
    }

    private void handleValidateWSDLButtonPressed() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                WsdlDefinitionPage.this.validateWSDL(monitor);
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dlg.run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception err) {
            err.printStackTrace(System.err);
        }
        if (!this.wsdlStatus.isOK()) {
            Shell shell = this.getShell();
            ErrorDialog.openError((Shell)shell, (String)Messages.WsdlDefinitionPage_dialog_wsdlValidationError_title, (String)Messages.WsdlDefinitionPage_dialog_wsdlValidationError_msg, (IStatus)this.wsdlStatus);
        }
        this.updateValidateWSDLButtonEnablement();
        this.notifyChanged();
    }

    void validateWSDL(IProgressMonitor monitor) {
        this.wsdlStatus = this.importManager.validateWSDL(monitor);
    }

    public boolean isValidUri(String str) {
        try {
            new URI(str);
        }
        catch (URI.MalformedURIException malformedURIException) {
            return false;
        }
        return true;
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.getContainer() != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    private void refreshUiFromManager() {
        this.synchronizing = true;
        if (this.importManager != null) {
            if (this.connectionProfilesCombo.getItems() == null || this.connectionProfilesCombo.getItems().length == 0) {
                if (this.profileWorker.getProfiles().isEmpty()) {
                    this.setErrorMessage(Messages.WsdlDefinitionPage_no_profile_match);
                    WidgetUtil.setText((Text)this.wsdlURIText, null);
                    WidgetUtil.setText((Text)this.endPointNameText, null);
                    WidgetUtil.setText((Text)this.endPointURIText, null);
                    this.buttonValidateWSDL.setEnabled(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setMessage(Messages.WsdlDefinitionPage_select_profile);
                return;
            }
            if (this.connectionProfilesCombo.getSelectionIndex() < 0) {
                return;
            }
            String profileName = this.connectionProfilesCombo.getText();
            IConnectionProfile profile = this.profileWorker.getProfile(profileName);
            if (profile == null) {
                this.setMessage(null);
                this.setErrorMessage(NLS.bind((String)Messages.WsdlDefinitionPage_no_profile_match, (Object[])new Object[]{profileName}));
                this.buttonValidateWSDL.setEnabled(false);
                return;
            }
            if (this.importManager.getConnectionProfile() == null) {
                this.importManager.setConnectionProfile(profile);
                this.importManager.validate();
            }
            Properties props = profile.getBaseProperties();
            WidgetUtil.setText((Text)this.wsdlURIText, (String)props.getProperty("wsdlURI"));
            WidgetUtil.setText((Text)this.endPointNameText, (String)props.getProperty("EndPointName"));
            WidgetUtil.setText((Text)this.endPointURIText, (String)ConnectionInfoHelper.readEndPointProperty((Properties)props));
            this.updateWidgetEnablements();
            this.setErrorMessage(null);
            this.setMessage(Messages.WsdlDefinitionPage_select_profile);
        }
        this.synchronizing = false;
    }

    public void profileChanged(IConnectionProfile profile) {
        this.resetCPComboItems();
        String profileName = profile != null ? profile.getName() : null;
        this.selectConnectionProfile(profileName);
        this.setConnectionProfileInternal(profile);
        this.notifyChanged();
    }

    public void setPageStatus() {
        IStatus connProfileStatus = this.importManager.getValidator().getConnectionProfileStatus();
        if (connProfileStatus.getSeverity() != 0) {
            WizardUtil.setPageComplete((WizardPage)this, (String)this.importManager.getValidator().getPrimaryMessage(connProfileStatus), (int)WizardUtil.getMessageSeverity((int)connProfileStatus.getSeverity()));
            return;
        }
        boolean sourceValid = this.validateSourceSelection();
        if (!sourceValid) {
            return;
        }
        if (this.importManager.getSelectedOperations().size() == 0) {
            WizardUtil.setPageComplete((WizardPage)this, (String)Messages.NoOperationsSelected, (int)3);
        } else if (this.wsdlStatus != null && this.wsdlStatus.getSeverity() > 2) {
            WizardUtil.setPageComplete((WizardPage)this, (String)Messages.WsdlDefinitionPage_wsdlErrorContinuation_msg, (int)2);
        } else if (this.operationsPanel.getStatus().getSeverity() > 2) {
            WizardUtil.setPageComplete((WizardPage)this, (String)this.operationsPanel.getStatus().getMessage(), (int)3);
        } else {
            WizardUtil.setPageComplete((WizardPage)this);
        }
        this.getContainer().updateButtons();
    }

    public void setInitialSelection(ISelection theSelection) {
        this.importManager.setWSDLFileUri(null);
        if (!theSelection.isEmpty() && theSelection instanceof IStructuredSelection) {
            IContainer container;
            Object[] selectedObjects = ((IStructuredSelection)theSelection).toArray();
            if (selectedObjects.length == 1 && (container = ModelUtil.getContainer((Object)selectedObjects[0])) != null) {
                this.importManager.setViewModelLocation(container);
                this.importManager.setSourceModelLocation(container);
            }
            int i = 0;
            while (i < selectedObjects.length) {
                File fNew;
                if (selectedObjects[i] instanceof IFile && (ModelUtilities.isWsdlFile((IResource)((IFile)selectedObjects[i])) || ModelUtilities.isModelFile((IResource)((IFile)selectedObjects[i]))) && (fNew = ((IFile)selectedObjects[i]).getLocation().toFile()) != null) {
                    String uriStr = null;
                    try {
                        uriStr = fNew.toURI().toURL().toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {}
                    if (ModelUtilities.isWsdlFile((IResource)((IFile)selectedObjects[i]))) {
                        this.importManager.setUriSource(0);
                        this.importManager.setWSDLFileUri(uriStr);
                        break;
                    }
                    if (ModelUtilities.isModelFile((IResource)((IFile)selectedObjects[i]))) {
                        this.importManager.setViewModelName(uriStr.substring(uriStr.lastIndexOf(47) + 1));
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private boolean validateSourceSelection() {
        String msg = Messages.WsdlDefinitionPage_pageComplete_msg;
        String sourceWsdl = this.importManager.getWSDLFileUri();
        if (sourceWsdl == null) {
            msg = Messages.WsdlDefinitionPage_noWsdlSelected_msg;
            WizardUtil.setPageComplete((WizardPage)this, (String)msg, (int)3);
            return false;
        }
        if (this.wsdlStatus != null && this.wsdlStatus.getSeverity() > 2) {
            msg = this.wsdlStatus.getMessage();
            WizardUtil.setPageComplete((WizardPage)this, (String)msg, (int)3);
            return false;
        }
        WizardUtil.setPageComplete((WizardPage)this);
        return true;
    }

    void resetCPComboItems() {
        if (this.connectionProfilesCombo != null) {
            ArrayList<IConnectionProfile> profileList = new ArrayList<IConnectionProfile>();
            for (IConnectionProfile prof : this.profileWorker.getProfiles()) {
                profileList.add(prof);
            }
            WidgetUtil.setComboItems((Combo)this.connectionProfilesCombo, profileList, (ILabelProvider)this.profileLabelProvider, (boolean)true);
        }
    }

    public boolean selectConnectionProfile(String name) {
        if (name == null) {
            return false;
        }
        int cpIndex = -1;
        int i = 0;
        String[] stringArray = this.connectionProfilesCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                cpIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        boolean profileChanged = false;
        if (cpIndex > -1) {
            this.connectionProfilesCombo.select(cpIndex);
            IConnectionProfile profile = this.profileWorker.getProfile(this.connectionProfilesCombo.getText());
            this.profileWorker.setSelection(profile);
            IConnectionProfile currentProfile = this.importManager.getConnectionProfile();
            if (profile != currentProfile) {
                profileChanged = true;
                this.setConnectionProfileInternal(profile);
            }
        }
        this.operationsPanel.notifyWsdlChanged(profileChanged);
        return profileChanged;
    }

    private void setConnectionProfileInternal(IConnectionProfile profile) {
        this.importManager.setConnectionProfile(profile);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            boolean profileChanged = false;
            if (this.connectionProfilesCombo.getItemCount() > 0) {
                if (this.importManager.getConnectionProfile() != null) {
                    if (this.connectionProfilesCombo.getText() != null && this.connectionProfilesCombo.getText().equals(this.importManager.getConnectionProfile().getName())) {
                        profileChanged = this.selectConnectionProfile(this.importManager.getConnectionProfile().getName());
                    }
                } else if (this.connectionProfilesCombo.getSelectionIndex() < 0) {
                    this.connectionProfilesCombo.select(0);
                    profileChanged = true;
                }
            }
            this.refreshUiFromManager();
            if (profileChanged) {
                this.handleConnectionProfileSelected();
            }
            this.setPageStatus();
        }
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.setPageStatus();
    }

    private void notifyChanged() {
        this.refreshUiFromManager();
        this.importManager.notifyChanged();
    }
}

