/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.provider.XSDSemanticItemProviderAdapterFactory;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.util.ModelGeneratorWsdlUiUtil;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportWsdlSchemaHandler;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureGenerator;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.SchemaNodeWrapper;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.SchemaTreeContentProvider;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.SchemaTreeLabelProvider;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.SchemaTreeModel;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.ColumnsInfoPanel;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.ElementsInfoPanel;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.RequestSchemaContentsGroup;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.ResponseSchemaContentsGroup;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.WrapperProcedurePanel;
import org.teiid.designer.query.proc.wsdl.IWsdlConstants;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class OperationsDetailsPage
extends AbstractWizardPage
implements IChangeListener,
ModelGeneratorWsdlUiConstants {
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    WSDLImportWizardManager importManager;
    Combo operationsCombo;
    private XSDSemanticItemProviderAdapterFactory semanticAdapterFactory;
    private AdapterFactoryLabelProvider schemaLabelProvider;
    private SchemaTreeContentProvider schemaContentProvider;
    protected XSDSchema xsdSchema;
    TabFolder tabFolder;
    TabItem requestTab;
    Text requestProcedureNameText;
    TextViewer requestSqlTextViewer;
    IDocument requestSqlDocument;
    RequestSchemaContentsGroup requestBodySchemaContentsGroup;
    ElementsInfoPanel requestBodyElementsInfoPanel;
    RequestSchemaContentsGroup requestHeaderSchemaContentsGroup;
    ElementsInfoPanel requestHeaderElementsInfoPanel;
    TabItem requestHeaderTab;
    Composite requestHeaderStackPanel;
    StackLayout requestHeaderStackLayout;
    Composite disabledRequestHeaderPanel;
    SashForm requestHeaderSplitter;
    TabItem responseTab;
    Text responseProcedureNameText;
    TextViewer responseSqlTextViewer;
    IDocument responseSqlDocument;
    ResponseSchemaContentsGroup responseBodySchemaContentsGroup;
    ColumnsInfoPanel responseBodyColumnsInfoPanel;
    ResponseSchemaContentsGroup responseHeaderSchemaContentsGroup;
    ColumnsInfoPanel responseHeaderColumnsInfoPanel;
    TabItem responseHeaderTab;
    Composite responseHeaderStackPanel;
    StackLayout responseHeaderStackLayout;
    Composite disabledResponseHeaderPanel;
    SashForm responseHeaderSplitter;
    TabFolder wrapperTab;
    WrapperProcedurePanel wrapperPanel;
    Button overwriteExistingCB;
    private ProcedureGenerator procedureGenerator;
    ImportWsdlSchemaHandler schemaHandler;

    public OperationsDetailsPage(WSDLImportWizardManager theImportManager) {
        super(OperationsDetailsPage.class.getSimpleName(), Messages.ProcedureDefinition);
        this.importManager = theImportManager;
        this.importManager.setSelectedOperations(new ArrayList<Operation>());
        this.setImageDescriptor(ModelGeneratorWsdlUiUtil.getImageDescriptor("icons/full/wizban/new_wsdl_wiz.gif"));
        this.semanticAdapterFactory = new XSDSemanticItemProviderAdapterFactory();
        this.schemaLabelProvider = new SchemaTreeLabelProvider((AdapterFactory)this.semanticAdapterFactory);
        this.schemaContentProvider = new SchemaTreeContentProvider((AdapterFactory)this.semanticAdapterFactory);
        this.schemaHandler = new ImportWsdlSchemaHandler(theImportManager, this);
        this.importManager.addChangeListener(this);
    }

    public ProcedureGenerator getProcedureGenerator() {
        return this.procedureGenerator;
    }

    private void notifyOperationChanged(Operation operation) {
        this.procedureGenerator = this.importManager.getProcedureGenerator(operation);
        this.wrapperPanel.notifyOperationChanged(operation);
        this.requestProcedureNameText.setText(this.procedureGenerator.getRequestProcedureName());
        this.responseProcedureNameText.setText(this.procedureGenerator.getResponseProcedureName());
        this.requestBodyElementsInfoPanel.setProcedureInfo(this.procedureGenerator.getRequestInfo());
        this.responseBodyColumnsInfoPanel.setProcedureInfo(this.procedureGenerator.getResponseInfo());
        this.requestHeaderElementsInfoPanel.setProcedureInfo(this.procedureGenerator.getRequestInfo());
        this.responseHeaderColumnsInfoPanel.setProcedureInfo(this.procedureGenerator.getResponseInfo());
        this.overwriteExistingCB.setSelection(this.procedureGenerator.doOverwriteExistingProcedures());
        this.overwriteExistingCB.setEnabled(this.importManager.viewModelExists());
        this.updateSqlText(IWsdlConstants.ProcedureType.BOTH);
        this.updateSchemaTree(IWsdlConstants.ProcedureType.BOTH);
        this.updateStatus();
    }

    public void notifyColumnDataChanged() {
        if (!this.responseBodyColumnsInfoPanel.getRootPathText().getText().equals("")) {
            this.schemaHandler.getResponseSchemaTreeModel().setRootPath(this.responseBodyColumnsInfoPanel.getRootPathText().getText());
            this.getProcedureGenerator().getResponseInfo().setRootPath(this.responseBodyColumnsInfoPanel.getRootPathText().getText());
        }
        this.requestBodyElementsInfoPanel.refresh();
        this.requestHeaderElementsInfoPanel.refresh();
        this.responseBodyColumnsInfoPanel.refresh();
        this.responseHeaderColumnsInfoPanel.refresh();
        this.updateSqlText(IWsdlConstants.ProcedureType.BOTH);
        this.wrapperPanel.notifyOperationChanged(this.getProcedureGenerator().getOperation());
        this.updateStatus();
    }

    public void notifyRootTextColumnDataChanged() {
        this.schemaHandler.getResponseSchemaTreeModel().setRootPath(this.responseBodyColumnsInfoPanel.getRootPathText().getText());
        this.updateStatus();
    }

    public void updateStatus() {
        this.importManager.notifyChanged();
    }

    public WSDLImportWizardManager getImportManager() {
        return this.importManager;
    }

    public IContentProvider getSchemaContentProvider() {
        return this.schemaContentProvider;
    }

    public ILabelProvider getSchemaLabelProvider() {
        return this.schemaLabelProvider;
    }

    public ImportWsdlSchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(2, false);
        pnlMain.setLayout((Layout)layout);
        this.setControl((Control)pnlMain);
        this.createOperationsSelectionPanel(pnlMain);
        this.createTabbedDetailsPanel(pnlMain);
    }

    private void createOperationsSelectionPanel(Composite parent) {
        Group operationsGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.Operations, (int)1808, (int)2, (int)2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        operationsGroup.setLayoutData((Object)gd);
        this.operationsCombo = new Combo((Composite)operationsGroup, 8);
        this.operationsCombo.setLayoutData((Object)new GridData(768));
        gd.horizontalSpan = 2;
        this.operationsCombo.setLayoutData((Object)gd);
        this.operationsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                OperationsDetailsPage.this.selectComboItem(OperationsDetailsPage.this.operationsCombo.getSelectionIndex());
            }
        });
        this.overwriteExistingCB = new Button((Composite)operationsGroup, 32);
        this.overwriteExistingCB.setText(Messages.OverwriteExistingProcedures);
        gd.horizontalSpan = 2;
        this.overwriteExistingCB.setLayoutData((Object)gd);
        this.overwriteExistingCB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OperationsDetailsPage.this.handleOverwriteSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.overwriteExistingCB.setEnabled(this.importManager.viewModelExists());
    }

    private List<String> getOperationsNameList() {
        ArrayList<String> nameList = new ArrayList<String>();
        for (Operation op : this.importManager.getSelectedOperations()) {
            nameList.add(op.getName());
        }
        return nameList;
    }

    private void createTabbedDetailsPanel(Composite parent) {
        this.tabFolder = new TabFolder(parent, 2176);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.createRequestTab(this.tabFolder);
        this.createResponseTab(this.tabFolder);
        this.createWrapperTab(this.tabFolder);
    }

    private void createRequestTab(TabFolder tabFolder) {
        Composite panel = WidgetFactory.createPanel((Composite)tabFolder);
        this.requestTab = new TabItem(tabFolder, 0);
        this.requestTab.setControl((Control)panel);
        this.requestTab.setText(Messages.Request);
        panel.setLayout((Layout)new GridLayout(2, false));
        Composite namePanel = WidgetFactory.createPanel((Composite)panel);
        namePanel.setLayout((Layout)new GridLayout(2, false));
        GridData namePanelGD = new GridData(768);
        namePanelGD.horizontalSpan = 2;
        namePanel.setLayoutData((Object)namePanelGD);
        Label procedureNameLabel = new Label(namePanel, 0);
        procedureNameLabel.setText(Messages.GeneratedProcedureName);
        this.requestProcedureNameText = new Text(namePanel, 2052);
        WidgetUtil.colorizeWidget((Control)this.requestProcedureNameText, (int)1, (boolean)true);
        this.requestProcedureNameText.setLayoutData((Object)new GridData(768));
        this.requestProcedureNameText.setEditable(false);
        this.createTabbedRequestPanel(panel);
        this.createRequestSqlGroup(panel);
    }

    private void createRequestBodySplitter(Composite parent) {
        SashForm splitter = new SashForm(parent, 256);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        splitter.setLayoutData((Object)gid);
        this.requestBodySchemaContentsGroup = new RequestSchemaContentsGroup((Composite)splitter, 0, this);
        this.requestBodyElementsInfoPanel = new ElementsInfoPanel((Composite)splitter, 0, 0, this);
        this.requestBodySchemaContentsGroup.setElementsInfoPanel(this.requestBodyElementsInfoPanel);
        splitter.setWeights(new int[]{60, 40});
    }

    private void createTabbedRequestPanel(Composite parent) {
        TabFolder requestTabFolder = new TabFolder(parent, 18432);
        requestTabFolder.setLayoutData((Object)new GridData(1808));
        this.createRequestBodyTab(requestTabFolder);
        this.createRequestHeaderTab(requestTabFolder);
    }

    private void createRequestBodyTab(TabFolder tabFolder) {
        Composite panel = WidgetFactory.createPanel((Composite)tabFolder);
        TabItem requestBodyTab = new TabItem(tabFolder, 0);
        requestBodyTab.setControl((Control)panel);
        requestBodyTab.setText(Messages.Body_upper_case);
        this.createRequestBodySplitter(panel);
    }

    private void createRequestHeaderTab(TabFolder tabFolder) {
        Composite panel = WidgetFactory.createPanel((Composite)tabFolder);
        this.requestHeaderTab = new TabItem(tabFolder, 0);
        this.requestHeaderTab.setControl((Control)panel);
        this.requestHeaderTab.setText(Messages.Header_upper_case);
        this.requestHeaderStackPanel = new Composite(panel, 4);
        this.requestHeaderStackLayout = new StackLayout();
        this.requestHeaderStackLayout.marginWidth = 0;
        this.requestHeaderStackLayout.marginHeight = 0;
        this.requestHeaderStackPanel.setLayout((Layout)this.requestHeaderStackLayout);
        this.requestHeaderStackPanel.setLayoutData((Object)new GridData(768));
        this.createRequestHeaderSplitter(this.requestHeaderStackPanel);
        this.createRequestHeaderDisabledPanel(this.requestHeaderStackPanel);
        this.requestHeaderStackLayout.topControl = this.requestHeaderStackPanel;
    }

    private void createRequestHeaderDisabledPanel(Composite parent) {
        this.disabledRequestHeaderPanel = WidgetFactory.createPanel((Composite)parent, (int)0);
        this.disabledRequestHeaderPanel.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.disabledRequestHeaderPanel.setLayoutData((Object)gd);
        Label label = new Label(this.disabledRequestHeaderPanel, 0);
        label.setText(Messages.NoHeaderMessage);
    }

    private void createRequestHeaderSplitter(Composite parent) {
        this.requestHeaderSplitter = new SashForm(parent, 256);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        this.requestHeaderSplitter.setLayoutData((Object)gid);
        this.requestHeaderSchemaContentsGroup = new RequestSchemaContentsGroup((Composite)this.requestHeaderSplitter, 1, this);
        this.requestHeaderElementsInfoPanel = new ElementsInfoPanel((Composite)this.requestHeaderSplitter, 0, 1, this);
        this.requestHeaderSchemaContentsGroup.setElementsInfoPanel(this.requestHeaderElementsInfoPanel);
        this.requestHeaderSplitter.setWeights(new int[]{60, 40});
    }

    private void createRequestSqlGroup(Composite parent) {
        Group group = WidgetFactory.createGroup((Composite)parent, (String)Messages.GeneratedSQLStatement, (int)0, (int)2);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        ColorManager colorManager = new ColorManager();
        int styles = 68162;
        this.requestSqlTextViewer = new SqlTextViewer((Composite)group, (IVerticalRuler)new VerticalRuler(0), styles, colorManager);
        this.requestSqlDocument = new Document();
        this.requestSqlTextViewer.setInput((Object)this.requestSqlDocument);
        this.requestSqlTextViewer.setEditable(false);
        WidgetUtil.colorizeWidget((Control)this.requestSqlTextViewer.getTextWidget(), (int)0, (boolean)true);
        this.requestSqlDocument.set("");
        this.requestSqlTextViewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    private void createResponseTab(TabFolder tabFolder) {
        Composite panel = WidgetFactory.createPanel((Composite)tabFolder);
        this.responseTab = new TabItem(tabFolder, 0);
        this.responseTab.setControl((Control)panel);
        this.responseTab.setText(Messages.Response);
        panel.setLayout((Layout)new GridLayout(2, false));
        Composite namePanel = WidgetFactory.createPanel((Composite)panel);
        namePanel.setLayout((Layout)new GridLayout(2, false));
        GridData namePanelGD = new GridData(768);
        namePanelGD.horizontalSpan = 2;
        namePanel.setLayoutData((Object)namePanelGD);
        Label procedureNameLabel = new Label(namePanel, 0);
        procedureNameLabel.setText(Messages.GeneratedProcedureName);
        this.responseProcedureNameText = new Text(namePanel, 2052);
        WidgetUtil.colorizeWidget((Control)this.responseProcedureNameText, (int)1, (boolean)true);
        this.responseProcedureNameText.setLayoutData((Object)new GridData(768));
        this.responseProcedureNameText.setEditable(false);
        this.createTabbedReponsePanel(panel);
        this.createResponseSqlGroup(panel);
    }

    private void createResponseBodySplitter(Composite parent) {
        SashForm splitter = new SashForm(parent, 256);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        splitter.setLayoutData((Object)gid);
        this.responseBodySchemaContentsGroup = new ResponseSchemaContentsGroup((Composite)splitter, 0, this);
        this.responseBodyColumnsInfoPanel = new ColumnsInfoPanel((Composite)splitter, 0, 0, this);
        this.responseBodySchemaContentsGroup.setColumnsInfoPanel(this.responseBodyColumnsInfoPanel);
        splitter.setWeights(new int[]{40, 60});
    }

    private void createResponseHeaderSplitter(Composite parent) {
        this.responseHeaderSplitter = new SashForm(parent, 256);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        this.responseHeaderSplitter.setLayoutData((Object)gid);
        this.responseHeaderSchemaContentsGroup = new ResponseSchemaContentsGroup((Composite)this.responseHeaderSplitter, 1, this);
        this.responseHeaderColumnsInfoPanel = new ColumnsInfoPanel((Composite)this.responseHeaderSplitter, 0, 1, this);
        this.responseHeaderSchemaContentsGroup.setColumnsInfoPanel(this.responseHeaderColumnsInfoPanel);
        this.responseHeaderSplitter.setWeights(new int[]{40, 60});
    }

    private void createTabbedReponsePanel(Composite parent) {
        TabFolder responseTabFolder = new TabFolder(parent, 18432);
        responseTabFolder.setLayoutData((Object)new GridData(1808));
        this.createResponseBodyTab(responseTabFolder);
        this.createResponseHeaderTab(responseTabFolder);
    }

    private void createResponseBodyTab(TabFolder tabFolder) {
        Composite panel = WidgetFactory.createPanel((Composite)tabFolder);
        TabItem requestBodyTab = new TabItem(tabFolder, 0);
        requestBodyTab.setControl((Control)panel);
        requestBodyTab.setText(Messages.Body_upper_case);
        this.createResponseBodySplitter(panel);
    }

    private void createResponseHeaderTab(TabFolder tabFolder) {
        Composite panel = WidgetFactory.createPanel((Composite)tabFolder);
        this.responseHeaderTab = new TabItem(tabFolder, 0);
        this.responseHeaderTab.setControl((Control)panel);
        this.responseHeaderTab.setText(Messages.Header_upper_case);
        this.responseHeaderStackPanel = new Composite(panel, 4);
        this.responseHeaderStackLayout = new StackLayout();
        this.responseHeaderStackLayout.marginWidth = 0;
        this.responseHeaderStackLayout.marginHeight = 0;
        this.responseHeaderStackPanel.setLayout((Layout)this.responseHeaderStackLayout);
        this.responseHeaderStackPanel.setLayoutData((Object)new GridData(768));
        this.createResponseHeaderSplitter(this.responseHeaderStackPanel);
        this.createResponseHeaderDisabledPanel(this.responseHeaderStackPanel);
        this.responseHeaderStackLayout.topControl = this.responseHeaderStackPanel;
    }

    private void createResponseHeaderDisabledPanel(Composite parent) {
        this.disabledResponseHeaderPanel = WidgetFactory.createPanel((Composite)parent, (int)0);
        this.disabledResponseHeaderPanel.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.disabledResponseHeaderPanel.setLayoutData((Object)gd);
        Label label = new Label(this.disabledResponseHeaderPanel, 0);
        label.setText(Messages.NoHeaderMessage);
    }

    private void createResponseSqlGroup(Composite parent) {
        Group group = WidgetFactory.createGroup((Composite)parent, (String)Messages.GeneratedSQLStatement, (int)0, (int)2);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        ColorManager colorManager = new ColorManager();
        int styles = 68162;
        this.responseSqlTextViewer = new SqlTextViewer((Composite)group, (IVerticalRuler)new VerticalRuler(0), styles, colorManager);
        this.responseSqlDocument = new Document();
        this.responseSqlTextViewer.setInput((Object)this.responseSqlDocument);
        this.responseSqlTextViewer.setEditable(false);
        this.responseSqlTextViewer.getTextWidget().setBackground(Display.getCurrent().getSystemColor(19));
        this.responseSqlDocument.set("");
        this.responseSqlTextViewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    private void createWrapperTab(TabFolder tabFolder) {
        Composite panel = WidgetFactory.createPanel((Composite)tabFolder);
        this.responseTab = new TabItem(tabFolder, 0);
        this.responseTab.setControl((Control)panel);
        this.responseTab.setText(Messages.WrapperProcedure);
        panel.setLayout((Layout)new GridLayout(1, false));
        this.wrapperPanel = new WrapperProcedurePanel(panel, this);
    }

    private void selectComboItem(int selectionIndex) {
        if (selectionIndex >= 0) {
            this.operationsCombo.select(selectionIndex);
            String operationName = this.operationsCombo.getItem(selectionIndex);
            for (Operation op : this.importManager.getSelectedOperations()) {
                if (!op.getName().equalsIgnoreCase(operationName)) continue;
                this.notifyOperationChanged(op);
                break;
            }
        }
    }

    private void handleOverwriteSelected() {
        if (this.getProcedureGenerator() != null) {
            this.getProcedureGenerator().setOverwriteExistingProcedures(this.overwriteExistingCB.getSelection());
            this.notifyOperationChanged(this.getProcedureGenerator().getOperation());
        }
    }

    void updateSqlText(IWsdlConstants.ProcedureType type) {
        if (this.procedureGenerator != null) {
            switch (type) {
                case REQUEST: {
                    this.requestSqlTextViewer.getDocument().set(this.procedureGenerator.getRequestInfo().getSqlString(new Properties()));
                    break;
                }
                case RESPONSE: {
                    this.responseSqlTextViewer.getDocument().set(this.procedureGenerator.getResponseInfo().getSqlString(new Properties()));
                    break;
                }
                case BOTH: {
                    this.requestSqlTextViewer.getDocument().set(this.procedureGenerator.getRequestInfo().getSqlString(new Properties()));
                    this.responseSqlTextViewer.getDocument().set(this.procedureGenerator.getResponseInfo().getSqlString(new Properties()));
                }
            }
        }
    }

    void updateSchemaTree(IWsdlConstants.ProcedureType type) {
        switch (type) {
            case REQUEST: {
                SchemaNodeWrapper nodeInput = new SchemaNodeWrapper(this.getSchemaForSelectedOperation(IWsdlConstants.ProcedureType.REQUEST));
                this.requestBodySchemaContentsGroup.setInput(nodeInput);
                this.requestHeaderSchemaContentsGroup.setInput(nodeInput);
                break;
            }
            case RESPONSE: {
                SchemaNodeWrapper nodeInput = new SchemaNodeWrapper(this.getSchemaForSelectedOperation(IWsdlConstants.ProcedureType.RESPONSE));
                this.responseBodySchemaContentsGroup.setInput(nodeInput);
                this.responseHeaderSchemaContentsGroup.setInput(nodeInput);
                break;
            }
            case BOTH: {
                SchemaNodeWrapper nodeInput = new SchemaNodeWrapper(this.getSchemaForSelectedOperation(IWsdlConstants.ProcedureType.REQUEST));
                this.requestBodySchemaContentsGroup.setInput(nodeInput);
                this.requestHeaderSchemaContentsGroup.setInput(nodeInput);
                nodeInput = new SchemaNodeWrapper(this.getSchemaForSelectedOperation(IWsdlConstants.ProcedureType.RESPONSE));
                this.responseBodySchemaContentsGroup.setInput(nodeInput);
                this.responseHeaderSchemaContentsGroup.setInput(nodeInput);
            }
        }
    }

    private List<SchemaTreeModel.SchemaNode> getSchemaForSelectedOperation(IWsdlConstants.ProcedureType type) {
        return this.schemaHandler.getSchemaForSelectedOperation(type, this.procedureGenerator);
    }

    public void dispose() {
        this.saveState();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("ModelGeneratorWsdlUi");
            settings = temp == null ? settings.addNewSection("ModelGeneratorWsdlUi") : temp;
        }
        return settings;
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    void setPageStatus() {
        IStatus generatorStatus = this.importManager.getValidator().getProcedureStatus(this.procedureGenerator);
        if (generatorStatus == null) {
            return;
        }
        if (generatorStatus.isOK() || generatorStatus.getSeverity() < 4) {
            this.setErrorMessage(null);
            WizardUtil.setPageComplete((WizardPage)this);
            IStatus operationsStatus = this.importManager.getValidator().getOperationsStatus();
            String finalMessage = this.importManager.getValidator().getPrimaryMessage(operationsStatus);
            if (operationsStatus.getSeverity() > 2) {
                WizardUtil.setPageComplete((WizardPage)this, (String)finalMessage, (int)WizardUtil.getMessageSeverity((int)operationsStatus.getSeverity()));
                this.setErrorMessage(finalMessage);
                this.setPageComplete(false);
            } else if (operationsStatus.getSeverity() == 2) {
                this.setMessage(finalMessage, WizardUtil.getMessageSeverity((int)2));
            }
        } else {
            String finalMessage = this.importManager.getValidator().getPrimaryMessage(generatorStatus);
            WizardUtil.setPageComplete((WizardPage)this, (String)finalMessage, (int)WizardUtil.getMessageSeverity((int)generatorStatus.getSeverity()));
            this.setErrorMessage(finalMessage);
            this.setPageComplete(false);
        }
        this.getContainer().updateButtons();
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (isVisible) {
            WidgetUtil.setComboItems((Combo)this.operationsCombo, this.getOperationsNameList(), null, (boolean)true);
            this.selectComboItem(0);
            this.wrapperPanel.setVisible();
            this.overwriteExistingCB.setEnabled(this.importManager.viewModelExists());
            boolean includeHeader = this.importManager.isMessageServiceMode();
            if (includeHeader) {
                this.requestHeaderStackLayout.topControl = this.requestHeaderSplitter;
                this.responseHeaderStackLayout.topControl = this.responseHeaderSplitter;
            } else {
                this.requestHeaderStackLayout.topControl = this.disabledRequestHeaderPanel;
                this.responseHeaderStackLayout.topControl = this.disabledResponseHeaderPanel;
            }
            this.requestHeaderStackPanel.layout();
            this.responseHeaderStackPanel.layout();
            this.requestHeaderTab.getControl().setEnabled(includeHeader);
            this.responseHeaderTab.getControl().setEnabled(includeHeader);
        }
        this.setPageStatus();
    }

    public void updateDesignerProperties() {
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.setPageStatus();
    }

    Object[] getNodeChildren(Object element) {
        return new Object[0];
    }

    boolean getNodeHasChildren(Object element) {
        return false;
    }

    Image getNodeImage(Object element) {
        return null;
    }

    String getNodeName(Object element) {
        return "<name>";
    }

    Object getNodeParent(Object element) {
        return null;
    }

    public String createRequestColumn(int requestType) {
        if (requestType == 0) {
            return this.requestBodySchemaContentsGroup.createRequestColumn();
        }
        return this.requestHeaderSchemaContentsGroup.createRequestColumn();
    }

    public String createResponseColumn(int responseType) {
        if (responseType == 0) {
            return this.responseBodySchemaContentsGroup.createResponseColumn();
        }
        return this.responseHeaderSchemaContentsGroup.createResponseColumn();
    }

    class OperationsListProvider
    extends LabelProvider
    implements ITreeContentProvider {
        private final Image OPERATION_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/operation_obj.gif");

        OperationsListProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object node) {
            if (node instanceof ArrayList) {
                ArrayList theList = (ArrayList)node;
                return theList.toArray();
            }
            return CoreStringUtil.Constants.EMPTY_STRING_ARRAY;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object node) {
            return null;
        }

        public boolean hasChildren(Object node) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object node) {
            if (node instanceof Operation) {
                return this.OPERATION_ICON_IMG;
            }
            return null;
        }

        public String getText(Object node) {
            if (node instanceof Operation) {
                return ((Operation)node).getName();
            }
            return "unknownElement";
        }
    }
}

