/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.modelgenerator.wsdl.WSSoapConnectionInfoProvider;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureGenerator;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.RequestInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ResponseInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlAttributeInfo;
import org.teiid.designer.transformation.model.RelationalViewModelFactory;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ImportWsdlProcessor {
    public static final RelationalFactory factory = RelationalFactory.eINSTANCE;
    public static final DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();
    public static final int DEFAULT_STRING_LENGTH = 4000;
    WSDLImportWizardManager importManager;
    ModelResource sourceModel;
    ModelResource viewModel;
    IStatus createStatus;
    Shell shell;
    RelationalViewModelFactory relationalFactory;
    FlatFileRelationalModelFactory relationalProcedureFactory;
    private static boolean isTransactionable = ModelerCore.getPlugin() != null;

    public ImportWsdlProcessor(WSDLImportWizardManager importManager, Shell shell) {
        this.importManager = importManager;
        this.shell = shell;
        this.createStatus = Status.OK_STATUS;
        this.relationalFactory = new RelationalViewModelFactory();
        this.relationalProcedureFactory = new FlatFileRelationalModelFactory();
    }

    private void log(IStatus status) {
        ModelGeneratorWsdlUiConstants.UTIL.log(status);
    }

    public IStatus execute() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) {
                theMonitor.beginTask("Creating source model" + ImportWsdlProcessor.this.importManager.getSourceModelName(), 100);
                ImportWsdlProcessor.this.initializeModels(theMonitor);
                ImportWsdlProcessor.this.createSourceProcedures(theMonitor);
                ImportWsdlProcessor.this.createViewProcedures(theMonitor);
                theMonitor.worked(50);
                theMonitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            this.log((IStatus)new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", e.getTargetException().getMessage(), (Throwable)e));
        }
        catch (Exception err) {
            Throwable t = err;
            if (err instanceof InvocationTargetException) {
                t = err.getCause();
            }
            WidgetUtil.showError((Throwable)t);
        }
        return this.createStatus;
    }

    private IStatus initializeModels(IProgressMonitor theMonitor) {
        try {
            IFile modelFile;
            ModelWorkspaceItem item;
            IPath modelPath;
            if (this.importManager.sourceModelExists()) {
                modelPath = this.importManager.getSourceModelLocation().getFullPath().append(this.importManager.getSourceModelName());
                item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1);
                modelFile = (IFile)item.getCorrespondingResource();
                this.sourceModel = ModelUtilities.getModelResourceForIFile((IFile)modelFile, (boolean)false);
                this.addConnectionProfileInfoToSourceModel(theMonitor, true);
            } else {
                this.createSourceModelInTxn(theMonitor);
            }
            if (this.importManager.viewModelExists()) {
                modelPath = this.importManager.getViewModelLocation().getFullPath().append(this.importManager.getViewModelName());
                item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1);
                modelFile = (IFile)item.getCorrespondingResource();
                this.viewModel = ModelUtilities.getModelResourceForIFile((IFile)modelFile, (boolean)false);
            } else {
                this.createViewModelInTxn(theMonitor);
            }
        }
        catch (ModelWorkspaceException ex) {
            return new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            return new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", ex.getMessage());
        }
        return Status.OK_STATUS;
    }

    private IStatus createSourceModelInTxn(IProgressMonitor theMonitor) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Import Teiid Metadata Create Source Model", (Object)this);
        boolean succeeded = false;
        try {
            try {
                this.sourceModel = this.relationalFactory.createRelationalModel(this.importManager.getSourceModelLocation(), this.importManager.getSourceModelName());
                theMonitor.worked(10);
                this.addConnectionProfileInfoToSourceModel(theMonitor, false);
                theMonitor.subTask("Saving Source Model" + this.sourceModel.getItemName());
                try {
                    ModelUtilities.saveModelResource((ModelResource)this.sourceModel, (IProgressMonitor)theMonitor, (boolean)false, (Object)this);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                theMonitor.worked(10);
                if (this.createStatus.isOK() && this.sourceModel != null) {
                    ModelEditorManager.openInEditMode((Object)this.sourceModel, (boolean)true, (int)0);
                }
                succeeded = true;
            }
            catch (Exception e) {
                String message = NLS.bind((String)Messages.Error_Creating_0_Model_1_FromWsdl, (Object)"view", (Object)this.importManager.getSourceModelName());
                Status status = new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", message, (Throwable)e);
                this.log((IStatus)status);
                MessageDialog.openError((Shell)this.shell, (String)message, (String)e.getMessage());
                Status status2 = status;
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return status2;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        theMonitor.worked(10);
        return Status.OK_STATUS;
    }

    protected void addConnectionProfileInfoToSourceModel(IProgressMonitor monitor, boolean doSave) throws InvocationTargetException {
        IConnectionProfile profile = this.importManager.getConnectionProfile();
        if (monitor == null) {
            return;
        }
        if (profile != null) {
            try {
                Properties props = profile.getBaseProperties();
                String defaultServiceMode = this.importManager.getTranslatorDefaultServiceMode();
                if (defaultServiceMode.equalsIgnoreCase("MESSAGE")) {
                    props.put("DefaultServiceMode", "MESSAGE");
                } else {
                    props.put("DefaultServiceMode", "PAYLOAD");
                }
                String defaultBinding = this.importManager.getTranslatorDefaultBinding();
                if (defaultBinding.equalsIgnoreCase("SOAP12")) {
                    props.put("DefaultBinding", "SOAP12");
                } else {
                    String theProp = props.getProperty("DefaultBinding");
                    if (theProp != null) {
                        props.remove("DefaultBinding");
                    }
                }
                profile.setBaseProperties(props);
                WSSoapConnectionInfoProvider provider = new WSSoapConnectionInfoProvider();
                provider.setConnectionInfo(this.sourceModel, profile);
            }
            catch (ModelerCoreException ex) {
                this.log((IStatus)new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", ex.getMessage(), (Throwable)ex));
            }
            if (doSave) {
                try {
                    ModelUtilities.saveModelResource((ModelResource)this.sourceModel, (IProgressMonitor)monitor, (boolean)false, (Object)this);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }

    private void createSourceProcedures(IProgressMonitor monitor) {
        try {
            this.relationalProcedureFactory.addMissingProcedure(this.sourceModel, "invoke");
        }
        catch (ModelerCoreException ex) {
            this.log((IStatus)new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", ex.getMessage(), (Throwable)ex));
        }
    }

    private IStatus createViewModelInTxn(IProgressMonitor monitor) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Create WSDL Import View Model", (Object)this);
        boolean succeeded = false;
        try {
            try {
                monitor.subTask("Creating View Procedures" + this.importManager.getViewModelName());
                this.viewModel = this.relationalFactory.createRelationalViewModel(this.importManager.getViewModelLocation(), this.importManager.getViewModelName());
                monitor.worked(40);
                if (this.createStatus.isOK() && this.sourceModel != null) {
                    try {
                        ModelUtilities.saveModelResource((ModelResource)this.viewModel, (IProgressMonitor)monitor, (boolean)false, (Object)this);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                monitor.worked(10);
                if (this.createStatus.isOK() && this.viewModel != null) {
                    ModelEditorManager.openInEditMode((Object)this.viewModel, (boolean)true, (int)0);
                }
                succeeded = true;
            }
            catch (Exception e) {
                String message = NLS.bind((String)Messages.Error_Creating_0_Model_1_FromWsdl, (Object)"view", (Object)this.importManager.getViewModelName());
                Status status = new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", message, (Throwable)e);
                this.log((IStatus)status);
                MessageDialog.openError((Shell)this.shell, (String)message, (String)e.getMessage());
                Status status2 = status;
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return status2;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private void createViewProcedures(IProgressMonitor monitor) {
        this.removeOverriddenProcedures();
        for (Operation operation : this.importManager.getSelectedOperations()) {
            ProcedureGenerator generator = this.importManager.getProcedureGenerator(operation);
            this.processGenerator(generator);
        }
    }

    private void removeOverriddenProcedures() {
        for (Operation operation : this.importManager.getSelectedOperations()) {
            EObject response;
            EObject request;
            EObject wrapper;
            ProcedureGenerator generator = this.importManager.getProcedureGenerator(operation);
            if (!generator.doOverwriteExistingProcedures()) continue;
            ArrayList<EObject> deleteList = new ArrayList<EObject>();
            if (generator.wrapperExists() && (wrapper = ModelUtilities.getExistingEObject((String)this.importManager.getViewModelLocation().getFullPath().toString(), (String)this.importManager.getViewModelName(), (String)generator.getWrapperProcedureName())) != null) {
                deleteList.add(wrapper);
            }
            if ((request = ModelUtilities.getExistingEObject((String)this.importManager.getViewModelLocation().getFullPath().toString(), (String)this.importManager.getViewModelName(), (String)generator.getRequestProcedureName())) != null) {
                deleteList.add(request);
            }
            if ((response = ModelUtilities.getExistingEObject((String)this.importManager.getViewModelLocation().getFullPath().toString(), (String)this.importManager.getViewModelName(), (String)generator.getResponseProcedureName())) != null) {
                deleteList.add(response);
            }
            if (deleteList.isEmpty()) continue;
            try {
                ModelerCore.getModelEditor().delete(deleteList);
            }
            catch (ModelerCoreException ex) {
                ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)ex);
            }
        }
    }

    private void processGenerator(ProcedureGenerator generator) {
        try {
            this.createViewRequestProcedure(this.viewModel, generator.getRequestInfo());
            this.createViewResponseProcedure(this.viewModel, generator.getResponseInfo());
            this.createViewWrapperProcedure(this.viewModel, generator);
        }
        catch (ModelWorkspaceException ex) {
            ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)ex);
        }
        catch (ModelerCoreException ex) {
            ModelGeneratorWsdlUiConstants.UTIL.log((Throwable)ex);
        }
    }

    public void createViewRequestProcedure(ModelResource modelResource, RequestInfo info) throws ModelerCoreException {
        EObject type;
        ProcedureParameter parameter;
        ColumnInfo columnInfo;
        EObject STRING_DATATYPE = datatypeManager.findDatatype("string");
        Procedure procedure = factory.createProcedure();
        procedure.setName(info.getProcedureName());
        this.addValue(modelResource, procedure, modelResource.getEmfResource().getContents());
        NewModelObjectHelperManager.helpCreate((Object)procedure, null);
        ColumnInfo[] columnInfoArray = info.getHeaderColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            columnInfo = columnInfoArray[n2];
            parameter = factory.createProcedureParameter();
            parameter.setName(columnInfo.getName());
            type = datatypeManager.findDatatype(columnInfo.getDatatype());
            if (type != null) {
                parameter.setType(type);
            }
            if (columnInfo.getDatatype().equalsIgnoreCase("string")) {
                parameter.setLength(4000);
            }
            parameter.setProcedure(procedure);
            ++n2;
        }
        columnInfoArray = info.getBodyColumnInfoList();
        n = columnInfoArray.length;
        n2 = 0;
        while (n2 < n) {
            columnInfo = columnInfoArray[n2];
            parameter = factory.createProcedureParameter();
            parameter.setName(columnInfo.getName());
            type = datatypeManager.findDatatype(columnInfo.getDatatype());
            if (type != null) {
                parameter.setType(type);
            }
            if (columnInfo.getDatatype().equalsIgnoreCase("string")) {
                parameter.setLength(4000);
            }
            parameter.setProcedure(procedure);
            IWsdlAttributeInfo[] iWsdlAttributeInfoArray = columnInfo.getAttributeInfoArray();
            int n3 = iWsdlAttributeInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWsdlAttributeInfo attrInfo = iWsdlAttributeInfoArray[n4];
                ProcedureParameter attributeParam = factory.createProcedureParameter();
                attributeParam.setName(attrInfo.getName());
                attributeParam.setType(STRING_DATATYPE);
                attributeParam.setLength(4000);
                attributeParam.setProcedure(procedure);
                ++n4;
            }
            ++n2;
        }
        ProcedureResult result = factory.createProcedureResult();
        result.setName("Result");
        result.setProcedure(procedure);
        Column column_1 = factory.createColumn();
        column_1.setName("xml_out");
        EObject blobType = datatypeManager.findDatatype("XMLLiteral");
        if (blobType != null) {
            column_1.setType(blobType);
        }
        this.addValue(result, column_1, result.getColumns());
        String sqlString = info.getSqlString(new Properties());
        SqlTransformationMappingRoot tRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)procedure);
        TransformationHelper.setSelectSqlString((Object)tRoot, (String)sqlString, (boolean)false, (Object)this);
        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)tRoot, (Object)this);
        TransformationValidator validator = new TransformationValidator(tRoot);
        validator.validateSql(sqlString, 0, true);
    }

    public void createViewResponseProcedure(ModelResource modelResource, ResponseInfo info) throws ModelerCoreException {
        Procedure procedure = factory.createProcedure();
        procedure.setName(info.getProcedureName());
        this.addValue(modelResource, procedure, modelResource.getEmfResource().getContents());
        ProcedureParameter parameter = factory.createProcedureParameter();
        parameter.setName("xml_in");
        EObject stringType = datatypeManager.findDatatype("XMLLiteral");
        parameter.setType(stringType);
        parameter.setProcedure(procedure);
        ProcedureResult result = factory.createProcedureResult();
        result.setName("Result");
        result.setProcedure(procedure);
        ColumnInfo[] columnInfoArray = info.getBodyColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo columnInfo = columnInfoArray[n2];
            Column column = factory.createColumn();
            column.setName(columnInfo.getName());
            EObject type = datatypeManager.findDatatype(columnInfo.getDatatype());
            if (type != null) {
                column.setType(type);
                if (columnInfo.getDatatype().equalsIgnoreCase("string")) {
                    column.setLength(4000);
                }
            }
            this.addValue(result, column, result.getColumns());
            ++n2;
        }
        NewModelObjectHelperManager.helpCreate((Object)procedure, null);
        String sqlString = info.getSqlString(new Properties());
        SqlTransformationMappingRoot tRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)procedure);
        TransformationHelper.setSelectSqlString((Object)tRoot, (String)sqlString, (boolean)false, (Object)this);
        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)tRoot, (Object)this);
        TransformationValidator validator = new TransformationValidator(tRoot);
        validator.validateSql(sqlString, 0, true);
    }

    private void createViewWrapperProcedure(ModelResource modelResource, ProcedureGenerator generator) throws ModelerCoreException {
        EObject type;
        ProcedureParameter parameter;
        ColumnInfo columnInfo;
        EObject STRING_DATATYPE = datatypeManager.findDatatype("string");
        Procedure procedure = factory.createProcedure();
        procedure.setName(generator.getWrapperProcedureName());
        this.addValue(modelResource, procedure, modelResource.getEmfResource().getContents());
        ColumnInfo[] columnInfoArray = generator.getRequestInfo().getHeaderColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            columnInfo = columnInfoArray[n2];
            parameter = factory.createProcedureParameter();
            parameter.setName(columnInfo.getName());
            type = datatypeManager.findDatatype(columnInfo.getDatatype());
            if (type != null) {
                parameter.setType(type);
                if (columnInfo.getDatatype().equalsIgnoreCase("string")) {
                    parameter.setLength(4000);
                }
            }
            parameter.setProcedure(procedure);
            ++n2;
        }
        columnInfoArray = generator.getRequestInfo().getBodyColumnInfoList();
        n = columnInfoArray.length;
        n2 = 0;
        while (n2 < n) {
            columnInfo = columnInfoArray[n2];
            parameter = factory.createProcedureParameter();
            parameter.setName(columnInfo.getName());
            type = datatypeManager.findDatatype(columnInfo.getDatatype());
            if (type != null) {
                parameter.setType(type);
                if (columnInfo.getDatatype().equalsIgnoreCase("string")) {
                    parameter.setLength(4000);
                }
            }
            parameter.setProcedure(procedure);
            IWsdlAttributeInfo[] iWsdlAttributeInfoArray = columnInfo.getAttributeInfoArray();
            int n3 = iWsdlAttributeInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWsdlAttributeInfo attrInfo = iWsdlAttributeInfoArray[n4];
                ProcedureParameter attributeParam = factory.createProcedureParameter();
                attributeParam.setName(attrInfo.getName());
                attributeParam.setType(STRING_DATATYPE);
                attributeParam.setLength(4000);
                attributeParam.setProcedure(procedure);
                ++n4;
            }
            ++n2;
        }
        ProcedureResult result = factory.createProcedureResult();
        result.setName("Result");
        result.setProcedure(procedure);
        ColumnInfo[] columnInfoArray2 = generator.getResponseInfo().getBodyColumnInfoList();
        int n5 = columnInfoArray2.length;
        n = 0;
        while (n < n5) {
            ColumnInfo columnInfo2 = columnInfoArray2[n];
            Column column = factory.createColumn();
            column.setName(columnInfo2.getName());
            EObject type2 = datatypeManager.findDatatype(columnInfo2.getDatatype());
            if (type2 != null) {
                column.setType(type2);
                if (columnInfo2.getDatatype().equalsIgnoreCase("string")) {
                    column.setLength(4000);
                }
            }
            this.addValue(result, column, result.getColumns());
            ++n;
        }
        NewModelObjectHelperManager.helpCreate((Object)procedure, null);
        String sqlString = generator.getWrapperProcedureSqlString(new Properties());
        SqlTransformationMappingRoot tRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)procedure);
        TransformationHelper.setSelectSqlString((Object)tRoot, (String)sqlString, (boolean)false, (Object)this);
        SqlMappingRootCache.setStatus((EObject)tRoot, (int)0, null);
        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)tRoot, (Object)this);
        TransformationValidator validator = new TransformationValidator(tRoot);
        validator.validateSql(sqlString, 0, true);
    }

    protected void addValue(Object owner, Object value, EList feature) throws ModelerCoreException {
        if (isTransactionable) {
            ModelerCore.getModelEditor().addValue(owner, value, feature);
        } else {
            feature.add(value);
        }
    }
}

