/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.modelgenerator.wsdl.WSDLReader;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.ModelGenerationException;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportManagerValidator;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureGenerator;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class WSDLImportWizardManager
implements IChangeNotifier {
    public static final int WORKSPACE_SOURCE = 0;
    public static final int FILESYSTEM_SOURCE = 1;
    public static final int URL_SOURCE = 2;
    public static final String PAYLOAD = "PAYLOAD";
    public static final String MESSAGE = "MESSAGE";
    public static final String[] SERVICE_MODES = new String[]{"PAYLOAD", "MESSAGE"};
    private WSDLReader wsdlReader = new WSDLReader();
    private String sourceModelName;
    private boolean sourceModelExists;
    private IContainer sourceModelLocation;
    private String viewModelName;
    private boolean viewModelExists;
    private IContainer viewModelLocation;
    private boolean generateDefaultProcedures;
    private List<Operation> selectedOperations = new ArrayList<Operation>();
    private int uriSource = 2;
    private IConnectionProfile connectionProfile;
    private Map<Operation, ProcedureGenerator> procedureGenerators = new HashMap<Operation, ProcedureGenerator>();
    private Model wsdlModel;
    private String translatorDefaultBinding = "SOAP11";
    private String translatorDefaultServiceMode = "PAYLOAD";
    private Properties designerProperties;
    private ImportManagerValidator validator;
    private Collection<IChangeListener> listeners = new ArrayList<IChangeListener>(5);
    private boolean changed;

    public WSDLImportWizardManager() {
        this.validator = new ImportManagerValidator(this);
        this.setChanged(true);
    }

    public void setWSDLCredentials(String securityTypeValue, String userName, String password) {
        if (securityTypeValue == null) {
            return;
        }
        ICredentialsCommon.SecurityType securityType = ICredentialsCommon.SecurityType.valueOf((String)securityTypeValue);
        this.wsdlReader.setAuthenticationCredentials(securityType, userName, password);
        this.wsdlModel = null;
        this.setChanged(true);
    }

    public void setWSDLFileUri(String fileUri) {
        if (this.wsdlReader.getWSDLUri() == null) {
            this.wsdlReader.setWSDLUri(fileUri);
        } else if (!this.wsdlReader.getWSDLUri().equals(fileUri)) {
            this.wsdlReader.setWSDLUri(fileUri);
            this.wsdlModel = null;
        }
        this.setChanged(true);
    }

    public String getWSDLFileUri() {
        return this.wsdlReader.getWSDLUri();
    }

    public MultiStatus validateWSDL(IProgressMonitor monitor) {
        return this.wsdlReader.validateWSDL(monitor);
    }

    public Model getWSDLModel() throws ModelGenerationException {
        if (this.wsdlModel == null) {
            this.wsdlModel = this.wsdlReader.getModel();
        }
        return this.wsdlModel;
    }

    public IContainer getViewModelLocation() {
        return this.viewModelLocation;
    }

    public void setViewModelLocation(IContainer viewModelLocation) {
        this.viewModelLocation = viewModelLocation;
        this.setChanged(true);
    }

    public String getViewModelName() {
        return this.viewModelName;
    }

    public void setViewModelName(String targetModelName) {
        this.viewModelName = targetModelName;
        this.setChanged(true);
    }

    public void setSelectedOperations(List<Operation> operations) {
        this.selectedOperations = operations;
        this.synchronizeProcedureGenerators();
        this.setChanged(true);
    }

    public List<Operation> getSelectedOperations() {
        return this.selectedOperations;
    }

    public int getUriSource() {
        return this.uriSource;
    }

    public void setUriSource(int uriSource) {
        this.uriSource = uriSource;
        this.setChanged(true);
    }

    public IConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public void setConnectionProfile(IConnectionProfile connectionProfile) {
        this.connectionProfile = connectionProfile;
        if (this.connectionProfile != null) {
            String binding;
            Properties props = this.connectionProfile.getBaseProperties();
            String securityTypeValue = props.getProperty("SecurityType");
            String userName = props.getProperty("AuthUserName");
            String password = props.getProperty("AuthPassword");
            this.setWSDLCredentials(securityTypeValue, userName, password);
            String fileUri = props.getProperty("wsdlURI");
            if (fileUri != null) {
                this.setWSDLFileUri(fileUri);
            }
            if ((binding = props.getProperty("DefaultBinding")) != null) {
                this.setTranslatorDefaultBinding(binding);
            } else {
                this.setTranslatorDefaultBinding("SOAP11");
            }
        }
        this.setChanged(true);
    }

    public ProcedureGenerator getProcedureGenerator(Operation operation) {
        return this.procedureGenerators.get(operation);
    }

    public Collection<ProcedureGenerator> getProcedureGenerators() {
        return this.procedureGenerators.values();
    }

    private void synchronizeProcedureGenerators() {
        for (Operation operation : this.getSelectedOperations()) {
            if (this.procedureGenerators.containsKey(operation)) continue;
            this.procedureGenerators.put(operation, new ProcedureGenerator(operation, this));
        }
        ArrayList<Operation> staleOperations = new ArrayList<Operation>();
        for (ProcedureGenerator generator : this.procedureGenerators.values()) {
            if (this.selectedOperations.contains(generator.getOperation())) continue;
            staleOperations.add(generator.getOperation());
        }
        for (Operation operation : staleOperations) {
            this.procedureGenerators.remove(operation);
        }
        if (!this.generateDefaultProcedures && !this.getSelectedOperations().isEmpty()) {
            Operation firstOperation = this.getSelectedOperations().get(0);
            String serviceName = firstOperation.getBinding().getPort().getService().getName();
            this.setSourceModelName(String.valueOf(serviceName) + ".xmi");
            this.setViewModelName(String.valueOf(serviceName) + "View.xmi");
            if (this.viewModelLocation != null) {
                ModelWorkspaceManager manager = ModelWorkspaceManager.getModelWorkspaceManager();
                this.sourceModelExists = manager.modelExists(this.sourceModelLocation.getFullPath().toOSString(), this.sourceModelName);
                this.viewModelExists = manager.modelExists(this.viewModelLocation.getFullPath().toOSString(), this.viewModelName);
            }
        } else {
            this.sourceModelName = null;
            this.sourceModelExists = false;
            this.viewModelName = null;
            this.viewModelExists = false;
        }
    }

    public String getSourceModelName() {
        return this.sourceModelName;
    }

    public void setSourceModelName(String sourceModelName) {
        this.sourceModelName = sourceModelName;
        this.setChanged(true);
    }

    public IContainer getSourceModelLocation() {
        return this.sourceModelLocation;
    }

    public void setSourceModelLocation(IContainer location) {
        this.sourceModelLocation = location;
        this.setChanged(true);
    }

    public void setViewModelExists(boolean viewModelExists) {
        this.viewModelExists = viewModelExists;
        if (this.viewModelExists) {
            for (ProcedureGenerator generator : this.procedureGenerators.values()) {
                if (generator.doOverwriteExistingProcedures()) continue;
                String validRequestName = ModelUtilities.getUniqueName((String)this.getViewModelLocation().getFullPath().toString(), (String)this.getViewModelName(), (String)generator.getRequestInfo().getDefaultProcedureName(), (boolean)false, (boolean)false);
                generator.getRequestInfo().setProcedureName(validRequestName);
                String validResponseName = ModelUtilities.getUniqueName((String)this.getViewModelLocation().getFullPath().toString(), (String)this.getViewModelName(), (String)generator.getResponseInfo().getDefaultProcedureName(), (boolean)false, (boolean)false);
                generator.getResponseInfo().setProcedureName(validResponseName);
                String validWrapperName = ModelUtilities.getUniqueName((String)this.getViewModelLocation().getFullPath().toString(), (String)this.getViewModelName(), (String)generator.getDefaultWrapperProcedureName(), (boolean)false, (boolean)false);
                generator.setWrapperProcedureName(validWrapperName);
            }
        } else {
            for (ProcedureGenerator generator : this.procedureGenerators.values()) {
                generator.getRequestInfo().setProcedureName(generator.getRequestInfo().getDefaultProcedureName());
                generator.getResponseInfo().setProcedureName(generator.getResponseInfo().getDefaultProcedureName());
                String validWrapperName = generator.getWrapperProcedureName();
                if (!validWrapperName.startsWith(generator.getDefaultWrapperProcedureName())) continue;
                generator.setWrapperProcedureName(generator.getWrapperProcedureName());
            }
        }
        this.setChanged(true);
    }

    public boolean viewModelExists() {
        return this.viewModelExists;
    }

    public void setSourceModelExists(boolean sourceModelExists) {
        this.sourceModelExists = sourceModelExists;
        this.setChanged(true);
    }

    public boolean sourceModelExists() {
        return this.sourceModelExists;
    }

    public boolean doGenerateDefaultProcedures() {
        return this.generateDefaultProcedures;
    }

    public void setGenerateDefaultProcedures(boolean generateDefaultProcedures) {
        this.generateDefaultProcedures = generateDefaultProcedures;
        this.setChanged(true);
    }

    public String getTranslatorDefaultBinding() {
        return this.translatorDefaultBinding;
    }

    public void setTranslatorDefaultBinding(String translatorDefaultBinding) {
        this.translatorDefaultBinding = translatorDefaultBinding;
        this.setChanged(true);
    }

    public String getTranslatorDefaultServiceMode() {
        return this.translatorDefaultServiceMode;
    }

    public boolean isMessageServiceMode() {
        return this.translatorDefaultServiceMode.equalsIgnoreCase(MESSAGE);
    }

    public void setTranslatorDefaultServiceMode(String translatorDefaultServiceMode) {
        this.translatorDefaultServiceMode = translatorDefaultServiceMode;
        this.setChanged(true);
    }

    public void setDesignerProperties(Properties props) {
        this.designerProperties = props;
    }

    public Properties getDesignerProperties() {
        return this.designerProperties;
    }

    public void setDesignerProperty(String key, String value) {
        if (this.designerProperties != null) {
            this.designerProperties.put(key, value);
        }
    }

    public void validate() {
        if (this.isChanged()) {
            this.validator.validate();
        }
        this.setChanged(false);
    }

    public void setChanged(boolean value) {
        this.changed = value;
    }

    private boolean isChanged() {
        if (this.changed) {
            return true;
        }
        for (ProcedureGenerator generator : this.procedureGenerators.values()) {
            if (!generator.isChanged()) continue;
            return true;
        }
        return false;
    }

    public ImportManagerValidator getValidator() {
        return this.validator;
    }

    public void notifyChanged() {
        this.validate();
        for (IChangeListener listener : this.listeners) {
            listener.stateChanged((IChangeNotifier)this);
        }
    }

    public void addChangeListener(IChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.listeners.remove(listener);
    }
}

