/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.textimport.ColumnRowObject;
import org.teiid.designer.relational.ui.textimport.IndexRowObject;
import org.teiid.designer.relational.ui.textimport.RelationalRowFactory;
import org.teiid.designer.tools.textimport.ui.wizards.AbstractObjectProcessor;
import org.teiid.designer.tools.textimport.ui.wizards.AbstractRowObject;
import org.teiid.designer.tools.textimport.ui.wizards.IRowObject;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RelationalObjectProcessor
extends AbstractObjectProcessor {
    private static final String XMI_EXTENSION = "xmi";
    private static final String I18N_PREFIX = "RelationalObjectProcessor";
    private static final String SEPARATOR = ".";
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory factory = RelationalFactory.eINSTANCE;
    public static final int UNKNOWN = -1;
    public static final int SCHEMA = 3;
    public static final int CATALOG = 2;
    public static final int BASE_TABLE = 10;
    public static final int VIEW = 11;
    public static final int INDEX = 12;
    public static final int COLUMN = 13;
    private List otherModifiedResources = new ArrayList();
    private IProgressMonitor monitor;

    public Collection createRowObjsFromStrings(Collection rowStrings) {
        Iterator iter = rowStrings.iterator();
        String nextStr = null;
        RelationalRowFactory factory = new RelationalRowFactory();
        ArrayList<IRowObject> stringRows = new ArrayList<IRowObject>();
        IRowObject nextRow = null;
        while (iter.hasNext()) {
            nextStr = (String)iter.next();
            nextRow = factory.createRowObject(nextStr);
            if (nextRow != null && nextRow.isValid()) {
                stringRows.add(nextRow);
                continue;
            }
            this.logParsingError(nextStr);
        }
        return stringRows;
    }

    public void generateObjsFromRowObjs(ModelResource targetResource, Object location, Collection rowObjects, boolean useStringDefaultDatatype, EObject defaultDatatype, int defaultLength) {
        int iRow = 0;
        Iterator iter = rowObjects.iterator();
        AbstractRowObject nextRow = null;
        EObject newObject = null;
        Object finalLocation = null;
        HashMap<String, EObject> columnMap = new HashMap<String, EObject>();
        EObject lastEContainer = null;
        String sSize = Integer.toString(rowObjects.size());
        while (iter.hasNext()) {
            ++iRow;
            nextRow = (AbstractRowObject)iter.next();
            finalLocation = location;
            if (this.monitor != null) {
                this.monitor.worked(1);
                this.monitor.subTask(UiConstants.Util.getString("RelationalObjectProcessor.incrementalProgress", new Object[]{Integer.toString(iRow), sSize, nextRow.getName()}));
            }
            if (nextRow.getLocation() != null) {
                String rowLocation = nextRow.getLocation();
                finalLocation = this.getOrCreateLocation(rowLocation, factory);
                if (finalLocation != null) {
                    ModelResource actualModelResource = targetResource;
                    if (finalLocation instanceof ModelResource) {
                        actualModelResource = (ModelResource)finalLocation;
                    } else {
                        int modelSegIndex = this.getModelPathIndex(rowLocation);
                        Path locPath = new Path(rowLocation);
                        actualModelResource = this.getModelResource(locPath.uptoSegment(modelSegIndex).toOSString());
                    }
                    if (!targetResource.equals(actualModelResource) && !this.otherModifiedResources.contains(actualModelResource)) {
                        this.otherModifiedResources.add(actualModelResource);
                    }
                } else {
                    finalLocation = location;
                }
            }
            switch (nextRow.getObjectType()) {
                case 3: {
                    newObject = this.createEObject(factory, finalLocation, (IRowObject)nextRow, null, false, null, 0);
                    break;
                }
                case 2: {
                    newObject = this.createEObject(factory, finalLocation, (IRowObject)nextRow, null, false, null, 0);
                    break;
                }
                case 10: 
                case 11: {
                    newObject = this.createEObject(factory, finalLocation, (IRowObject)nextRow, null, useStringDefaultDatatype, defaultDatatype, defaultLength);
                    columnMap.clear();
                    lastEContainer = newObject;
                    break;
                }
                case 12: {
                    lastEContainer = newObject = this.createEObject(factory, finalLocation, (IRowObject)nextRow, columnMap, useStringDefaultDatatype, defaultDatatype, defaultLength);
                    break;
                }
                case 13: {
                    newObject = this.createEObject(factory, lastEContainer, (IRowObject)nextRow, null, useStringDefaultDatatype, defaultDatatype, defaultLength);
                    columnMap.put(nextRow.getName(), newObject);
                    break;
                }
            }
            if (this.monitor.isCanceled()) break;
        }
    }

    private EObject createEObject(RelationalFactory factory, Object location, IRowObject someRow, HashMap columnMap, boolean useStringDefaultDatatype, EObject defaultDatatype, int defaultLength) {
        Catalog newEObject = null;
        ModelResource modelResrc = null;
        if (location instanceof ModelResource) {
            modelResrc = (ModelResource)location;
        } else if (location instanceof EObject) {
            modelResrc = ModelerCore.getModelEditor().findModelResource((EObject)location);
        }
        switch (someRow.getObjectType()) {
            case 2: {
                Catalog catalog = (Catalog)RelationalObjectProcessor.createCatalog(someRow.getName());
                if (catalog == null) break;
                newEObject = catalog;
                if (location instanceof ModelResource) {
                    this.addValue(location, catalog, this.getModelResourceContents((ModelResource)location));
                }
                if (modelResrc == null) break;
                this.createAnnotation(modelResrc, (EObject)catalog, someRow.getDescription());
                break;
            }
            case 3: {
                Schema schema;
                Catalog cat = null;
                if (location instanceof Catalog) {
                    cat = (Catalog)location;
                }
                if ((schema = (Schema)RelationalObjectProcessor.createSchema(someRow.getName(), cat)) == null) break;
                newEObject = schema;
                if (location instanceof ModelResource) {
                    this.addValue(location, schema, this.getModelResourceContents((ModelResource)location));
                } else if (location instanceof Catalog) {
                    this.addValue(location, schema, ((Catalog)location).getSchemas());
                }
                if (modelResrc == null) break;
                this.createAnnotation(modelResrc, (EObject)schema, someRow.getDescription());
                break;
            }
            case 10: {
                BaseTable bt = (BaseTable)RelationalObjectProcessor.createBaseTable(someRow.getName(), false);
                if (bt == null) break;
                newEObject = bt;
                if (location instanceof ModelResource) {
                    this.addValue(location, bt, this.getModelResourceContents((ModelResource)location));
                } else if (location instanceof Schema) {
                    this.addValue(location, bt, ((Schema)location).getTables());
                } else if (location instanceof Catalog) {
                    this.addValue(location, bt, ((Catalog)location).getTables());
                }
                if (modelResrc == null) break;
                this.createAnnotation(modelResrc, (EObject)bt, someRow.getDescription());
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                IndexRowObject row = (IndexRowObject)someRow;
                Index index = factory.createIndex();
                if (index == null) break;
                newEObject = index;
                index.setName(row.getName());
                index.setUnique(row.isUnique());
                if (columnMap != null && !columnMap.isEmpty()) {
                    for (String nextName : row.getColumnNames()) {
                        EObject eObj = (EObject)columnMap.get(nextName);
                        if (eObj == null) continue;
                        this.addValue(index, eObj, index.getColumns());
                    }
                }
                if (location instanceof ModelResource) {
                    this.addValue(location, index, this.getModelResourceContents((ModelResource)location));
                } else if (location instanceof Schema) {
                    index.setSchema((Schema)location);
                    this.addValue(location, index, ((Schema)location).getIndexes());
                } else if (location instanceof Catalog) {
                    index.setCatalog((Catalog)location);
                    this.addValue(location, index, ((Catalog)location).getIndexes());
                }
                if (modelResrc == null) break;
                this.createAnnotation(modelResrc, (EObject)index, row.getDescription());
                break;
            }
            case 13: {
                ColumnRowObject row = (ColumnRowObject)someRow;
                Column col = factory.createColumn();
                if (col == null) break;
                newEObject = col;
                col.setName(row.getName());
                if (row.getDatatype() != null) {
                    col.setType(row.getDatatype());
                } else if (useStringDefaultDatatype && defaultDatatype != null) {
                    col.setType(defaultDatatype);
                }
                if (row.getLength() > 0) {
                    col.setLength(row.getLength());
                } else if (useStringDefaultDatatype) {
                    col.setLength(defaultLength);
                }
                if (location instanceof BaseTable) {
                    this.addValue(location, col, ((BaseTable)location).getColumns());
                } else if (location instanceof View) {
                    this.addValue(location, col, ((View)location).getColumns());
                }
                if (modelResrc == null) break;
                this.createAnnotation(modelResrc, (EObject)col, row.getDescription());
                break;
            }
        }
        return newEObject;
    }

    public static EObject createBaseTable(String name, boolean supportsUpdate) {
        BaseTable bt = factory.createBaseTable();
        bt.setName(name);
        bt.setSupportsUpdate(supportsUpdate);
        return bt;
    }

    public static EObject createProcedure(String name) {
        Procedure proc = factory.createProcedure();
        proc.setName(name);
        return proc;
    }

    public static EObject createSchema(String name, Catalog catalog) {
        Schema newSchema = factory.createSchema();
        newSchema.setName(name);
        if (catalog != null) {
            newSchema.setCatalog(catalog);
        }
        return newSchema;
    }

    private EObject createSchema(Object parent, String folderName, RelationalFactory factory) {
        Schema newSchema = factory.createSchema();
        newSchema.setName(folderName);
        if (parent instanceof Catalog) {
            this.addValue(parent, newSchema, ((Catalog)parent).getSchemas());
        } else if (parent instanceof ModelResource) {
            this.addValue(parent, newSchema, this.getModelResourceContents((ModelResource)parent));
        }
        return newSchema;
    }

    public static EObject createCatalog(String name) {
        Catalog newCatalog = factory.createCatalog();
        newCatalog.setName(name);
        return newCatalog;
    }

    private void createAnnotation(ModelResource targetResource, EObject eObject, String description) {
        if (description != null && description.length() > 0) {
            ModelContents contents = ModelerCore.getModelEditor().getModelContents(targetResource);
            Annotation newAnnot = ModelResourceContainerFactory.createNewAnnotation((EObject)eObject, (AnnotationContainer)contents.getAnnotationContainer(true));
            newAnnot.setDescription(description);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public static boolean isSchema(Object obj) {
        return obj instanceof Schema;
    }

    public static boolean isCatalog(Object obj) {
        return obj instanceof Catalog;
    }

    public static EList getTablesEList(Object obj) {
        if (RelationalObjectProcessor.isSchema(obj)) {
            return ((Schema)obj).getTables();
        }
        if (RelationalObjectProcessor.isCatalog(obj)) {
            ((Catalog)obj).getTables();
        }
        return null;
    }

    public List getOtherModifiedResources() {
        return this.otherModifiedResources;
    }

    private ModelResource createRelationalModel(IResource targetRes, String sNewRelationshipModelName) {
        ModelResource mr = this.constructRelationalModel(targetRes, sNewRelationshipModelName);
        try {
            if (mr != null) {
                mr.save(null, false);
            }
        }
        catch (ModelWorkspaceException mwe) {
            UiConstants.Util.log((Throwable)mwe);
        }
        return mr;
    }

    public ModelResource constructRelationalModel(IResource targetRes, String sModelName) {
        IPath relativeModelPath = targetRes.getProjectRelativePath().append(sModelName).addFileExtension(XMI_EXTENSION);
        IFile modelFile = targetRes.getProject().getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create((IFile)modelFile);
        try {
            resrc.getModelAnnotation().setPrimaryMetamodelUri(RELATIONAL_PACKAGE_URI);
            resrc.getModelAnnotation().setModelType(ModelType.PHYSICAL_LITERAL);
            ModelUtilities.initializeModelContainers((ModelResource)resrc, (String)"Create Model Containers", (Object)((Object)this));
        }
        catch (ModelWorkspaceException mwe) {
            mwe.printStackTrace();
        }
        return resrc;
    }

    private int getModelPathIndex(String pathStr) {
        int modelIndex = -1;
        ModelResource mr = null;
        Path path = new Path(pathStr);
        int nSegs = path.segmentCount();
        if (nSegs > 1) {
            String projSeg = path.segment(0);
            IProject existProj = ModelerCore.getWorkspace().getRoot().getProject(projSeg);
            if (!existProj.exists()) {
                existProj = this.createProject(existProj, (IProgressMonitor)new NullProgressMonitor());
            }
            if (existProj.exists()) {
                if (!existProj.isOpen()) {
                    try {
                        existProj.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
                int i = nSegs;
                while (i > 1) {
                    IPath workingPath = path.uptoSegment(i);
                    String osPathStr = workingPath.toOSString();
                    if (osPathStr != null && osPathStr.length() > 0) {
                        mr = this.getModelResource(osPathStr);
                    }
                    if (mr != null) {
                        modelIndex = i;
                        break;
                    }
                    --i;
                }
            }
        }
        return modelIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getOrCreateLocation(String location, RelationalFactory factory) {
        ModelResource mr = null;
        Path locPath = new Path(location);
        int nSegs = locPath.segmentCount();
        int modelSegIndex = this.getModelPathIndex(location);
        if (modelSegIndex != -1) {
            mr = this.getModelResource(locPath.uptoSegment(modelSegIndex).toOSString());
            if (nSegs <= modelSegIndex) return mr;
            int nFolders = nSegs - modelSegIndex;
            EObject folderEObject = null;
            ModelResource parent = mr;
            int i = 0;
            while (i < nFolders) {
                String sFolderPath = locPath.uptoSegment(modelSegIndex + 1 + i).toOSString();
                folderEObject = this.getEObject(sFolderPath);
                if (folderEObject == null) {
                    folderEObject = this.createSchema(parent, locPath.segment(modelSegIndex + i), factory);
                    if (i == nFolders - 1) {
                        return folderEObject;
                    }
                    parent = folderEObject;
                } else {
                    parent = folderEObject;
                    if (i == nFolders - 1) {
                        return folderEObject;
                    }
                }
                ++i;
            }
        } else {
            String projSeg = locPath.segment(0);
            IProject existProj = ModelerCore.getWorkspace().getRoot().getProject(projSeg);
            if (!existProj.exists()) {
                existProj = this.createProject(existProj, (IProgressMonitor)new NullProgressMonitor());
            }
            if (existProj.exists()) {
                IPath modelPath;
                if (!existProj.isOpen()) {
                    try {
                        existProj.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
                mr = !existProj.exists(modelPath = new Path(locPath.segment(1)).addFileExtension(XMI_EXTENSION)) ? this.createRelationalModel((IResource)existProj, locPath.segment(1)) : this.getModelResource(locPath.uptoSegment(2).toOSString());
                if (nSegs == 2) {
                    return mr;
                }
                int nFolders = nSegs - 2;
                EObject folderEObject = null;
                ModelResource parent = mr;
                int i = 0;
                while (i < nFolders) {
                    String sFolderPath = locPath.uptoSegment(3 + i).toOSString();
                    folderEObject = this.getEObject(sFolderPath);
                    if (folderEObject == null) {
                        folderEObject = this.createSchema(parent, locPath.segment(2 + i), factory);
                        if (i == nFolders - 1) {
                            return folderEObject;
                        }
                        parent = folderEObject;
                    } else {
                        parent = folderEObject;
                        if (i == nFolders - 1) {
                            return folderEObject;
                        }
                    }
                    ++i;
                }
            }
        }
        UiConstants.Util.log(4, "Problems creating non existing folder or model for new relationship.  Path = " + location);
        return null;
    }
}

