/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.edit.RelationalEditorPanel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;

public class EditRelationalObjectDialog
extends TitleAreaDialog
implements IDialogStatusListener {
    private final EditRelationalObjectDialogModel dialogModel;
    private RelationalEditorPanel editorPanel;

    public EditRelationalObjectDialog(Shell parentShell, EditRelationalObjectDialogModel dialogModel) {
        super(parentShell);
        this.dialogModel = dialogModel;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        Shell shell = this.getShell();
        shell.setText(this.dialogModel.getDialogTitle());
        Shell parentShell = (Shell)shell.getParent();
        Rectangle parentBounds = parentShell.getBounds();
        Point parentCenter = new Point(parentBounds.x + parentBounds.width / 2, parentBounds.y + parentBounds.height / 2);
        Rectangle r = shell.getBounds();
        Point shellLocation = new Point(parentCenter.x - r.width / 2, parentCenter.y - r.height / 2);
        shell.setLocation(Math.max(0, shellLocation.x), Math.max(0, shellLocation.y));
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite mainPanel = new Composite(pnlOuter, 0);
        GridLayoutFactory.fillDefaults().margins(20, 20).applyTo(mainPanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainPanel);
        this.setTitle(this.dialogModel.getDialogTitle());
        this.setMessage(this.dialogModel.getHelpText());
        this.editorPanel = this.dialogModel.getEditorPanel(this, mainPanel);
        return mainPanel;
    }

    public void notifyStatusChanged(IStatus status) {
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.setMessage(Messages.validationOkCreateObject);
        } else if (status.getSeverity() == 2) {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), 2);
        } else {
            this.setErrorMessage(status.getMessage());
        }
        this.setOkEnabled(this.editorPanel.canFinish());
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setOkEnabled(this.editorPanel.canFinish());
        return control;
    }

    private void setOkEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }
}

