/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.edit.RelationalDialogModel;
import org.teiid.designer.relational.ui.edit.RelationalEditorPanel;
import org.teiid.designer.relational.ui.util.RelationalUiUtil;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.properties.extension.VdbFileDialogUtil;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;

public class RelationalProcedureEditorPanel
extends RelationalEditorPanel
implements RelationalConstants {
    private TabItem generalPropertiesTab;
    private TabItem parametersTab;
    private TabItem resultSetTab;
    private TabItem nativeQueryTab;
    private Button nonPreparedCB;
    private Button deterministicCB;
    private Button returnsNullCB;
    private Button variableArgsCB;
    private Button aggregateCB;
    private Button allowsDistinctCB;
    private Button allowsOrderByCB;
    private Button analyticCB;
    private Button decomposableCB;
    private Button useDistinctRowsCB;
    private Button includeResultSetCB;
    private Text resultSetNameText;
    private Text nativeQueryHelpText;
    private Button addParameterButton;
    private Button deleteParameterButton;
    private Button upParameterButton;
    private Button downParameterButton;
    private Button addColumnButton;
    private Button deleteColumnButton;
    private Button upColumnButton;
    private Button downColumnButton;
    private Combo updateCountCombo;
    private TableViewerBuilder parametersViewer;
    private TableViewerBuilder columnsViewer;
    private StyledTextEditor nativeQueryTextEditor;
    private Text javaClassText;
    private Text javaMethodText;
    private Text functionCategoryText;
    private Text udfJarPathText;
    private Button udfJarPathBrowse;
    boolean validationPerformed = false;

    public RelationalProcedureEditorPanel(Composite parent, RelationalDialogModel dialogModel, IDialogStatusListener statusListener) {
        super(parent, dialogModel, statusListener);
        this.synchronizeUI();
    }

    protected RelationalProcedure getRelationalReference() {
        return (RelationalProcedure)super.getRelationalReference();
    }

    @Override
    protected void createPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().applyTo(thePanel);
        GridDataFactory.fillDefaults().applyTo((Control)thePanel);
        this.createNameGroup(thePanel);
        TabFolder tabFolder = this.createTabFolder(parent);
        this.createGeneralPropertiesTab(tabFolder);
        this.createParametersTab(tabFolder);
        if (!this.getRelationalReference().isSourceFunction() && !this.getRelationalReference().isFunction()) {
            this.createResultSetTab(tabFolder);
        }
        this.createDescriptionTab(tabFolder);
        if (!this.getRelationalReference().isFunction()) {
            this.createNativeQueryTab(tabFolder);
        }
    }

    private void createGeneralPropertiesTab(TabFolder folderParent) {
        Composite thePanel = this.createPropertiesPanel((Composite)folderParent);
        this.generalPropertiesTab = new TabItem(folderParent, 0);
        this.generalPropertiesTab.setControl((Control)thePanel);
        this.generalPropertiesTab.setText(UILabelUtil.getLabel((int)6));
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage(5, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createParametersTab(TabFolder folderParent) {
        Composite thePanel = this.createParameterTableGroup((Composite)folderParent);
        this.parametersTab = new TabItem(folderParent, 0);
        this.parametersTab.setControl((Control)thePanel);
        this.parametersTab.setText(Messages.parametersLabel);
        this.parametersTab.setImage(RelationalUiUtil.getRelationalImage(6, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createResultSetTab(TabFolder folderParent) {
        Composite thePanel = this.createResultSetPanel((Composite)folderParent);
        this.resultSetTab = new TabItem(folderParent, 0);
        this.resultSetTab.setControl((Control)thePanel);
        this.resultSetTab.setText(Messages.resultSetLabel);
    }

    private void createNativeQueryTab(TabFolder folderParent) {
        Composite thePanel = this.createNativeQueryPanel((Composite)folderParent);
        this.nativeQueryTab = new TabItem(folderParent, 0);
        this.nativeQueryTab.setControl((Control)thePanel);
        this.nativeQueryTab.setText(Messages.nativeQueryLabel);
        this.nativeQueryTab.setImage(RelationalUiUtil.getNativeSQLImage(Status.OK_STATUS));
    }

    @Override
    protected void synchronizeExtendedUI() {
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage(3, this.getRelationalReference().getModelType(), Status.OK_STATUS));
        this.parametersViewer.getTable().removeAll();
        IStatus maxStatus = Status.OK_STATUS;
        for (RelationalParameter row : this.getRelationalReference().getParameters()) {
            if (row.getStatus().getSeverity() > maxStatus.getSeverity()) {
                maxStatus = row.getStatus();
            }
            this.parametersViewer.add((Object)row);
        }
        this.parametersTab.setImage(RelationalUiUtil.getRelationalImage(6, this.getRelationalReference().getModelType(), maxStatus));
        if (!this.getRelationalReference().isSourceFunction() && !this.getRelationalReference().isFunction()) {
            if (this.getRelationalReference().getResultSet() == null) {
                if (WidgetUtil.widgetValueChanged((Button)this.includeResultSetCB, (boolean)false)) {
                    this.includeResultSetCB.setSelection(false);
                    this.addColumnButton.setEnabled(false);
                }
                this.resultSetNameText.setEnabled(false);
                if (WidgetUtil.widgetValueChanged((Text)this.resultSetNameText, (String)"")) {
                    this.resultSetNameText.setText("");
                }
                this.columnsViewer.getTable().removeAll();
                this.columnsViewer.getTable().setEnabled(false);
                this.resultSetTab.setImage(UiPlugin.getDefault().getImage("icons/full/obj16/relational-table.png"));
            } else {
                this.columnsViewer.getTable().setEnabled(true);
                if (WidgetUtil.widgetValueChanged((Button)this.includeResultSetCB, (boolean)true)) {
                    this.includeResultSetCB.setSelection(true);
                }
                this.resultSetNameText.setEnabled(true);
                if (this.getRelationalReference().getResultSet().getName() != null && WidgetUtil.widgetValueChanged((Text)this.resultSetNameText, (String)this.getRelationalReference().getResultSet().getName())) {
                    this.resultSetNameText.setText(this.getRelationalReference().getResultSet().getName());
                }
                this.columnsViewer.getTable().removeAll();
                if (!this.getRelationalReference().getResultSet().getColumns().isEmpty()) {
                    for (RelationalColumn column : this.getRelationalReference().getResultSet().getColumns()) {
                        this.columnsViewer.add((Object)column);
                    }
                }
                this.resultSetTab.setImage(RelationalUiUtil.getRelationalImage(3, this.getRelationalReference().getResultSet().getModelType(), this.getRelationalReference().getResultSet().getStatus()));
            }
            if (this.getRelationalReference().isFunction() && this.getRelationalReference().getUdfJarPath() != null) {
                this.udfJarPathText.setText(this.getRelationalReference().getUdfJarPath());
            }
        }
    }

    private Composite createResultSetPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        this.includeResultSetCB = new Button(thePanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.includeResultSetCB);
        this.includeResultSetCB.setText(UILabelUtil.getLabel((int)9));
        this.includeResultSetCB.setToolTipText(Messages.includeResultSetTooltip);
        this.includeResultSetCB.setSelection(this.getRelationalReference().getResultSet() != null);
        this.includeResultSetCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RelationalProcedureEditorPanel.this.includeResultSetCB.getSelection()) {
                    if (RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet() == null) {
                        RelationalProcedureResultSet resultSet = new RelationalProcedureResultSet();
                        if (RelationalProcedureEditorPanel.this.resultSetNameText.getText() != null) {
                            resultSet.setName(RelationalProcedureEditorPanel.this.resultSetNameText.getText());
                        }
                        RelationalProcedureEditorPanel.this.getRelationalReference().setResultSet(resultSet);
                    }
                } else {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setResultSet(null);
                }
                RelationalProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        Composite namePanel = WidgetFactory.createPanel((Composite)thePanel, (int)0, (int)2, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(namePanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)namePanel);
        Label label = new Label(namePanel, 131072);
        label.setText(UILabelUtil.getLabel((int)14));
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.resultSetNameText = new Text(namePanel, 2052);
        this.resultSetNameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).minSize(50, -1).applyTo((Control)this.resultSetNameText);
        this.resultSetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = RelationalProcedureEditorPanel.this.resultSetNameText.getText();
                if (value == null) {
                    value = "";
                }
                if (RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet() != null) {
                    RelationalProcedureResultSet resultSet = RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet();
                    resultSet.setName(value);
                }
                RelationalProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        Composite buttonPanel = WidgetFactory.createPanel((Composite)thePanel, (int)0, (int)1, (int)4);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buttonPanel);
        this.addColumnButton = new Button(buttonPanel, 8);
        this.addColumnButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addColumnButton);
        this.addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().createColumn();
                RelationalProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        this.addColumnButton.setEnabled(false);
        this.deleteColumnButton = new Button(buttonPanel, 8);
        this.deleteColumnButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteColumnButton);
        this.deleteColumnButton.setEnabled(false);
        this.deleteColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn column = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalProcedureEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        column = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (column != null) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().removeColumn(column);
                    RelationalProcedureEditorPanel.this.deleteColumnButton.setEnabled(false);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.upColumnButton = new Button(buttonPanel, 8);
        this.upColumnButton.setText(UILabelUtil.getLabel((int)4));
        GridDataFactory.fillDefaults().applyTo((Control)this.upColumnButton);
        this.upColumnButton.setEnabled(false);
        this.upColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn info = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalProcedureEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        info = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = RelationalProcedureEditorPanel.this.columnsViewer.getTable().getSelectionIndex();
                    RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().moveColumnUp(info);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                    RelationalProcedureEditorPanel.this.columnsViewer.getTable().select(selectedIndex - 1);
                    RelationalProcedureEditorPanel.this.downColumnButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnDown(info));
                    RelationalProcedureEditorPanel.this.upColumnButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnUp(info));
                }
            }
        });
        this.downColumnButton = new Button(buttonPanel, 8);
        this.downColumnButton.setText(UILabelUtil.getLabel((int)5));
        GridDataFactory.fillDefaults().applyTo((Control)this.downColumnButton);
        this.downColumnButton.setEnabled(false);
        this.downColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn info = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalProcedureEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        info = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = RelationalProcedureEditorPanel.this.columnsViewer.getTable().getSelectionIndex();
                    RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().moveColumnDown(info);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                    RelationalProcedureEditorPanel.this.columnsViewer.getTable().select(selectedIndex + 1);
                    RelationalProcedureEditorPanel.this.downColumnButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnDown(info));
                    RelationalProcedureEditorPanel.this.upColumnButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnUp(info));
                }
            }
        });
        this.columnsViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).applyTo((Control)this.columnsViewer.getTableComposite());
        TableViewerColumn column = this.columnsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.columnNameLabel) + "          ");
        column.setEditingSupport((EditingSupport)new ColumnNameEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        column = this.columnsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.dataTypeLabel) + "          ");
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new DatatypeEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column = this.columnsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(Messages.lengthLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ColumnWidthEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        if (this.getRelationalReference().getResultSet() != null) {
            for (RelationalColumn row : this.getRelationalReference().getResultSet().getColumns()) {
                this.columnsViewer.add((Object)row);
            }
        }
        this.columnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    RelationalProcedureEditorPanel.this.deleteColumnButton.setEnabled(false);
                    RelationalProcedureEditorPanel.this.upColumnButton.setEnabled(false);
                    RelationalProcedureEditorPanel.this.downColumnButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    RelationalColumn columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof RelationalColumn)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (RelationalColumn)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    RelationalProcedureEditorPanel.this.deleteColumnButton.setEnabled(enable && !RelationalProcedureEditorPanel.this.getRelationalReference().isNativeQueryProcedure());
                    if (enable) {
                        RelationalProcedureEditorPanel.this.upColumnButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnUp(columnInfo));
                        RelationalProcedureEditorPanel.this.downColumnButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnDown(columnInfo));
                    }
                }
            }
        });
        return thePanel;
    }

    private Composite createPropertiesPanel(Composite parent) {
        boolean isFunction;
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().applyTo((Control)thePanel);
        Label label = null;
        boolean bl = isFunction = this.getRelationalReference().isFunction() || this.getRelationalReference().isSourceFunction();
        if (!isFunction) {
            label = new Label(thePanel, 0);
            label.setText(Messages.updateCountLabel);
            this.updateCountCombo = new Combo(thePanel, 12);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.updateCountCombo);
            String[] stringArray = RelationalConstants.UPDATE_COUNT.AS_ARRAY;
            int n = RelationalConstants.UPDATE_COUNT.AS_ARRAY.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                this.updateCountCombo.add(val);
                ++n2;
            }
            this.updateCountCombo.setText("AUTO");
            this.nonPreparedCB = new Button(thePanel, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.nonPreparedCB);
            this.nonPreparedCB.setText(Messages.nonPreparedLabel);
            this.nonPreparedCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setNonPrepared(RelationalProcedureEditorPanel.this.nonPreparedCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
        }
        if (this.getRelationalReference().isFunction() || this.getRelationalReference().isSourceFunction()) {
            Group functionGroup = WidgetFactory.createGroup((Composite)thePanel, (String)Messages.functionPropertiesLabel, (int)768, (int)2, (int)3);
            if (!this.getRelationalReference().isSourceFunction()) {
                label = new Label((Composite)functionGroup, 0);
                label.setText(Messages.functionCategoryLabel);
                this.functionCategoryText = new Text((Composite)functionGroup, 2052);
                this.functionCategoryText.setForeground(Display.getCurrent().getSystemColor(10));
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.functionCategoryText);
                this.functionCategoryText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        String value = RelationalProcedureEditorPanel.this.functionCategoryText.getText();
                        if (value == null) {
                            value = "";
                        }
                        RelationalProcedureEditorPanel.this.getRelationalReference().setFunctionCategory(value);
                        RelationalProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                label = new Label((Composite)functionGroup, 0);
                label.setText(Messages.javaClassLabel);
                this.javaClassText = new Text((Composite)functionGroup, 2052);
                this.javaClassText.setForeground(Display.getCurrent().getSystemColor(10));
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.javaClassText);
                this.javaClassText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        String value = RelationalProcedureEditorPanel.this.javaClassText.getText();
                        if (value == null) {
                            value = "";
                        }
                        RelationalProcedureEditorPanel.this.getRelationalReference().setJavaClassName(value);
                        RelationalProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                label = new Label((Composite)functionGroup, 0);
                label.setText(Messages.javaMethodLabel);
                this.javaMethodText = new Text((Composite)functionGroup, 2052);
                this.javaMethodText.setForeground(Display.getCurrent().getSystemColor(10));
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.javaMethodText);
                this.javaMethodText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        String value = RelationalProcedureEditorPanel.this.javaMethodText.getText();
                        if (value == null) {
                            value = "";
                        }
                        RelationalProcedureEditorPanel.this.getRelationalReference().setJavaMethodName(value);
                        RelationalProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                label = new Label((Composite)functionGroup, 0);
                label.setText(Messages.udfJarPathLabel);
                this.udfJarPathText = new Text((Composite)functionGroup, 2052);
                this.udfJarPathText.setForeground(Display.getCurrent().getSystemColor(10));
                GridDataFactory.fillDefaults().applyTo((Control)this.udfJarPathText);
                this.udfJarPathText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        String value = RelationalProcedureEditorPanel.this.udfJarPathText.getText();
                        if (value == null) {
                            value = "";
                        }
                        RelationalProcedureEditorPanel.this.getRelationalReference().setUdfJarPath(value);
                        if (!RelationalProcedureEditorPanel.this.isSynchronizing()) {
                            RelationalProcedureEditorPanel.this.handleInfoChanged();
                        }
                    }
                });
                this.udfJarPathBrowse = new Button((Composite)functionGroup, 131080);
                this.udfJarPathBrowse.setText(UILabelUtil.getLabel((int)0));
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.udfJarPathBrowse);
                this.udfJarPathBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String selectedFile = VdbFileDialogUtil.selectFile((Shell)RelationalProcedureEditorPanel.this.udfJarPathBrowse.getShell(), (IProject)RelationalProcedureEditorPanel.this.getModelFile().getProject(), (VdbHelper.VdbFolders)VdbHelper.VdbFolders.UDF);
                        RelationalProcedureEditorPanel.this.getRelationalReference().setUdfJarPath(selectedFile);
                        RelationalProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
            }
            Composite innerPanel = WidgetFactory.createPanel((Composite)functionGroup, (int)0, (int)768, (int)3);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(innerPanel);
            GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)innerPanel);
            this.deterministicCB = new Button(innerPanel, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.deterministicCB);
            this.deterministicCB.setText(Messages.deterministicLabel);
            this.deterministicCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setDeterministic(RelationalProcedureEditorPanel.this.deterministicCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            this.returnsNullCB = new Button(innerPanel, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.returnsNullCB);
            this.returnsNullCB.setText(Messages.returnsNullOnNullLabel);
            this.returnsNullCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setReturnsNullOnNull(RelationalProcedureEditorPanel.this.returnsNullCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            this.variableArgsCB = new Button(innerPanel, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.variableArgsCB);
            this.variableArgsCB.setText(Messages.variableArgumentsLabel);
            this.variableArgsCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setVariableArguments(RelationalProcedureEditorPanel.this.variableArgsCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            Group aggregateGroup = WidgetFactory.createGroup((Composite)functionGroup, (String)Messages.aggregatePropertiesLabel, (int)768, (int)2, (int)3);
            this.aggregateCB = new Button((Composite)aggregateGroup, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.aggregateCB);
            this.aggregateCB.setText(Messages.aggregateLabel);
            this.aggregateCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setAggregate(RelationalProcedureEditorPanel.this.aggregateCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            this.allowsDistinctCB = new Button((Composite)aggregateGroup, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.allowsDistinctCB);
            this.allowsDistinctCB.setText(Messages.allowsDistinctLabel);
            this.allowsDistinctCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setAllowsDistinct(RelationalProcedureEditorPanel.this.allowsDistinctCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            this.allowsOrderByCB = new Button((Composite)aggregateGroup, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.allowsOrderByCB);
            this.allowsOrderByCB.setText(Messages.allowsOrderByLabel);
            this.allowsOrderByCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setAllowsOrderBy(RelationalProcedureEditorPanel.this.allowsOrderByCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            this.analyticCB = new Button((Composite)aggregateGroup, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.analyticCB);
            this.analyticCB.setText(Messages.analyticLabel);
            this.analyticCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setAnalytic(RelationalProcedureEditorPanel.this.analyticCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            this.decomposableCB = new Button((Composite)aggregateGroup, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.decomposableCB);
            this.decomposableCB.setText(Messages.decomposableLabel);
            this.decomposableCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setDecomposable(RelationalProcedureEditorPanel.this.decomposableCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            this.useDistinctRowsCB = new Button((Composite)aggregateGroup, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.useDistinctRowsCB);
            this.useDistinctRowsCB.setText(Messages.usesDistinctRowsLabel);
            this.useDistinctRowsCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().setUseDistinctRows(RelationalProcedureEditorPanel.this.useDistinctRowsCB.getSelection());
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            });
        }
        this.setUiState();
        return thePanel;
    }

    private Composite createParameterTableGroup(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Composite buttonPanel = WidgetFactory.createPanel((Composite)thePanel, (int)0, (int)1, (int)4);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addParameterButton = new Button(buttonPanel, 8);
        this.addParameterButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addParameterButton);
        this.addParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalProcedureEditorPanel.this.getRelationalReference().createParameter();
                RelationalProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        this.deleteParameterButton = new Button(buttonPanel, 8);
        this.deleteParameterButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteParameterButton);
        this.deleteParameterButton.setEnabled(false);
        this.deleteParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalParameter parameter = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalProcedureEditorPanel.this.parametersViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalParameter) {
                        parameter = (RelationalParameter)obj;
                        break;
                    }
                    ++n2;
                }
                if (parameter != null) {
                    RelationalProcedureEditorPanel.this.getRelationalReference().removeParameter(parameter);
                    RelationalProcedureEditorPanel.this.deleteParameterButton.setEnabled(false);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.upParameterButton = new Button(buttonPanel, 8);
        this.upParameterButton.setText(UILabelUtil.getLabel((int)4));
        GridDataFactory.fillDefaults().applyTo((Control)this.upParameterButton);
        this.upParameterButton.setEnabled(false);
        this.upParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalParameter info = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalProcedureEditorPanel.this.parametersViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalParameter) {
                        info = (RelationalParameter)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = RelationalProcedureEditorPanel.this.parametersViewer.getTable().getSelectionIndex();
                    RelationalProcedureEditorPanel.this.getRelationalReference().moveParameterUp(info);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                    RelationalProcedureEditorPanel.this.parametersViewer.getTable().select(selectedIndex - 1);
                    RelationalProcedureEditorPanel.this.downParameterButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().canMoveParameterDown(info));
                    RelationalProcedureEditorPanel.this.upParameterButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().canMoveParameterUp(info));
                }
            }
        });
        this.downParameterButton = new Button(buttonPanel, 8);
        this.downParameterButton.setText(UILabelUtil.getLabel((int)5));
        GridDataFactory.fillDefaults().applyTo((Control)this.downParameterButton);
        this.downParameterButton.setEnabled(false);
        this.downParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalParameter info = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalProcedureEditorPanel.this.parametersViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalParameter) {
                        info = (RelationalParameter)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = RelationalProcedureEditorPanel.this.parametersViewer.getTable().getSelectionIndex();
                    RelationalProcedureEditorPanel.this.getRelationalReference().moveParameterDown(info);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                    RelationalProcedureEditorPanel.this.parametersViewer.getTable().select(selectedIndex + 1);
                    RelationalProcedureEditorPanel.this.downParameterButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().canMoveParameterDown(info));
                    RelationalProcedureEditorPanel.this.upParameterButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().canMoveParameterUp(info));
                }
            }
        });
        this.parametersViewer = new TableViewerBuilder(thePanel, 68356);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 150).applyTo((Control)this.parametersViewer.getTableComposite());
        TableViewerColumn column = this.parametersViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.parameterNameLabel) + "        ");
        column.setEditingSupport((EditingSupport)new ParameterNameEditingSupport((ColumnViewer)this.parametersViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new ParameterDataLabelProvider(0));
        column = this.parametersViewer.createColumn(16384, 20, 30, true);
        column.getColumn().setText(String.valueOf(Messages.dataTypeLabel) + "          ");
        column.setLabelProvider((CellLabelProvider)new ParameterDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new DatatypeEditingSupport((ColumnViewer)this.parametersViewer.getTableViewer()));
        column = this.parametersViewer.createColumn(16384, 20, 30, true);
        column.getColumn().setText(Messages.lengthLabel);
        column.setLabelProvider((CellLabelProvider)new ParameterDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ParameterWidthEditingSupport((ColumnViewer)this.parametersViewer.getTableViewer()));
        column = this.parametersViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(Messages.directionLabel);
        column.setLabelProvider((CellLabelProvider)new ParameterDataLabelProvider(3));
        column.setEditingSupport((EditingSupport)new DirectionEditingSupport((ColumnViewer)this.parametersViewer.getTableViewer()));
        if (this.getRelationalReference() != null) {
            for (RelationalParameter row : this.getRelationalReference().getParameters()) {
                this.parametersViewer.add((Object)row);
            }
        }
        this.parametersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    RelationalProcedureEditorPanel.this.deleteParameterButton.setEnabled(false);
                    RelationalProcedureEditorPanel.this.upParameterButton.setEnabled(false);
                    RelationalProcedureEditorPanel.this.downParameterButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    RelationalParameter columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof RelationalParameter)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (RelationalParameter)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    RelationalProcedureEditorPanel.this.deleteParameterButton.setEnabled(enable);
                    if (enable) {
                        RelationalProcedureEditorPanel.this.upParameterButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().canMoveParameterUp(columnInfo));
                        RelationalProcedureEditorPanel.this.downParameterButton.setEnabled(RelationalProcedureEditorPanel.this.getRelationalReference().canMoveParameterDown(columnInfo));
                    }
                }
            }
        });
        return thePanel;
    }

    private Composite createNativeQueryPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)thePanel);
        this.nativeQueryHelpText = new Text(thePanel, 72);
        this.nativeQueryHelpText.setBackground(parent.getBackground());
        this.nativeQueryHelpText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().align(4, 1).hint(250, 40).applyTo((Control)this.nativeQueryHelpText);
        this.nativeQueryHelpText.setText(Messages.nativeQueryHelpText);
        Group descGroup = WidgetFactory.createGroup((Composite)thePanel, (String)Messages.sqlLabel, (int)1808, (int)3);
        this.nativeQueryTextEditor = new StyledTextEditor((Composite)descGroup, 2882);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).minSize(-1, 30).applyTo((Control)this.nativeQueryTextEditor.getTextWidget());
        this.nativeQueryTextEditor.setText("");
        this.nativeQueryTextEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RelationalProcedureEditorPanel.this.getRelationalReference().setNativeQuery(RelationalProcedureEditorPanel.this.nativeQueryTextEditor.getText());
                RelationalProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        return thePanel;
    }

    private void setUiState() {
        if (this.getRelationalReference().isFunction()) {
            boolean functionState = true;
            if (this.deterministicCB != null) {
                this.deterministicCB.setEnabled(functionState);
            }
            if (this.returnsNullCB != null) {
                this.returnsNullCB.setEnabled(functionState);
            }
            if (this.variableArgsCB != null) {
                this.variableArgsCB.setEnabled(functionState);
            }
            if (this.aggregateCB != null) {
                this.aggregateCB.setEnabled(functionState);
                boolean aggregateState = functionState;
                if (aggregateState) {
                    aggregateState = this.aggregateCB.getSelection();
                }
                if (this.allowsDistinctCB != null) {
                    this.allowsDistinctCB.setEnabled(aggregateState);
                }
                if (this.allowsOrderByCB != null) {
                    this.allowsOrderByCB.setEnabled(aggregateState);
                }
                if (this.analyticCB != null) {
                    this.analyticCB.setEnabled(aggregateState);
                }
                if (this.decomposableCB != null) {
                    this.decomposableCB.setEnabled(aggregateState);
                }
                if (this.useDistinctRowsCB != null) {
                    this.useDistinctRowsCB.setEnabled(aggregateState);
                }
            }
        } else if (this.addColumnButton != null && this.includeResultSetCB != null) {
            if (this.getRelationalReference().isNativeQueryProcedure()) {
                this.addColumnButton.setEnabled(false);
                this.deleteColumnButton.setEnabled(false);
                this.upColumnButton.setEnabled(false);
                this.downColumnButton.setEnabled(false);
                this.includeResultSetCB.setEnabled(false);
            } else {
                boolean enable = this.includeResultSetCB.getSelection();
                this.addColumnButton.setEnabled(enable);
                if (!enable) {
                    this.deleteColumnButton.setEnabled(false);
                    this.downColumnButton.setEnabled(false);
                    this.upColumnButton.setEnabled(false);
                }
            }
        }
    }

    @Override
    protected void handleInfoChanged() {
        super.handleInfoChanged();
        this.setUiState();
    }

    @Override
    protected void validate() {
        this.getRelationalReference().validate();
        this.setCanFinish(this.getRelationalReference().nameIsValid());
        IStatus currentStatus = this.getRelationalReference().getStatus();
        if (currentStatus.isOK()) {
            this.setStatus(Status.OK_STATUS);
        } else {
            if (currentStatus.getSeverity() == 4) {
                this.setCanFinish(false);
            }
            this.setStatus(currentStatus);
        }
        this.validationPerformed = true;
    }

    @Override
    public boolean canFinish() {
        if (!this.validationPerformed && this.getRelationalReference().getName() != null) {
            return true;
        }
        return super.canFinish();
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalColumn) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalColumn)element).getName();
                    }
                    case 1: {
                        return ((RelationalColumn)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((RelationalColumn)element).getLength());
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }

    class ColumnNameEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalColumn) {
                return ((RelationalColumn)element).getName();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalColumn) {
                String oldValue = ((RelationalColumn)element).getName();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((RelationalColumn)element).setName(newValue);
                    RelationalProcedureEditorPanel.this.columnsViewer.refresh(element);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class ColumnWidthEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnWidthEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalColumn) {
                return Integer.toString(((RelationalColumn)element).getLength());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalColumn) {
                int oldValue;
                int newValue = oldValue = ((RelationalColumn)element).getLength();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((RelationalColumn)element).setLength(newValue);
                    RelationalProcedureEditorPanel.this.columnsViewer.refresh(element);
                }
            }
        }
    }

    class DatatypeEditingSupport
    extends ComboBoxEditingSupport {
        private String[] datatypes;
        private String[] nativeQueryProcedureColumnDTypes;

        public DatatypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.nativeQueryProcedureColumnDTypes = new String[]{"object"};
            if (RelationalProcedureEditorPanel.this.getRelationalReference().isNativeQueryProcedure()) {
                this.datatypes = this.nativeQueryProcedureColumnDTypes;
            } else {
                Collection unsortedTypes = new ArrayList();
                try {
                    unsortedTypes = DatatypeUtilities.getAllDesignTimeTypeNames();
                }
                catch (ModelerCoreException e) {
                    UiPlugin.Util.log((Throwable)e);
                }
                ArrayList<Object> dTypes = new ArrayList<Object>();
                Object[] sortedStrings = unsortedTypes.toArray(new String[unsortedTypes.size()]);
                Arrays.sort(sortedStrings);
                Object[] objectArray = sortedStrings;
                int n = sortedStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    Object dType = objectArray[n2];
                    dTypes.add(dType);
                    ++n2;
                }
                this.datatypes = dTypes.toArray(new String[dTypes.size()]);
            }
        }

        protected String getElementValue(Object element) {
            if (element instanceof RelationalParameter) {
                return ((RelationalParameter)element).getDatatype();
            }
            if (element instanceof RelationalColumn) {
                return ((RelationalColumn)element).getDatatype();
            }
            return "";
        }

        protected String[] refreshItems(Object element) {
            return this.datatypes;
        }

        protected void setElementValue(Object element, String newValue) {
            if (element instanceof RelationalParameter) {
                ((RelationalParameter)element).setDatatype(newValue);
            } else if (element instanceof RelationalColumn) {
                ((RelationalColumn)element).setDatatype(newValue);
            }
            RelationalProcedureEditorPanel.this.handleInfoChanged();
        }
    }

    class DirectionEditingSupport
    extends ComboBoxEditingSupport {
        public DirectionEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected String getElementValue(Object element) {
            return ((RelationalParameter)element).getDirection();
        }

        protected String[] refreshItems(Object element) {
            if (RelationalProcedureEditorPanel.this.getRelationalReference().isSourceFunction()) {
                return RelationalConstants.DIRECTION.AS_ARRAY_SOURCE_FUNCTION_OPTIONS;
            }
            return RelationalConstants.DIRECTION.AS_ARRAY;
        }

        protected void setElementValue(Object element, String newValue) {
            ((RelationalParameter)element).setDirection(newValue);
            RelationalProcedureEditorPanel.this.handleInfoChanged();
        }
    }

    class ParameterDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ParameterDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalParameter) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalParameter)element).getName();
                    }
                    case 1: {
                        return ((RelationalParameter)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((RelationalParameter)element).getLength());
                    }
                    case 3: {
                        return ((RelationalParameter)element).getDirection();
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/parameter.png");
            }
            return null;
        }
    }

    class ParameterNameEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ParameterNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalParameter) {
                return ((RelationalParameter)element).getName();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalParameter) {
                String oldValue = ((RelationalParameter)element).getName();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((RelationalParameter)element).setName(newValue);
                    RelationalProcedureEditorPanel.this.parametersViewer.refresh(element);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class ParameterWidthEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ParameterWidthEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalParameter) {
                return Integer.toString(((RelationalParameter)element).getLength());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalParameter) {
                int oldValue;
                int newValue = oldValue = ((RelationalParameter)element).getLength();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((RelationalParameter)element).setLength(newValue);
                    RelationalProcedureEditorPanel.this.parametersViewer.refresh(element);
                    RelationalProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        }
    }
}

