/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalModelFactory;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.edit.RelationalDialogModel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialog;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.actions.INewChildAction;
import org.teiid.designer.ui.actions.INewSiblingAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CreateRelationalProcedureAction
extends Action
implements INewChildAction,
INewSiblingAction {
    private IFile selectedModel;
    private Collection<String> datatypes;
    protected int currentProcedureType = RelationalProcedure.PROCEDURE_TYPE.FUNCTION.ordinal();

    public CreateRelationalProcedureAction() {
        super(Messages.createRelationalProcedureActionText);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-relational-procedure.png"));
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        Set unsortedDatatypes = service.getAllDataTypeNames();
        this.datatypes = new ArrayList<String>();
        Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
        Arrays.sort(sortedStrings);
        Object[] objectArray = sortedStrings;
        int n = sortedStrings.length;
        int n2 = 0;
        while (n2 < n) {
            Object dType = objectArray[n2];
            this.datatypes.add((String)dType);
            ++n2;
        }
    }

    public boolean canCreateChild(EObject parent) {
        return false;
    }

    public boolean canCreateChild(IFile modelFile) {
        return this.isApplicable((ISelection)new StructuredSelection((Object)modelFile));
    }

    public boolean canCreateSibling(EObject parent) {
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)parent);
        if (mr != null) {
            IFile modelFile = null;
            try {
                modelFile = (IFile)mr.getCorrespondingResource();
            }
            catch (ModelWorkspaceException ex) {
                UiConstants.Util.log((Throwable)ex);
            }
            if (modelFile != null) {
                return this.isApplicable((ISelection)new StructuredSelection((Object)modelFile));
            }
        }
        return false;
    }

    public boolean isApplicable(ISelection selection) {
        IResource iRes;
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IResource && ModelIdentifier.isRelationalSourceModel((IResource)(iRes = (IResource)obj))) {
            this.selectedModel = (IFile)obj;
            result = true;
        }
        return result;
    }

    public void run() {
        if (this.selectedModel != null) {
            ModelResource mr = ModelUtilities.getModelResource((Object)this.selectedModel);
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            RelationalProcedure procedure = new RelationalProcedure();
            SelectProcedureTypeDialog procedureTypeDialog = new SelectProcedureTypeDialog(shell, procedure);
            procedureTypeDialog.open();
            if (procedureTypeDialog.getReturnCode() == 0) {
                if (procedure.isNativeQueryProcedure()) {
                    RelationalProcedureResultSet resultSet = new RelationalProcedureResultSet("ResultSet");
                    RelationalColumn column = new RelationalColumn("output");
                    column.setDatatype("object");
                    resultSet.addColumn(column);
                    procedure.setResultSet(resultSet);
                }
                RelationalDialogModel dialogModel = new RelationalDialogModel((RelationalReference)procedure, this.selectedModel);
                EditRelationalObjectDialog dialog = new EditRelationalObjectDialog(shell, dialogModel);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    this.createProcedureInTxn(mr, procedure);
                }
            }
        }
    }

    private void createProcedureInTxn(ModelResource modelResource, RelationalProcedure procedure) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)Messages.createRelationalProcedureTitle, (Object)((Object)this));
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    RelationalModelFactory factory = new RelationalModelFactory();
                    RelationalModel relModel = new RelationalModel("dummy");
                    relModel.addChild((RelationalReference)procedure);
                    factory.build(modelResource, relModel, (IProgressMonitor)new NullProgressMonitor());
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalProcedureExceptionMessage, (String)e.getMessage());
                Status status = new Status(4, "org.teiid.designer.relational.ui", Messages.createRelationalProcedureExceptionMessage, (Throwable)e);
                UiConstants.Util.log((IStatus)status);
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    class SelectProcedureTypeDialog
    extends TitleAreaDialog {
        RelationalProcedure relationalProcedure;

        public SelectProcedureTypeDialog(Shell parentShell, RelationalProcedure procedure) {
            super(parentShell);
            this.relationalProcedure = procedure;
        }

        protected void constrainShellSize() {
            super.constrainShellSize();
            Shell shell = this.getShell();
            shell.setText(Messages.selectProcedureTypeDialogTitle);
            Rectangle r = shell.getBounds();
            shell.setBounds(r.x, r.y, (int)((double)r.width * 0.67), r.height);
            Shell parentShell = (Shell)shell.getParent();
            Rectangle parentBounds = parentShell.getBounds();
            Point parentCenter = new Point(parentBounds.x + parentBounds.width / 2, parentBounds.y + parentBounds.height / 2);
            Rectangle r2 = shell.getBounds();
            Point shellLocation = new Point(parentCenter.x - r2.width / 2, parentCenter.y - r2.height / 2);
            shell.setBounds(Math.max(0, shellLocation.x), Math.max(0, shellLocation.y), r2.width, r2.height);
        }

        protected Control createDialogArea(Composite parent) {
            Composite pnlOuter = (Composite)super.createDialogArea(parent);
            Composite panel = new Composite(pnlOuter, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginLeft = 20;
            gridLayout.marginRight = 20;
            panel.setLayout((Layout)gridLayout);
            panel.setLayoutData((Object)new GridData(16384, 128, true, true));
            this.setTitle(Messages.selectProcedureTypeDialogSubTitle);
            Button procedureRB = new Button(panel, 16);
            procedureRB.setLayoutData((Object)new GridData(16384, 128, false, false));
            procedureRB.setText(Messages.procedureLabel);
            procedureRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectProcedureTypeDialog.this.handleInfoChanged(RelationalProcedure.PROCEDURE_TYPE.PROCEDURE);
                }
            });
            procedureRB.setSelection(!this.relationalProcedure.isFunction());
            Text descText = new Text(panel, 74);
            descText.setBackground(parent.getBackground());
            descText.setForeground(Display.getCurrent().getSystemColor(10));
            descText.setLayoutData((Object)new GridData(16384, 128, true, true));
            ((GridData)descText.getLayoutData()).horizontalIndent = 20;
            ((GridData)descText.getLayoutData()).heightHint = 3 * descText.getLineHeight();
            descText.setText(Messages.createRelationalProcedureDescription);
            Button sourceFunctionRB = new Button(panel, 16);
            sourceFunctionRB.setLayoutData((Object)new GridData(16384, 128, false, false));
            sourceFunctionRB.setText(Messages.sourceFunctionLabel);
            sourceFunctionRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectProcedureTypeDialog.this.handleInfoChanged(RelationalProcedure.PROCEDURE_TYPE.SOURCE_FUNCTION);
                }
            });
            if (this.relationalProcedure.isSourceFunction()) {
                sourceFunctionRB.setSelection(this.relationalProcedure.isSourceFunction());
            }
            descText = new Text(panel, 74);
            descText.setBackground(parent.getBackground());
            descText.setForeground(Display.getCurrent().getSystemColor(10));
            descText.setLayoutData((Object)new GridData(16384, 128, true, true));
            ((GridData)descText.getLayoutData()).horizontalIndent = 20;
            ((GridData)descText.getLayoutData()).heightHint = 3 * descText.getLineHeight();
            descText.setText(Messages.createRelationalSourceFunctionDescription);
            Button nativeQueryProcedureRB = new Button(panel, 16);
            nativeQueryProcedureRB.setLayoutData((Object)new GridData(16384, 128, false, false));
            nativeQueryProcedureRB.setText(Messages.nativeQueryProcedureLabel);
            nativeQueryProcedureRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectProcedureTypeDialog.this.handleInfoChanged(RelationalProcedure.PROCEDURE_TYPE.NATIVE_QUERY_PROCEDURE);
                }
            });
            if (this.relationalProcedure.isNativeQueryProcedure()) {
                nativeQueryProcedureRB.setSelection(this.relationalProcedure.isNativeQueryProcedure());
            }
            descText = new Text(panel, 74);
            descText.setBackground(parent.getBackground());
            descText.setForeground(Display.getCurrent().getSystemColor(10));
            descText.setLayoutData((Object)new GridData(16384, 128, true, true));
            ((GridData)descText.getLayoutData()).horizontalIndent = 20;
            ((GridData)descText.getLayoutData()).heightHint = 3 * descText.getLineHeight();
            descText.setText(Messages.createRelationalNativeQueryProcedureDescription);
            return pnlOuter;
        }

        private void handleInfoChanged(RelationalProcedure.PROCEDURE_TYPE typeSelected) {
            this.relationalProcedure.setProcedureType(typeSelected);
        }
    }
}

