/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.widget.INodeDescendantsDeselectionHandler;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.wizards.DeselectDescendantsDialog;
import org.teiid.designer.ui.wizards.IStructuralCopyTreePopulator;
import org.teiid.designer.ui.wizards.TreeViewerWizardPanel;

public class StructuralCopyWizardPage
extends WizardPage
implements UiConstants,
INodeDescendantsDeselectionHandler {
    private static final int DESCENDANT_NODES_DESELECTION_YES = 1;
    private static final int DESCENDANT_NODES_DESELECTION_NO = 2;
    private static final int DESCENDANT_NODES_DESELECTION_PROMPT = 3;
    private static int deselectionInstruction = 3;
    private ISelection selection;
    private TreeViewerWizardPanel panel;
    private MetamodelDescriptor metamodelDescriptor;
    protected boolean targetIsVirtual;

    public StructuralCopyWizardPage(ISelection selection, MetamodelDescriptor metamodelDescriptor, boolean targetIsVirtual) {
        super("specifyStructuralCopyPage");
        this.setTitle(Util.getString("StructuralCopyWizardPage.title", new Object[0]));
        this.setDescription(Util.getString("StructuralCopyWizardPage.description", new Object[0]));
        this.selection = selection;
        this.metamodelDescriptor = metamodelDescriptor;
        this.targetIsVirtual = targetIsVirtual;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Object obj;
        ModelResource selectedResource = null;
        if (this.selection != null && SelectionUtilities.isSingleSelection((ISelection)this.selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)this.selection)) instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)obj))) {
            try {
                selectedResource = ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)false);
                if (!selectedResource.getPrimaryMetamodelDescriptor().equals(this.metamodelDescriptor)) {
                    selectedResource = null;
                } else {
                    this.setPageComplete(true);
                }
            }
            catch (ModelWorkspaceException modelWorkspaceException) {}
        }
        this.panel = new TreeViewerWizardPanel(parent, this, this.metamodelDescriptor, selectedResource, this.targetIsVirtual);
        this.setControl((Control)this.panel);
    }

    public TreeViewer getViewer() {
        return this.panel.getViewer();
    }

    public IStructuralCopyTreePopulator getTreePopulator() {
        return this.panel.getTreePopulator();
    }

    public boolean deselectDescendants(Object node) {
        boolean deselect;
        switch (deselectionInstruction) {
            case 1: {
                deselect = true;
                break;
            }
            case 2: {
                deselect = false;
                break;
            }
            default: {
                DeselectDescendantsDialog dialog = new DeselectDescendantsDialog(this.getShell());
                int response = dialog.open();
                boolean alwaysUseResponse = dialog.alwaysUseResponse();
                if (response == 64) {
                    deselect = true;
                    if (!alwaysUseResponse) break;
                    deselectionInstruction = 1;
                    break;
                }
                deselect = false;
                if (!alwaysUseResponse) break;
                deselectionInstruction = 2;
            }
        }
        return deselect;
    }

    public boolean isCopyEntireModel() {
        return this.panel.isCopyEntireModel();
    }

    public boolean isCopyAllDescriptions() {
        return this.panel.isCopyAllDescriptions();
    }

    public boolean doGenerateDefaultSQL() {
        return this.panel.doGenerateDefaultSQL();
    }
}

