/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.wizards.INewModelWizardContributor;
import org.teiid.designer.ui.wizards.IStructuralCopyTreePopulator;
import org.teiid.designer.ui.wizards.StructuralCopyWizardPage;

public class StructuralCopyContributor
implements INewModelWizardContributor,
UiConstants {
    private IWizardPage[] pages;
    private StructuralCopyWizardPage structuralCopyPage;

    @Override
    public boolean canFinishEarly(IWizardPage theCurrentPage) {
        return false;
    }

    @Override
    public void createWizardPages(ISelection selection, IResource targetResource, IPath targetFilePath, MetamodelDescriptor descriptor, boolean isVirtual) {
        this.pages = new IWizardPage[1];
        this.structuralCopyPage = new StructuralCopyWizardPage(selection, descriptor, isVirtual);
        this.pages[0] = this.structuralCopyPage;
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void doFinish(ModelResource modelResource, IProgressMonitor monitor) {
        HashMap<String, Boolean> extraProps = new HashMap<String, Boolean>();
        if (this.structuralCopyPage.doGenerateDefaultSQL()) {
            extraProps.put("generateDefaultSQL", true);
            extraProps.put("validate", true);
        }
        String transactionName = Util.getString("StructuralCopyContributor.copyExistingModelTransactionName", new Object[0]);
        boolean started = ModelerCore.startTxn((String)transactionName, (Object)this);
        boolean succeeded = false;
        try {
            IStructuralCopyTreePopulator populator = this.structuralCopyPage.getTreePopulator();
            TreeViewer viewer = this.structuralCopyPage.getViewer();
            if (populator != null && viewer != null) {
                try {
                    populator.copyModel((ModelResource)viewer.getInput(), modelResource, extraProps, this.structuralCopyPage.isCopyAllDescriptions(), monitor);
                }
                catch (Exception ex) {
                    UiConstants.Util.log(4, (Throwable)ex, ex.getMessage());
                }
            }
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    @Override
    public IWizardPage[] getWizardPages() {
        return this.pages;
    }

    @Override
    public void inputChanged(ISelection selection, IResource targetResource, MetamodelDescriptor descriptor, boolean isVirtual) {
    }

    @Override
    public void currentPageChanged(IWizardPage page) {
    }
}

