/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceImpl;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.diagram.DiagramContainer;
import org.teiid.designer.metamodels.transformation.TransformationContainer;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class SystemModelTreeViewer
extends TreeViewer {
    public SystemModelTreeViewer(Composite parent) {
        this(parent, 770);
    }

    public SystemModelTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new SystemModelContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new SystemModelLabelProvider());
        this.addFilter(new SystemModelViewerFilter());
        Resource[] models = ModelerCore.getSystemVdbResources();
        ArrayList<Resource> virtualModels = new ArrayList<Resource>(models.length);
        int i = 0;
        while (i < models.length) {
            ModelAnnotation annotation;
            if (models[i] instanceof MtkXmiResourceImpl && (annotation = ((MtkXmiResourceImpl)models[i]).getModelAnnotation()).getModelType() == ModelType.PHYSICAL_LITERAL) {
                virtualModels.add(models[i]);
            }
            ++i;
        }
        Resource[] result = new Resource[virtualModels.size()];
        virtualModels.toArray(result);
        super.setInput((Object)result);
    }

    class SystemModelContentProvider
    implements ITreeContentProvider {
        private ITreeContentProvider modelObjectProvider = ModelUtilities.getModelContentProvider();

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.modelObjectProvider.getChildren(parentElement);
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object getParent(Object element) {
            return this.modelObjectProvider.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.modelObjectProvider.hasChildren(element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class SystemModelLabelProvider
    implements ILabelProvider {
        ILabelProvider delegate = ModelUtilities.getModelObjectLabelProvider();

        SystemModelLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
            this.delegate.addListener(listener);
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.delegate.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.delegate.removeListener(listener);
        }

        public Image getImage(Object element) {
            ModelAnnotation annotation;
            if (element instanceof MtkXmiResourceImpl && (annotation = ((MtkXmiResourceImpl)element).getModelAnnotation()).getModelType() == ModelType.PHYSICAL_LITERAL) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/Model.gif");
            }
            return this.delegate.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof Resource) {
                String filename = ((Resource)element).getURI().lastSegment();
                return filename.substring(0, filename.indexOf(46));
            }
            return this.delegate.getText(element);
        }
    }

    class SystemModelViewerFilter
    extends ViewerFilter {
        SystemModelViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ModelAnnotation) {
                return false;
            }
            if (element instanceof TransformationContainer) {
                return false;
            }
            if (element instanceof DiagramContainer) {
                return false;
            }
            if (element instanceof AnnotationContainer) {
                return false;
            }
            if (element instanceof MtkXmiResourceImpl) {
                return ((MtkXmiResourceImpl)element).getModelAnnotation().getModelType() == ModelType.PHYSICAL_LITERAL;
            }
            return true;
        }
    }
}

