/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.explorer.ModelExplorerResourceNavigator;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.wizards.NewModelProjectWizard;

public class ModelerUiViewUtils {
    private static IViewPart cachedView;

    public static void openModelResourceNavigator(ISelection selection) {
        String viewId = ProductCustomizerMgr.getInstance().getProductCharacteristics().getPrimaryNavigationViewId();
        ModelerUiViewUtils.openView(viewId, selection);
    }

    public static IViewPart openView(final String viewId, final ISelection selection, boolean synchronous) {
        IViewPart theView = null;
        cachedView = null;
        if (viewId != null) {
            if (synchronous) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ModelerUiViewUtils.openView(viewId, selection);
                    }
                });
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ModelerUiViewUtils.openView(viewId, selection);
                    }
                });
            }
        }
        theView = cachedView;
        cachedView = null;
        return theView;
    }

    private static void openView(String viewId, ISelection selection) {
        ISelectionProvider selectionProvider;
        IWorkbenchPage page = UiUtil.getWorkbenchPage();
        cachedView = page.findView(viewId);
        if (cachedView == null) {
            try {
                cachedView = page.showView(viewId);
            }
            catch (PartInitException theException) {
                UiConstants.Util.log(4, (Throwable)theException, theException.getLocalizedMessage());
                WidgetUtil.showError((String)theException.getLocalizedMessage());
            }
        }
        if (cachedView != null && selection != null && (selectionProvider = cachedView.getViewSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection((Object)selection));
        }
    }

    public static void refreshModelExplorerResourceNavigatorTree() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelExplorerResourceNavigator view = (ModelExplorerResourceNavigator)UiUtil.getViewPart((String)"explorer.view");
                if (view != null) {
                    view.getTreeViewer().refresh(true);
                }
            }
        });
    }

    public static void refreshWorkspace() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RefreshAction refreshAction = new RefreshAction((IShellProvider)UiPlugin.getDefault().getCurrentWorkbenchWindow());
                refreshAction.refreshAll();
            }
        });
    }

    public static void launchWizard(String id, IStructuredSelection selection, boolean synchronous) {
        ModelerUiViewUtils.launchWizard(id, selection, new Properties(), synchronous);
    }

    public static void launchWizard(final String id, final IStructuredSelection selection, final Properties properties, final boolean synchronous) {
        if (synchronous) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
                    if (descriptor == null) {
                        descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(id);
                    }
                    if (descriptor == null) {
                        descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(id);
                    }
                    try {
                        if (descriptor != null) {
                            IWorkbenchWizard wizard = descriptor.createWizard();
                            ModelerUiViewUtils.launchWizard(wizard, selection, properties, synchronous, true);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
                    if (descriptor == null) {
                        descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(id);
                    }
                    if (descriptor == null) {
                        descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(id);
                    }
                    try {
                        if (descriptor != null) {
                            IWorkbenchWizard wizard = descriptor.createWizard();
                            ModelerUiViewUtils.launchWizard(wizard, selection, properties, synchronous, true);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void launchWizard(IWorkbenchWizard wizard, IStructuredSelection selection, boolean synchronous) {
        ModelerUiViewUtils.launchWizard(wizard, selection, null, synchronous, true);
    }

    public static void launchWizard(final IWorkbenchWizard wizard, final IStructuredSelection selection, final Properties properties, boolean synchronous, final boolean requiresProject) {
        if (synchronous) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    wizard.init(PlatformUI.getWorkbench(), selection);
                    if (properties != null && wizard instanceof IPropertiesContext) {
                        ((IPropertiesContext)wizard).setProperties(properties);
                    }
                    WizardDialog wd = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    String openProjectStatus = null;
                    if (properties != null) {
                        openProjectStatus = DesignerPropertiesUtil.getProjectStatus(properties);
                    }
                    if (requiresProject) {
                        if (wizard instanceof NewModelProjectWizard || openProjectStatus == null || !"noOpenProject".equalsIgnoreCase(openProjectStatus)) {
                            wd.setTitle(wizard.getWindowTitle());
                            wd.open();
                        }
                    } else {
                        wd.setTitle(wizard.getWindowTitle());
                        wd.open();
                    }
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    wizard.init(PlatformUI.getWorkbench(), selection);
                    if (properties != null && wizard instanceof IPropertiesContext) {
                        ((IPropertiesContext)wizard).setProperties(properties);
                    }
                    WizardDialog wd = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    String openProjectStatus = null;
                    if (properties != null) {
                        openProjectStatus = DesignerPropertiesUtil.getProjectStatus(properties);
                    }
                    if (openProjectStatus == null || !"noOpenProject".equalsIgnoreCase(openProjectStatus)) {
                        wd.setTitle(wizard.getWindowTitle());
                        wd.open();
                    }
                }
            });
        }
    }

    public static boolean workspaceHasOpenModelProjects() {
        return !ModelerUiViewUtils.getOpenModelProjects().isEmpty();
    }

    public static Collection<IProject> getOpenModelProjects() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> openModelProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (proj.isOpen() && ModelerCore.hasModelNature((IProject)proj)) {
                openModelProjects.add(proj);
            }
            ++n2;
        }
        return openModelProjects;
    }

    public static IProject queryUserToCreateModelProject() {
        Properties newProps = new Properties();
        ModelerUiViewUtils.launchWizard("newModelProject", (IStructuredSelection)new StructuredSelection(), newProps, true);
        IProject project = DesignerPropertiesUtil.getProject(newProps);
        return project;
    }
}

