/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectContentProvider;

public class ModelWorkspaceTreeProvider
extends ModelExplorerLabelProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private ITreeContentProvider modelContentProvider = ModelObjectContentProvider.getInstance();

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFolder) {
            try {
                return ((IFolder)parentElement).members();
            }
            catch (CoreException e) {
                UiConstants.Util.log((Throwable)e);
                return NO_CHILDREN;
            }
        }
        if (parentElement instanceof IFile) {
            return NO_CHILDREN;
        }
        if (parentElement instanceof IProject) {
            try {
                return ((IProject)parentElement).members();
            }
            catch (CoreException e) {
                UiConstants.Util.log((Throwable)e);
                return NO_CHILDREN;
            }
        }
        return this.modelContentProvider.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.modelContentProvider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof IFile);
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = ((IWorkspaceRoot)inputElement).getProjects();
        return result;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.modelContentProvider.inputChanged(viewer, oldInput, newInput);
    }

    @Override
    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
    }
}

