/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.WorkbenchException;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;

public abstract class MarkerUtilities {
    public static final int SEVERITY_OK = -1;

    public static Object getMarkerAttribute(IMarker iMarker, String attributeName) {
        Object attribute;
        block3: {
            attribute = null;
            if (iMarker != null) {
                try {
                    attribute = iMarker.getAttribute(attributeName);
                }
                catch (CoreException e) {
                    if (!(e instanceof ModelerCoreException) && !(e instanceof WorkbenchException)) break block3;
                    String message = UiConstants.Util.getString("MarkerUtilities.getMarkerAttribute.errorMessage", (Object)attributeName);
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
            }
        }
        return attribute;
    }

    public static Object getMarkerAttribute(IMarker iMarker, String attributeName, ModelResource resource) {
        if (resource == null || resource.exists() && resource.isOpen()) {
            return MarkerUtilities.getMarkerAttribute(iMarker, attributeName);
        }
        return null;
    }

    public static int getMarkerStatus(IStatus status) {
        int sev;
        switch (status.getSeverity()) {
            case 4: {
                sev = 2;
                break;
            }
            case 2: {
                sev = 1;
                break;
            }
            case 1: {
                sev = 0;
                break;
            }
            default: {
                sev = -1;
            }
        }
        return sev;
    }

    public static int getWorstMarkerSeverity(IResource theResource) throws CoreException {
        int result = -1;
        IMarker[] markers = theResource.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        if (markers != null && markers.length != 0) {
            int i = 0;
            while (i < markers.length) {
                Object attr = MarkerUtilities.getMarkerAttribute(markers[i], "severity");
                if (attr != null) {
                    int severity = (Integer)attr;
                    if (severity == 2) {
                        result = 2;
                        break;
                    }
                    if (result == -1) {
                        result = severity;
                    } else if (severity == 1 && result == 0) {
                        result = severity;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static int getWorstMarkerSeverity(IResource[] theResources) throws CoreException {
        int result = -1;
        if (theResources != null && theResources.length != 0) {
            int i = 0;
            while (i < theResources.length) {
                int severity = MarkerUtilities.getWorstMarkerSeverity(theResources[i]);
                if (severity == 2) {
                    result = 2;
                    break;
                }
                if (result == -1) {
                    result = severity;
                } else if (severity == 1 && result == 0) {
                    result = severity;
                }
                ++i;
            }
        }
        return result;
    }

    public static ImageDescriptor getDecorationIcon(int theMarkerSeverity) {
        ImageDescriptor result = null;
        if (theMarkerSeverity == 2) {
            result = UiPlugin.getDefault().getErrorDecoratorImage();
        } else if (theMarkerSeverity == 1) {
            result = UiPlugin.getDefault().getWarningDecoratorImage();
        }
        return result;
    }
}

