/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.views.ModelerView;

public class SQLReservedWordsView
extends ModelerView {
    private static final String TEXT_ENTRY_LABEL_TEXT = UiConstants.Util.getString("SQLReservedWordsPanel.textEntryLabel.text", new Object[0]);
    private static final String UPPER_TABLE_LABEL_TEXT = UiConstants.Util.getString("SQLReservedWordsPanel.upperTableLabel.text", new Object[0]);
    private Object[] fElements = null;
    private FilteredList fFilteredList;
    private ILabelProvider fFilterRenderer;
    Text fFilterText;
    private boolean fIgnoreCase = true;
    private boolean fAllowDuplicates = false;
    private boolean fMatchEmptyString = true;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        GridData gridData1 = new GridData(1808);
        parent.setLayoutData((Object)gridData1);
        this.createLabel(parent, TEXT_ENTRY_LABEL_TEXT);
        this.createFilterText(parent);
        this.createLabel(parent, UPPER_TABLE_LABEL_TEXT);
        this.createFilteredList(parent);
        this.fElements = this.getAllSQLReservedWords();
        this.setListElements(this.fElements);
    }

    private Object[] getAllSQLReservedWords() {
        IQueryService service = ModelerCore.getTeiidQueryService();
        return service.getReservedWords().toArray();
    }

    protected void setListElements(Object[] elements) {
        Assert.isNotNull((Object)this.fFilteredList);
        this.fFilteredList.setElements(elements);
    }

    protected Label createLabel(Composite parent, String name) {
        if (name == null) {
            return null;
        }
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setFont(parent.getFont());
        return label;
    }

    protected Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        text.setText("");
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                SQLReservedWordsView.this.fFilteredList.setFilter(SQLReservedWordsView.this.fFilterText.getText());
            }
        };
        text.addListener(24, listener);
        this.fFilterText = text;
        return text;
    }

    private FilteredList createFilteredList(Composite parent) {
        int flags = 2820;
        this.fFilterRenderer = new LabelProvider();
        FilteredList list = new FilteredList(parent, flags, this.fFilterRenderer, this.fIgnoreCase, this.fAllowDuplicates, this.fMatchEmptyString);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData((Object)data);
        list.setFont(parent.getFont());
        list.setFilter("");
        this.fFilteredList = list;
        return list;
    }

    public void setFocus() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

