/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.transaction.Undoable;
import org.teiid.designer.core.transaction.UndoableListener;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.undo.IUndoManager;
import org.teiid.designer.ui.undo.ModelerUndoListener;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelerUndoManager
implements UndoableListener,
IUndoManager {
    private static ModelerUndoManager instance = new ModelerUndoManager();
    private ListenerList modellerUndoListeners;
    private IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
    private IUndoContext undoContext;

    public static ModelerUndoManager getInstance() {
        return instance;
    }

    private ModelerUndoManager() {
        this.modellerUndoListeners = new ListenerList(1);
        try {
            Container modelContainer = ModelerCore.getModelContainer();
            this.undoContext = (IUndoContext)ModelerCore.getWorkspace().getAdapter(IUndoContext.class);
            modelContainer.addUndoableEditListener((UndoableListener)this);
        }
        catch (CoreException e) {
            UiConstants.Util.log((Throwable)e);
        }
    }

    public void addUndoListener(ModelerUndoListener listener) {
        this.modellerUndoListeners.add((Object)listener);
    }

    public void removeUndoListener(ModelerUndoListener listener) {
        this.modellerUndoListeners.remove((Object)listener);
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    @Override
    public boolean canRedo() {
        return OperationHistoryFactory.getOperationHistory().canRedo(this.undoContext);
    }

    @Override
    public boolean canUndo() {
        return OperationHistoryFactory.getOperationHistory().canUndo(this.undoContext);
    }

    @Override
    public void redo(IProgressMonitor monitor) throws ExecutionException {
        if (!this.canRedo()) {
            return;
        }
        try {
            monitor.beginTask("Starting redo operation", 1);
            OperationHistoryFactory.getOperationHistory().redo(this.getUndoContext(), null, null);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void undo(IProgressMonitor monitor) throws ExecutionException {
        if (!this.canUndo()) {
            return;
        }
        try {
            monitor.beginTask("Starting redo operation", 1);
            OperationHistoryFactory.getOperationHistory().undo(this.getUndoContext(), null, null);
        }
        finally {
            monitor.done();
        }
    }

    public void process(Undoable edit) {
        if (!edit.canUndo()) {
            return;
        }
        ModelerUndoOperation operation = new ModelerUndoOperation(edit);
        this.operationHistory.add((IUndoableOperation)operation);
        this.fireEvent();
    }

    private void fireEvent() {
        EventObject event = new EventObject(ModelerUndoManager.getInstance());
        Object[] objectArray = this.modellerUndoListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ModelerUndoListener)listener).processEvent(event);
            ++n2;
        }
    }

    private void openAllEditors(Collection resources) {
        ArrayList changedResources = new ArrayList(resources);
        Resource nextRes2 = null;
        ModelResource mr = null;
        for (Resource nextRes2 : changedResources) {
            mr = ModelUtilities.getModelResource(nextRes2, true);
            if (mr == null) continue;
            ModelEditorManager.activate(mr, true);
        }
    }

    @Override
    public String getRedoLabel() {
        return null;
    }

    @Override
    public String getUndoLabel() {
        return null;
    }

    private class ModelerUndoOperation
    extends AbstractOperation {
        private final Undoable edit;

        public ModelerUndoOperation(Undoable edit) {
            super(edit.getPresentationName());
            this.edit = edit;
            this.addContext(ModelerUndoManager.this.undoContext);
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus status = null;
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Redo Edit", (Object)((Object)this));
            try {
                try {
                    this.edit.redo();
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("ModelerUndoManager.redoErrorMessage", (Object)this.edit.toString());
                    UiConstants.Util.log(4, (Throwable)e, message);
                    status = IOperationHistory.OPERATION_INVALID_STATUS;
                    throw new ExecutionException(message);
                }
            }
            finally {
                if (requiredStart) {
                    if (status != null && status.isOK()) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                ModelerUndoManager.this.fireEvent();
            }
            return status;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus status = null;
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Undo Edit", (Object)((Object)this));
            try {
                try {
                    this.edit.undo();
                    ModelerUndoManager.this.openAllEditors(this.edit.getResources());
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("ModelerUndoManager.undoErrorMessage", (Object)this.edit.toString());
                    UiConstants.Util.log(4, (Throwable)e, message);
                    status = IOperationHistory.OPERATION_INVALID_STATUS;
                    throw new ExecutionException(message);
                }
            }
            finally {
                if (requiredStart) {
                    if (status != null && status.isOK()) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                ModelerUndoManager.this.fireEvent();
            }
            return status;
        }
    }
}

