/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.ObjectExtension;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.ModelObjectPropertySource;
import org.teiid.designer.ui.properties.extension.ModelExtensionPropertyDescriptor;
import org.teiid.designer.ui.properties.udp.ExtensionPropertyDescriptor;
import org.teiid.designer.ui.properties.udp.ExtensionPropertySource;
import org.teiid.designer.ui.table.ClipboardPasteStatusRecord;
import org.teiid.designer.ui.table.ModelObjectTableModel;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelRowElement {
    private EObject modelObject;
    private ModelObjectTableModel tableModel;
    private IPropertySource propertySource;
    private Map propIdDescriptorMap;

    public ModelRowElement(EObject modelObject, ModelObjectTableModel tableModel) {
        this.modelObject = modelObject;
        this.tableModel = tableModel;
        this.propertySource = tableModel.getPropertySource(modelObject);
        this.setModelExtensionPropertyIdDescriptorMap();
    }

    private void setModelExtensionPropertyIdDescriptorMap() {
        this.propIdDescriptorMap = new HashMap();
        IPropertyDescriptor[] properties = this.propertySource.getPropertyDescriptors();
        int i = 0;
        while (i < properties.length) {
            Object id = properties[i].getId();
            if (id instanceof ModelExtensionPropertyDescriptor) {
                this.propIdDescriptorMap.put(((ModelExtensionPropertyDescriptor)id).getPropDefnId(), properties[i]);
            }
            ++i;
        }
    }

    private IPropertyDescriptor getModelExtensionPropertyDescriptor(String thePropertyDefnId) {
        return (IPropertyDescriptor)this.propIdDescriptorMap.get(thePropertyDefnId);
    }

    public final Object getValueObject(String propertyID) {
        if (propertyID.equals(UiConstants.LOCATION_KEY)) {
            return ModelUtilities.getEMFLabelProvider().getText((Object)this.modelObject.eContainer());
        }
        if (propertyID.equals(UiConstants.DESCRIPTION_KEY)) {
            return ModelObjectUtilities.getDescription(this.modelObject);
        }
        Object propId = this.getPropertyId(propertyID);
        Object value = this.propertySource.getPropertyValue(propId);
        if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper) {
            value = ((ItemPropertyDescriptor.PropertyValueWrapper)value).getEditableValue((Object)this.modelObject);
        }
        return value;
    }

    public final String getInvalidValueMessage(String propertyID, Object value) {
        String result = null;
        Object object = this.propertySource.getEditableValue();
        IItemPropertySource itemSource = (IItemPropertySource)ModelerCore.getMetamodelRegistry().getAdapterFactory().adapt(object, IItemPropertySource.class);
        IItemPropertyDescriptor itemDescriptor = itemSource.getPropertyDescriptor(object, (Object)propertyID);
        if (itemDescriptor != null) {
            EStructuralFeature feature = (EStructuralFeature)itemDescriptor.getFeature(object);
            if (value instanceof String) {
                if (ModelerCore.getModelEditor().isDatatypeFeature(this.modelObject, feature)) {
                    try {
                        String theValue = this.getDatatypeShortString((String)value);
                        EObject testValue = ModelerCore.getDatatypeManager((EObject)this.modelObject, (boolean)true).findDatatype(theValue);
                        if (testValue == null) {
                            result = UiConstants.Util.getString("ModelRowElement.invalidValueError", new Object[]{value, propertyID});
                        }
                    }
                    catch (ModelerCoreException mce) {
                        ModelerCore.Util.log(4, (Throwable)mce, mce.getMessage());
                    }
                } else if (feature.getEType() instanceof EDataType) {
                    EDataType dt = (EDataType)feature.getEType();
                    EPackage ePackage = dt.getEPackage();
                    EFactory fac = ePackage.getEFactoryInstance();
                    try {
                        fac.createFromString(dt, (String)value);
                    }
                    catch (Exception exception) {
                        result = UiConstants.Util.getString("ModelRowElement.invalidValueError", new Object[]{value, propertyID});
                    }
                }
            } else {
                result = UiConstants.Util.getString("ModelRowElement.unsupportedError", (Object)propertyID);
            }
        }
        return result;
    }

    private String getDatatypeShortString(String longString) {
        if (longString == null) {
            return null;
        }
        String modValue = longString;
        int colonIndex = longString.indexOf(58);
        if (colonIndex != -1) {
            modValue = longString.substring(0, colonIndex).trim();
        }
        return modValue;
    }

    public final String getReferenceColumnMessage(String propertyID, Object value) {
        String result = null;
        Object object = this.propertySource.getEditableValue();
        IItemPropertySource itemSource = (IItemPropertySource)ModelerCore.getMetamodelRegistry().getAdapterFactory().adapt(object, IItemPropertySource.class);
        IItemPropertyDescriptor itemDescriptor = itemSource.getPropertyDescriptor(object, (Object)propertyID);
        if (itemDescriptor != null) {
            EStructuralFeature feature = (EStructuralFeature)itemDescriptor.getFeature(object);
            if (value instanceof String && !ModelerCore.getModelEditor().isDatatypeFeature(this.modelObject, feature) && !(feature.getEType() instanceof EDataType)) {
                result = ClipboardPasteStatusRecord.REFERENCE_COLUMN_MSG;
            }
        }
        return result;
    }

    public final String getInvalidValueMessage(ExtensionPropertyDescriptor propertyID, Object value) {
        ObjectExtension objExt;
        ExtensionPropertySource eps;
        String result = null;
        EObject eObj = propertyID.getExtensionObject();
        if (eObj != null && eObj instanceof ObjectExtension && !(eps = new ExtensionPropertySource((objExt = (ObjectExtension)eObj).getExtendedObject())).canConvertToCorrectDatatype(propertyID, value)) {
            result = UiConstants.Util.getString("ModelRowElement.invalidValueError", new Object[]{value, propertyID.toString()});
        }
        return result;
    }

    public final void setValue(String propertyID, Object value) {
        if (propertyID.equals(UiConstants.DESCRIPTION_KEY)) {
            String desc = ModelObjectUtilities.getDescription(this.modelObject);
            if (desc == null) {
                if (value != null && !"".equals(value)) {
                    ModelObjectUtilities.setDescription(this.modelObject, (String)value, this);
                }
            } else if (!desc.equals(value)) {
                ModelObjectUtilities.setDescription(this.modelObject, (String)value, this);
            }
        } else if (!propertyID.equals(UiConstants.LOCATION_KEY)) {
            try {
                Object propId;
                Object currentValue;
                Object object = this.propertySource.getEditableValue();
                IItemPropertySource itemSource = (IItemPropertySource)ModelerCore.getMetamodelRegistry().getAdapterFactory().adapt(object, IItemPropertySource.class);
                IItemPropertyDescriptor itemDescriptor = itemSource.getPropertyDescriptor(object, (Object)propertyID);
                if (itemDescriptor != null) {
                    EStructuralFeature feature = (EStructuralFeature)itemDescriptor.getFeature(object);
                    if (value instanceof String && ModelerCore.getModelEditor().isDatatypeFeature(this.modelObject, feature)) {
                        String theValue = this.getDatatypeShortString((String)value);
                        try {
                            value = ModelerCore.getDatatypeManager((EObject)this.modelObject, (boolean)true).findDatatype(theValue);
                        }
                        catch (ModelerCoreException mce) {
                            ModelerCore.Util.log(4, (Throwable)mce, mce.getMessage());
                        }
                    }
                }
                if ((currentValue = this.propertySource.getPropertyValue(propId = this.getPropertyId(propertyID))) == null) {
                    if (value != null) {
                        this.propertySource.setPropertyValue(propId, value);
                    }
                } else if (!currentValue.equals(value)) {
                    this.propertySource.setPropertyValue(propId, value);
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelRowElement.setValueError", new Object[]{value, propertyID, this.modelObject.eClass().getName()});
                UiConstants.Util.log(4, (Throwable)e, message);
                String title = UiConstants.Util.getString("ModelRowElement.setValueErrorTitle", new Object[0]);
                MessageDialog.openError(null, (String)title, (String)message);
            }
        }
    }

    public final void setValue(ExtensionPropertyDescriptor descriptor, Object value) {
        try {
            if (this.propertySource instanceof ModelObjectPropertySource) {
                ((ModelObjectPropertySource)this.propertySource).setPropertyValue(descriptor, value);
            }
        }
        catch (Exception e) {
            String message = UiConstants.Util.getString("ModelRowElement.setValueError", new Object[]{value, descriptor.toString(), this.modelObject.eClass().getName()});
            UiConstants.Util.log(4, (Throwable)e, message);
            String title = UiConstants.Util.getString("ModelRowElement.setValueErrorTitle", new Object[0]);
            MessageDialog.openError(null, (String)title, (String)message);
        }
    }

    public final Object getValue(int index) {
        if (this.modelObject.eIsProxy()) {
            return null;
        }
        String result = null;
        Object propertyId = this.tableModel.getPropertyIdAtIndex(index);
        if (this.tableModel.isLocationColumn(propertyId)) {
            EObject container = this.modelObject.eContainer();
            if (container != null) {
                result = ModelUtilities.getEMFLabelProvider().getText((Object)this.modelObject.eContainer());
            } else {
                try {
                    ModelResource mr = ModelUtilities.getModelResource(this.modelObject);
                    if (mr != null && mr.getCorrespondingResource() != null) {
                        result = ModelUtilities.getModelName(this.modelObject);
                    }
                }
                catch (ModelWorkspaceException ex) {
                    String message = "[ModelRowElement.getValue()]:  exception finding resource for model";
                    UiConstants.Util.log(4, (Throwable)ex, message);
                }
            }
        } else if (this.tableModel.isDescriptionColumn(propertyId)) {
            result = ModelObjectUtilities.getDescription(this.modelObject);
        } else {
            IPropertyDescriptor descriptor = this.getPropertyDescriptor(propertyId);
            if (descriptor != null) {
                if (propertyId instanceof ModelExtensionPropertyDescriptor) {
                    propertyId = descriptor.getId();
                }
                result = descriptor.getLabelProvider().getText(this.propertySource.getPropertyValue(propertyId));
            }
        }
        return result;
    }

    public final IPropertyDescriptor getPropertyDescriptor(Object propertyId) {
        IPropertyDescriptor descriptor = this.tableModel.getPropertyDescriptor(propertyId);
        if (propertyId instanceof ModelExtensionPropertyDescriptor) {
            descriptor = this.getModelExtensionPropertyDescriptor(((ModelExtensionPropertyDescriptor)propertyId).getPropDefnId());
        }
        return descriptor;
    }

    public final Object getPropertyId(String propertyId) {
        Object propId = this.tableModel.getPropertyId(propertyId);
        if (propId instanceof ModelExtensionPropertyDescriptor) {
            IPropertyDescriptor descriptor = this.getModelExtensionPropertyDescriptor(((ModelExtensionPropertyDescriptor)propId).getPropDefnId());
            propId = descriptor.getId();
        }
        return propId;
    }

    public final Object getPropertyIdForColumn(int index) {
        return this.tableModel.getPropertyIdAtIndex(index);
    }

    public EObject getModelObject() {
        return this.modelObject;
    }
}

