/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.table.TableViewerSorter;
import org.teiid.designer.ui.properties.ModelObjectPropertyDescriptor;
import org.teiid.designer.ui.properties.extension.ModelExtensionPropertyDescriptor;
import org.teiid.designer.ui.properties.udp.ExtensionPropertyDescriptor;
import org.teiid.designer.ui.table.EObjectPropertiesOrderPreferencesListener;
import org.teiid.designer.ui.table.ModelRowElement;
import org.teiid.designer.ui.table.PropertyOrder;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelObjectTableModel
implements UiConstants,
EObjectPropertiesOrderPreferencesListener,
DisposeListener {
    private ArrayList instanceList;
    private ArrayList rowList;
    private HashMap rowMap = new HashMap();
    private ArrayList propertyList;
    private HashMap propertyIdMap;
    private Map propIdDescriptorMap;
    private Map extensionDefnValueMap = new HashMap();
    private IPropertySourceProvider propertySourceProvider;
    private IPropertyDescriptor[] properties = new IPropertyDescriptor[0];
    private TableViewer tableViewer;
    private boolean columnsBuilt = false;
    private boolean supportsDescription = true;
    private String eObject;
    private ArrayList tableColumns;

    public static String getPropertyLabel(String theProperty) {
        if (theProperty.equals(DESCRIPTION_KEY)) {
            return DESCRIPTION_KEY;
        }
        if (theProperty.equals(LOCATION_KEY)) {
            return LOCATION_KEY;
        }
        return theProperty;
    }

    public ModelObjectTableModel(String eObject, ArrayList instanceList, boolean supportsDescription) {
        UiPlugin.getDefault().getEObjectPropertiesOrderPreferences().addEObjectPropertiesOrderPreferencesListener(this);
        this.eObject = eObject;
        this.instanceList = instanceList;
        this.supportsDescription = supportsDescription;
        this.refreshProperties();
        this.buildPropertyIdMap();
    }

    public boolean canView() {
        return this.properties.length > 0;
    }

    public Object getPropertyId(String property) {
        if (this.extensionDefnValueMap.containsKey(property)) {
            return this.extensionDefnValueMap.get(property);
        }
        return property;
    }

    public Object getPropertyIdAtIndex(int index) {
        return this.propertyIdMap.get(this.propertyList.get(index));
    }

    private void buildRowList() {
        this.rowList = new ArrayList(this.instanceList.size());
        int i = 0;
        while (i < this.instanceList.size()) {
            ModelRowElement row = new ModelRowElement((EObject)this.instanceList.get(i), this);
            this.rowList.add(row);
            this.rowMap.put(this.instanceList.get(i), row);
            ++i;
        }
    }

    private void buildPropertyIdMap() {
        this.propertyList = new ArrayList(this.properties.length);
        this.propertyIdMap = new HashMap();
        this.propIdDescriptorMap = new HashMap();
        this.propertyIdMap.put(LOCATION_KEY, LOCATION_KEY);
        this.propertyList.add(LOCATION_KEY);
        int size = this.properties.length;
        int i = 0;
        while (i < size) {
            this.propertyIdMap.put(this.properties[i].getDisplayName(), this.properties[i].getId());
            this.propertyList.add(this.properties[i].getDisplayName());
            this.propIdDescriptorMap.put(this.properties[i].getId(), this.properties[i]);
            ++i;
        }
        if (this.supportsDescription) {
            this.propertyIdMap.put(DESCRIPTION_KEY, DESCRIPTION_KEY);
            this.propertyList.add(DESCRIPTION_KEY);
        }
        ArrayList sortedColumns = UiPlugin.getDefault().getEObjectPropertiesOrderPreferences().getOrderedPropertyList(this.eObject);
        ArrayList<String> newList = new ArrayList<String>();
        ArrayList<String> hiddenList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < sortedColumns.size()) {
            PropertyOrder columnOrder = (PropertyOrder)sortedColumns.get(i2);
            if (this.propertyList.contains(columnOrder.getName())) {
                if (columnOrder.isVisible()) {
                    newList.add(columnOrder.getName());
                } else {
                    hiddenList.add(columnOrder.getName());
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.propertyList.size()) {
            if (!newList.contains(this.propertyList.get(i2)) && !hiddenList.contains(this.propertyList.get(i2))) {
                newList.add((String)this.propertyList.get(i2));
            }
            ++i2;
        }
        if (newList.size() == 0) {
            newList.add((String)this.propertyList.get(0));
        }
        this.propertyList = newList;
    }

    public void refreshProperties() {
        if (this.instanceList.size() > 0) {
            IPropertySource propertySource = this.getPropertySource((EObject)this.instanceList.get(0));
            this.properties = propertySource.getPropertyDescriptors();
            int i = 0;
            while (i < this.properties.length) {
                if (this.properties[i] instanceof ModelObjectPropertyDescriptor) {
                    ((ModelObjectPropertyDescriptor)this.properties[i]).setShowReadOnlyDialog(false);
                    ((ModelObjectPropertyDescriptor)this.properties[i]).setLazyLoadValues(true);
                } else if (this.properties[i] instanceof ExtensionPropertyDescriptor) {
                    ((ExtensionPropertyDescriptor)this.properties[i]).setShowReadOnlyDialog(false);
                }
                ++i;
            }
        }
    }

    public boolean isLocationColumn(Object object) {
        return LOCATION_KEY.equals(object);
    }

    public boolean isDescriptionColumn(Object object) {
        return DESCRIPTION_KEY.equals(object);
    }

    public IPropertyDescriptor getPropertyDescriptor(Object thePropertyId) {
        return (IPropertyDescriptor)this.propIdDescriptorMap.get(thePropertyId);
    }

    public void setTableViewer(TableViewer tableViewer) {
        if (tableViewer == null || tableViewer.getTable().isDisposed()) {
            return;
        }
        this.tableViewer = tableViewer;
        ((Table)this.tableViewer.getControl()).addDisposeListener((DisposeListener)this);
    }

    public void buildColumns() {
        if (!this.columnsBuilt && this.tableViewer != null) {
            this.buildColumns(this.tableViewer.getTable());
            TableViewerSorter sorter = (TableViewerSorter)this.tableViewer.getSorter();
            if (sorter != null) {
                sorter.setSortListener();
            }
        }
    }

    private void buildColumns(Table table) {
        if (!this.columnsBuilt) {
            this.columnsBuilt = true;
            if (this.tableColumns != null && this.tableColumns.size() > 0) {
                int i = this.tableColumns.size() - 1;
                while (i > -1) {
                    TableColumn column = (TableColumn)this.tableColumns.get(i);
                    column.dispose();
                    --i;
                }
            }
            this.tableColumns = new ArrayList();
            if (this.propertyList.size() > 0) {
                this.buildRowList();
                String[] columnProperties = new String[this.propertyList.size()];
                this.extensionDefnValueMap.clear();
                int i = 0;
                while (i < this.propertyList.size()) {
                    TableColumn column = new TableColumn(table, 0);
                    this.tableColumns.add(column);
                    String columnHeader = (String)this.propertyList.get(i);
                    Object pId = this.getPropertyIdAtIndex(i);
                    if (pId instanceof ModelExtensionPropertyDescriptor) {
                        ModelExtensionPropertyDescriptor pDescriptor = (ModelExtensionPropertyDescriptor)pId;
                        pId = pDescriptor.getPropDefnId();
                        this.extensionDefnValueMap.put(pId, pDescriptor);
                    }
                    columnProperties[i] = (String)pId;
                    column.setText(columnHeader);
                    column.setWidth(80);
                    ++i;
                }
                this.tableViewer.setColumnProperties(columnProperties);
                this.rebuildColumnEditors(table);
            }
            boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, null, null);
            boolean succeeded = false;
            try {
                this.tableViewer.setInput((Object)this);
                succeeded = true;
            }
            finally {
                if (startedTxn) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public CellEditor getCellEditor(int theColumn) {
        this.buildColumns();
        return this.tableViewer.getCellEditors()[theColumn];
    }

    public Object[] getElements() {
        this.buildColumns();
        return this.rowList.toArray();
    }

    public IPropertySource getPropertySource(EObject modelObject) {
        if (this.propertySourceProvider == null) {
            this.propertySourceProvider = ModelUtilities.getPropertySourceProvider();
        }
        return this.propertySourceProvider.getPropertySource((Object)modelObject);
    }

    public ModelRowElement getRowElementForInstance(EObject instance) {
        this.buildColumns();
        return (ModelRowElement)this.rowMap.get(instance);
    }

    public void addRows(Collection eObjects) {
        this.buildColumns();
        if (this.tableViewer == null || this.tableViewer.getTable().isDisposed()) {
            return;
        }
        for (EObject eObject : eObjects) {
            this.instanceList.add(eObject);
            ModelRowElement row = new ModelRowElement(eObject, this);
            this.rowList.add(row);
            this.rowMap.put(eObject, row);
            this.tableViewer.add((Object)row);
        }
    }

    public void removeRows(Collection eObjects) {
        this.buildColumns();
        if (this.tableViewer == null || this.tableViewer.getTable().isDisposed()) {
            return;
        }
        for (EObject eObject : eObjects) {
            this.instanceList.remove(eObject);
            ModelRowElement row = (ModelRowElement)this.rowMap.get(eObject);
            if (row == null) continue;
            this.rowList.remove(row);
            this.rowMap.remove(eObject);
            this.tableViewer.remove((Object)row);
        }
    }

    public void setValueAt(Object theNewValue, int theRow, int theColumn) {
        ICellEditorValidator validator;
        this.buildColumns();
        CellEditor editor = this.getCellEditor(theColumn);
        if (editor != null && ((validator = editor.getValidator()) == null || validator.isValid(theNewValue) == null)) {
            ModelRowElement rowElement = (ModelRowElement)this.rowList.get(theRow);
            Object propID = this.getPropertyIdAtIndex(theColumn);
            if (propID instanceof String) {
                rowElement.setValue((String)propID, theNewValue);
            } else if (propID instanceof ExtensionPropertyDescriptor) {
                rowElement.setValue((ExtensionPropertyDescriptor)propID, theNewValue);
            }
            this.tableViewer.refresh((Object)rowElement);
        }
    }

    @Override
    public void propertiesChanged(List eObjects) {
        if (eObjects == null || eObjects.contains(this.eObject)) {
            this.columnsBuilt = false;
            this.buildPropertyIdMap();
            this.buildColumns();
        }
    }

    public void rebuildColumnEditors(Table table) {
        int size = this.propertyList.size();
        if (size > 0) {
            CellEditor[] cellEditors = new CellEditor[size];
            int i = 0;
            while (i < size) {
                cellEditors[i] = this.isLocationColumn(this.propertyList.get(i)) ? new TextCellEditor((Composite)table) : (this.isDescriptionColumn(this.propertyList.get(i)) ? new TextCellEditor((Composite)table) : ((IPropertyDescriptor)this.propIdDescriptorMap.get(this.propertyIdMap.get(this.propertyList.get(i)))).createPropertyEditor((Composite)table));
                ++i;
            }
            this.tableViewer.setCellEditors(cellEditors);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        UiPlugin.getDefault().getEObjectPropertiesOrderPreferences().removeEObjectPropertiesOrderPreferencesListener(this);
    }
}

