/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.ui.IWorkingSet;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.search.IModelObjectMatch;

public final class SearchPageUtil
implements UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(SearchPageUtil.class);
    public static final String ONE_MATCH_MSG = Util.getString(String.valueOf(PREFIX) + "msg.searchOneMatch", new Object[0]);
    public static final String MULTIPLE_MATCHES_MSG = Util.getString(String.valueOf(PREFIX) + "msg.searchMultipleMatches", new Object[0]);

    private SearchPageUtil() {
    }

    public static IResource getResource(String theObjectUri) {
        int index = theObjectUri.indexOf(35);
        String uri = index == -1 ? theObjectUri : theObjectUri.substring(0, index);
        return WorkspaceResourceFinderUtil.findIResource((String)uri);
    }

    public static List getSelectedModelWorkspaceItems(ISearchPageContainer theSearchContainer) {
        return SearchPageUtil.getModelWorkspaceItemSelection(theSearchContainer).toList();
    }

    public static IStructuredSelection getModelWorkspaceItemSelection(ISearchPageContainer theSearchContainer) {
        StructuredSelection result = null;
        ISelection tempSelection = theSearchContainer.getSelection();
        if (tempSelection == null || tempSelection.isEmpty() || !(tempSelection instanceof IStructuredSelection)) {
            result = StructuredSelection.EMPTY;
        } else {
            ArrayList<ModelWorkspaceItem> validSelections = new ArrayList<ModelWorkspaceItem>(((IStructuredSelection)tempSelection).size());
            Iterator itr = ((IStructuredSelection)tempSelection).iterator();
            while (itr.hasNext()) {
                ModelWorkspaceItem selection = SearchPageUtil.getModelWorkspaceResource(itr.next());
                if (selection == null) continue;
                validSelections.add(selection);
            }
            result = validSelections.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection(validSelections);
        }
        return result;
    }

    public static List getWorkingSetWorkspaceItems(ISearchPageContainer theSearchContainer) {
        IWorkingSet[] workingSets = theSearchContainer.getSelectedWorkingSets();
        HashSet<ModelWorkspaceItem> allElements = new HashSet<ModelWorkspaceItem>();
        if (workingSets != null) {
            int i = 0;
            while (i < workingSets.length) {
                IAdaptable[] elements = workingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    ModelWorkspaceItem item = SearchPageUtil.getModelWorkspaceResource(elements[j]);
                    if (item != null) {
                        allElements.add(item);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (allElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(allElements);
    }

    public static ModelWorkspaceItem getModelWorkspaceResource(Object theObject) {
        ModelWorkspaceItem result = null;
        if (theObject != null) {
            if (theObject instanceof ModelWorkspaceItem) {
                result = (ModelWorkspaceItem)theObject;
            } else if (theObject instanceof IResource) {
                try {
                    result = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem((IResource)theObject);
                }
                catch (ModelWorkspaceException theException) {
                    Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "msg.resourceProblem", new Object[]{theObject, theObject.getClass()}));
                }
            } else if (theObject instanceof IAdaptable) {
                result = SearchPageUtil.getModelWorkspaceResource(((IAdaptable)theObject).getAdapter(IResource.class));
            }
        }
        return result;
    }

    public static List getModelWorkspaceScope(ISearchPageContainer theSearchContainer) {
        List<Object> result = null;
        switch (theSearchContainer.getSelectedScope()) {
            case 0: {
                result = Arrays.asList(ModelerCore.getModelWorkspace());
                break;
            }
            case 1: {
                result = SearchPageUtil.getSelectedModelWorkspaceItems(theSearchContainer);
                break;
            }
            case 2: {
                result = SearchPageUtil.getWorkingSetWorkspaceItems(theSearchContainer);
                break;
            }
            default: {
                CoreArgCheck.isNotNull(result);
            }
        }
        return result;
    }

    public static List getEObjectsFromSearchSelection(ISelection theSelection) {
        List objs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        HashSet<EObject> eObjs = new HashSet<EObject>();
        boolean isSearchResult = false;
        if (objs != null && !objs.isEmpty()) {
            Object nextObj2 = null;
            for (Object nextObj2 : objs) {
                if (!(nextObj2 instanceof IModelObjectMatch)) continue;
                isSearchResult = true;
                EObject eObj = ((IModelObjectMatch)nextObj2).getEObject();
                if (eObj == null) continue;
                eObjs.add(eObj);
            }
        }
        if (!isSearchResult) {
            return null;
        }
        return new ArrayList(eObjs);
    }
}

