/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class FindObjectLabelProvider
extends LabelProvider {
    public static final int OBJECT = 0;
    public static final int CONTAINER = 1;
    private int iStyle = 0;

    public FindObjectLabelProvider(int iStyle) {
        this.iStyle = iStyle;
    }

    public String getText(Object element) {
        String sText = " Unknown ";
        if (element instanceof String) {
            sText = (String)element;
        } else if (element instanceof ResourceObjectRecord) {
            ResourceObjectRecord ror = (ResourceObjectRecord)element;
            if (this.iStyle == 0) {
                sText = ror.getName();
            } else if (this.iStyle == 1) {
                EObject eo = this.getEObjectForRecord(ror);
                if (eo != null) {
                    IPath path = ModelerCore.getModelEditor().getModelRelativePath(eo);
                    sText = String.valueOf(ror.getResourcePath()) + path.makeAbsolute().toString();
                } else {
                    sText = ror.getResourcePath();
                }
            }
        }
        return sText;
    }

    public Image getImage(Object element) {
        Image imgResult = null;
        if (element instanceof ResourceObjectRecord) {
            ResourceObjectRecord ror = (ResourceObjectRecord)element;
            try {
                Container container = ModelerCore.getModelContainer();
                URI theUri = URI.createURI((String)ror.getMetaclassURI());
                EObject eoClass = container.getEObject(theUri, true);
                if (eoClass != null && !(eoClass instanceof EClass)) {
                    eoClass = eoClass.eClass();
                }
                if (eoClass != null) {
                    imgResult = ModelObjectUtilities.getImage((EClass)eoClass);
                }
            }
            catch (Exception ce) {
                ModelerCore.Util.log(4, (Throwable)ce, ce.getMessage());
            }
        }
        return imgResult;
    }

    public EObject getEObjectForRecord(ResourceObjectRecord ror) {
        EObject eObj = null;
        try {
            URI uri = URI.createURI((String)ror.getObjectURI());
            if (uri.fragment() != null) {
                eObj = ModelerCore.getModelContainer().getEObject(uri, true);
            }
        }
        catch (CoreException ce) {
            ModelerCore.Util.log(4, (Throwable)ce, ce.getMessage());
        }
        return eObj;
    }
}

