/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.rename.RenameResourceRefactoring;

public class RenameResourceDescriptor
extends RefactoringDescriptor {
    static final String RESOURCE_PATH_KEY = "ResourcePathKey";
    static final String RENAME_PATH_KEY = "RenameKey";
    static final String REFACTORING_ID = RenameResourceDescriptor.class.getPackage().getName();
    private static final String UNAMED_DESCRIPTOR = "Unamed_Descriptor";
    private String newName;
    private IPath resourcePath;

    public RenameResourceDescriptor() {
        this(null, UNAMED_DESCRIPTOR, null);
    }

    public RenameResourceDescriptor(String project, String description, String comment) {
        super(REFACTORING_ID, project, description, comment, 6);
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        CoreArgCheck.isNotNull((Object)newName);
        this.newName = newName;
    }

    public IPath getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePathToRename(IPath resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setResourceToRename(IResource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        this.resourcePath = resource.getFullPath();
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        String newName;
        IResource resource;
        block7: {
            block6: {
                IPath resourcePath;
                block5: {
                    try {
                        resourcePath = this.getResourcePath();
                        if (resourcePath != null) break block5;
                        status.addFatalError(RefactorResourcesUtils.getString("RenameRefactoring.errorPathNotSet", new Object[0]));
                        return null;
                    }
                    catch (Exception ex) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)ex.getMessage()));
                        throw new CoreException((IStatus)new Status(4, REFACTORING_ID, ex.getMessage()));
                    }
                }
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath);
                if (resource != null && resource.exists()) break block6;
                status.addFatalError(RefactorResourcesUtils.getString("RenameRefactoring.errorResourceNotExisting", BasicElementLabels.getPathLabel((IPath)resourcePath, (boolean)false)));
                return null;
            }
            newName = this.getNewName();
            if (newName != null && newName.length() != 0) break block7;
            status.addFatalError(RefactorResourcesUtils.getString("RenameRefactoring.errorNameNotDefined", new Object[0]));
            return null;
        }
        RenameResourceRefactoring refactoring = new RenameResourceRefactoring(resource);
        refactoring.setNewResourceName(newName);
        return refactoring;
    }
}

