/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.rename;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.teiid.designer.ui.refactor.rename.RenameResourceDescriptor;

public class RenameResourceContribution
extends RefactoringContribution {
    private static final String ATTRIBUTE_INPUT = "input";
    private static final String ATTRIBUTE_NAME = "name";

    private IPath handleToResourcePath(String project, String handle) {
        IPath path = Path.fromPortableString((String)handle);
        if (project != null && project.length() > 0 && !path.isAbsolute()) {
            return new Path(project).append(path).makeAbsolute();
        }
        return path;
    }

    private String resourcePathToHandle(String project, IPath resourcePath) {
        if (project != null && project.length() > 0 && resourcePath.segmentCount() != 1 && resourcePath.segment(0).equals(project)) {
            return resourcePath.removeFirstSegments(1).toPortableString();
        }
        return resourcePath.toPortableString();
    }

    public RefactoringDescriptor createDescriptor() {
        return new RenameResourceDescriptor();
    }

    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map arguments, int flags) throws IllegalArgumentException {
        String pathString = (String)arguments.get(ATTRIBUTE_INPUT);
        String newName = (String)arguments.get(ATTRIBUTE_NAME);
        if (pathString != null && newName != null) {
            IPath path = this.handleToResourcePath(project, pathString);
            RenameResourceDescriptor descriptor = new RenameResourceDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setNewName(newName);
            descriptor.setResourcePathToRename(path);
            return descriptor;
        }
        throw new IllegalArgumentException("Can not restore RenameResourceDescriptor from map");
    }

    public Map retrieveArgumentMap(RefactoringDescriptor descriptor) {
        if (!(descriptor instanceof RenameResourceDescriptor)) {
            return null;
        }
        RenameResourceDescriptor renameDescriptor = (RenameResourceDescriptor)descriptor;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ATTRIBUTE_INPUT, this.resourcePathToHandle(descriptor.getProject(), renameDescriptor.getResourcePath()));
        map.put(ATTRIBUTE_NAME, renameDescriptor.getNewName());
        return map;
    }
}

