/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.teiid.designer.ui.refactor.delete.DeleteResourcesDescriptor;

public class DeleteResourcesContribution
extends RefactoringContribution {
    private static final String ATTRIBUTE_NUMBER_OF_RESOURCES = "resources";
    private static final String ATTRIBUTE_ELEMENT = "element";
    private static final String ATTRIBUTE_DELETE_CONTENTS = "deleteContents";

    private IPath handleToResourcePath(String project, String handle) {
        IPath path = Path.fromPortableString((String)handle);
        if (project != null && project.length() > 0 && !path.isAbsolute()) {
            return new Path(project).append(path).makeAbsolute();
        }
        return path;
    }

    private String resourcePathToHandle(String project, IPath resourcePath) {
        if (project != null && project.length() > 0 && resourcePath.segmentCount() != 1 && resourcePath.segment(0).equals(project)) {
            return resourcePath.removeFirstSegments(1).toPortableString();
        }
        return resourcePath.toPortableString();
    }

    public RefactoringDescriptor createDescriptor() {
        return new DeleteResourcesDescriptor();
    }

    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map arguments, int flags) throws IllegalArgumentException {
        try {
            int numResources = Integer.parseInt((String)arguments.get(ATTRIBUTE_NUMBER_OF_RESOURCES));
            if (numResources < 0 || numResources > 100000) {
                throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map, number of moved elements invalid");
            }
            ArrayList<IPath> resourcePaths = new ArrayList<IPath>(numResources);
            int i = 0;
            while (i < numResources) {
                String resource = (String)arguments.get(ATTRIBUTE_ELEMENT + String.valueOf(i + 1));
                if (resource == null) {
                    throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map, resource missing");
                }
                resourcePaths.add(this.handleToResourcePath(project, resource));
                ++i;
            }
            String del = (String)arguments.get(ATTRIBUTE_DELETE_CONTENTS);
            DeleteResourcesDescriptor descriptor = new DeleteResourcesDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setResourcePathsToDelete(resourcePaths);
            descriptor.setDeleteContents(Boolean.TRUE.equals(del));
            return descriptor;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can not restore DeleteResourceDescriptor from map");
        }
    }

    public Map retrieveArgumentMap(RefactoringDescriptor descriptor) {
        if (!(descriptor instanceof DeleteResourcesDescriptor)) {
            return null;
        }
        DeleteResourcesDescriptor deleteDescriptor = (DeleteResourcesDescriptor)descriptor;
        HashMap<String, String> map = new HashMap<String, String>();
        Collection<IPath> paths = deleteDescriptor.getResourcePaths();
        String project = deleteDescriptor.getProject();
        int i = 0;
        map.put(ATTRIBUTE_NUMBER_OF_RESOURCES, String.valueOf(paths.size()));
        for (IPath path : paths) {
            map.put(ATTRIBUTE_ELEMENT + (i + 1), this.resourcePathToHandle(project, path));
            ++i;
        }
        map.put(ATTRIBUTE_DELETE_CONTENTS, deleteDescriptor.isDeleteContents() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        return map;
    }
}

