/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.refactor.IRefactorModelHandler;
import org.teiid.designer.core.refactor.ModelResourceCollectorVisitor;
import org.teiid.designer.core.refactor.PathPair;
import org.teiid.designer.core.refactor.RefactorModelExtensionManager;
import org.teiid.designer.core.refactor.RelatedResourceFinder;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RefactorResourcesUtils {
    private static final String PARENT_DIRECTORY = "..";

    public static String getString(String key, Object ... parameters) {
        return UiConstants.Util.getString(key, parameters);
    }

    private static void createPathBuffer(String[] pathArray, int startingIndex, StringBuffer pathBuffer) {
        int i = startingIndex;
        while (i < pathArray.length) {
            if (pathArray[i].length() != 0) {
                pathBuffer.append(pathArray[i]);
                if (i + 1 < pathArray.length) {
                    pathBuffer.append(File.separator);
                }
            }
            ++i;
        }
    }

    private static StringBuffer createPathBuffer(String[] pathArray, int startingIndex) {
        StringBuffer pathBuffer = new StringBuffer();
        RefactorResourcesUtils.createPathBuffer(pathArray, startingIndex, pathBuffer);
        return pathBuffer;
    }

    private static void appendParentSymbol(StringBuffer buffer, int number) {
        int i = 0;
        while (i < number) {
            buffer.append(PARENT_DIRECTORY);
            buffer.append(File.separator);
            ++i;
        }
    }

    public static PathPair getRelativePath(String baseDirectory, PathPair absPair) throws IOException {
        String source = absPair.getSourcePath();
        String target = absPair.getTargetPath();
        String separator = Pattern.quote(File.separator);
        String[] barr = baseDirectory.split(separator);
        String[] sarr = source.split(separator);
        String[] tarr = target.split(separator);
        if (barr[0].equals(sarr[0]) && sarr[0].equals(tarr[0])) {
            StringBuffer baseBuffer = RefactorResourcesUtils.createPathBuffer(barr, 1);
            StringBuffer srcBuffer = RefactorResourcesUtils.createPathBuffer(sarr, 1);
            StringBuffer tgtBuffer = RefactorResourcesUtils.createPathBuffer(tarr, 1);
            return RefactorResourcesUtils.getRelativePath(baseBuffer.toString(), new PathPair(srcBuffer.toString(), tgtBuffer.toString()));
        }
        boolean RENAME = false;
        if (sarr.length == tarr.length && !sarr[sarr.length - 1].equals(tarr[tarr.length - 1])) {
            RENAME = true;
            int i = 0;
            while (i < sarr.length - 1) {
                if (!sarr[i].equals(tarr[i])) {
                    RENAME = false;
                    break;
                }
                ++i;
            }
        }
        StringBuffer src = new StringBuffer();
        StringBuffer tgt = new StringBuffer();
        if (baseDirectory.length() == 0) {
            RefactorResourcesUtils.createPathBuffer(sarr, 0, src);
            RefactorResourcesUtils.createPathBuffer(tarr, 0, tgt);
        } else if (barr[0].equals(sarr[0])) {
            RefactorResourcesUtils.appendParentSymbol(src, barr.length - 1);
            RefactorResourcesUtils.createPathBuffer(sarr, 1, src);
            if (RENAME) {
                RefactorResourcesUtils.appendParentSymbol(tgt, barr.length - 1);
                RefactorResourcesUtils.createPathBuffer(tarr, 1, tgt);
            } else {
                RefactorResourcesUtils.appendParentSymbol(tgt, barr.length);
                RefactorResourcesUtils.createPathBuffer(tarr, 0, tgt);
            }
        } else if (barr[0].equals(tarr[0])) {
            RefactorResourcesUtils.appendParentSymbol(src, barr.length);
            RefactorResourcesUtils.createPathBuffer(sarr, 0, src);
            if (RENAME) {
                RefactorResourcesUtils.appendParentSymbol(tgt, barr.length);
                RefactorResourcesUtils.createPathBuffer(tarr, 1, tgt);
            } else {
                RefactorResourcesUtils.appendParentSymbol(tgt, barr.length - 1);
                RefactorResourcesUtils.createPathBuffer(tarr, 1, tgt);
            }
        } else {
            RefactorResourcesUtils.appendParentSymbol(src, barr.length);
            RefactorResourcesUtils.createPathBuffer(sarr, 0, src);
            RefactorResourcesUtils.appendParentSymbol(tgt, barr.length);
            RefactorResourcesUtils.createPathBuffer(tarr, 0, tgt);
        }
        return new PathPair(src.toString(), tgt.toString());
    }

    private static void calculateResourceMoves(IResource resource, String destination, Collection<PathPair> pathPairs, Option ... options) throws Exception {
        if (!(resource instanceof IFolder) && !(resource instanceof IFile)) {
            return;
        }
        List<Object> optionList = Collections.emptyList();
        if (options != null && options.length > 0) {
            optionList = Arrays.asList(options);
        }
        String resourcePath = ModelUtil.getLocation((IResource)resource).makeAbsolute().toOSString();
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            if (!optionList.contains((Object)Option.EXCLUDE_FOLDERS)) {
                pathPairs.add(new PathPair(resourcePath, String.valueOf(destination) + '/' + resource.getName()));
            }
            IResource[] iResourceArray = folder.members(false);
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource subResource = iResourceArray[n2];
                RefactorResourcesUtils.calculateResourceMoves(subResource, String.valueOf(destination) + '/' + folder.getName(), pathPairs, new Option[0]);
                ++n2;
            }
        } else {
            pathPairs.add(new PathPair(resourcePath, String.valueOf(destination) + '/' + resource.getName()));
        }
    }

    private static void calculateResourceMoves(List<IResource> resources, String destination, Collection<PathPair> pathPairs, Option ... options) throws Exception {
        for (IResource resource : resources) {
            RefactorResourcesUtils.calculateResourceMoves(resource, destination, pathPairs, options);
        }
    }

    public static Set<PathPair> calculateResourceMoves(List<IResource> resources, String destination, Option ... options) throws Exception {
        HashSet<PathPair> pathPairs = new HashSet<PathPair>();
        RefactorResourcesUtils.calculateResourceMoves(resources, destination, pathPairs, options);
        return pathPairs;
    }

    private static TextEdit setRootEdit(TextFileChange textFileChange) {
        if (textFileChange.getEdit() != null) {
            return textFileChange.getEdit();
        }
        MultiTextEdit edit = new MultiTextEdit();
        textFileChange.setEdit((TextEdit)edit);
        return edit;
    }

    public static TextFileChange calculateTextChanges(IFile file, Collection<PathPair> pathPairs) throws Exception {
        File nativeFile = ModelUtil.getLocation((IResource)file).makeAbsolute().toFile();
        if (nativeFile == null || !nativeFile.exists()) {
            throw new Exception(RefactorResourcesUtils.getString("ResourcesRefactoring.fileNotFoundError", file.getFullPath()));
        }
        TextFileChange textFileChange = new TextFileChange(file.getName(), file);
        TextEdit fileChangeRootEdit = RefactorResourcesUtils.setRootEdit(textFileChange);
        if (pathPairs.isEmpty()) {
            return textFileChange;
        }
        BufferedReader reader = null;
        int docOffset = 0;
        try {
            String line;
            reader = new BufferedReader(new FileReader(nativeFile));
            while ((line = reader.readLine()) != null) {
                for (PathPair pathPair : pathPairs) {
                    int lineOffset;
                    if (pathPair.getSourcePath().equals(pathPair.getTargetPath()) || (lineOffset = line.indexOf(pathPair.getSourcePath())) < 0) continue;
                    int offset = docOffset + lineOffset;
                    ReplaceEdit edit = new ReplaceEdit(offset, pathPair.getSourcePath().length(), pathPair.getTargetPath());
                    fileChangeRootEdit.addChild((TextEdit)edit);
                }
                docOffset += line.length() + 1;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return textFileChange;
    }

    public static Set<PathPair> calculateImportChanges(IFile file, String destination, Set<IResource> refactorResources) throws Exception {
        File nativeFile = ModelUtil.getLocation((IResource)file).makeAbsolute().toFile();
        if (nativeFile == null || !nativeFile.exists()) {
            throw new Exception(RefactorResourcesUtils.getString("ResourcesRefactoring.fileNotFoundError", file.getFullPath()));
        }
        HashSet<String> refactorResourcePaths = new HashSet<String>();
        for (IResource resource : refactorResources) {
            File nativeRes = ModelUtil.getLocation((IResource)resource).makeAbsolute().toFile();
            refactorResourcePaths.add(nativeRes.getCanonicalPath());
        }
        HashSet<PathPair> importPairs = new HashSet<PathPair>();
        File parentFolder = nativeFile.getParentFile();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document xmlDocument = dBuilder.parse(nativeFile);
        NodeList modelList = xmlDocument.getElementsByTagName("modelImports");
        int i = 0;
        while (i < modelList.getLength()) {
            PathPair newRelativePair;
            String newRelativeLocation;
            File absLocationFile;
            String absLocation;
            String relativeLocation;
            Element element;
            Node modelNode = modelList.item(i);
            if (!(modelNode.getNodeType() != 1 || !(element = (Element)modelNode).hasAttribute("modelLocation") || (relativeLocation = element.getAttribute("modelLocation")).startsWith("http:") || relativeLocation.startsWith("https:") || refactorResourcePaths.contains(absLocation = (absLocationFile = new File(parentFolder, relativeLocation)).getCanonicalPath()) || relativeLocation.equals(newRelativeLocation = (newRelativePair = RefactorResourcesUtils.getRelativePath(destination, new PathPair(absLocation, absLocation))).getSourcePath()))) {
                importPairs.add(new PathPair(relativeLocation, newRelativeLocation));
            }
            ++i;
        }
        return importPairs;
    }

    public static void calculateSQLChanges(IFile file, PathPair pathPair, TextFileChange textFileChange) throws Exception {
        String targetName;
        if (!ModelUtil.isModelFile((IResource)file)) {
            return;
        }
        Path sourcePath = new Path(pathPair.getSourcePath());
        Path targetPath = new Path(pathPair.getTargetPath());
        String sourceName = sourcePath.removeFileExtension().lastSegment();
        if (sourceName.equals(targetName = targetPath.removeFileExtension().lastSegment())) {
            return;
        }
        File nativeFile = ModelUtil.getLocation((IResource)file).makeAbsolute().toFile();
        if (nativeFile == null || !nativeFile.exists()) {
            throw new Exception(RefactorResourcesUtils.getString("ResourcesRefactoring.fileNotFoundError", file.getFullPath()));
        }
        TextEdit fileChangeRootEdit = RefactorResourcesUtils.setRootEdit(textFileChange);
        BufferedReader reader = null;
        int docOffset = 0;
        char[] prefixChars = new char[]{' ', ',', ';', '\t', '\n', '('};
        try {
            String line;
            reader = new BufferedReader(new FileReader(nativeFile));
            while ((line = reader.readLine()) != null) {
                if (line.contains("Sql=")) {
                    char[] cArray = prefixChars;
                    int n = prefixChars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char prefixChar = cArray[n2];
                        String toReplace = String.valueOf(prefixChar) + sourceName + '.';
                        int lineOffset = line.indexOf(toReplace);
                        while (lineOffset >= 0) {
                            if (lineOffset >= 0) {
                                int offset = docOffset + lineOffset + 1;
                                ReplaceEdit edit = new ReplaceEdit(offset, sourceName.length(), targetName);
                                fileChangeRootEdit.addChild((TextEdit)edit);
                            }
                            lineOffset = line.indexOf(toReplace, lineOffset + 1);
                        }
                        ++n2;
                    }
                }
                docOffset += line.length() + 1;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static boolean isClosedProject(IResource resource) {
        return resource instanceof IProject && !((IProject)resource).isOpen();
    }

    public static void unloadModelResource(IResource resource) throws CoreException {
        if (RefactorResourcesUtils.isClosedProject(resource)) {
            return;
        }
        ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
        resource.accept((IResourceVisitor)visitor);
        for (ModelResource mResource : visitor.getModelResources()) {
            mResource.unload();
            mResource.close();
            if (!(mResource instanceof ModelResourceImpl)) continue;
            ((ModelResourceImpl)mResource).removeEmfResource();
        }
        for (IResource tmpResource : visitor.getResources()) {
            String searchIndexFileName;
            File searchIndexFile;
            if (!ModelUtil.isModelFile((IResource)tmpResource) || tmpResource.getLocation() == null) continue;
            String runtimeIndexFileName = IndexUtil.getRuntimeIndexFileName((IResource)tmpResource);
            File runtimeIndexFile = new File(IndexUtil.INDEX_PATH, runtimeIndexFileName);
            if (!runtimeIndexFile.delete()) {
                runtimeIndexFile.deleteOnExit();
            }
            if ((searchIndexFile = new File(IndexUtil.INDEX_PATH, searchIndexFileName = IndexUtil.getSearchIndexFileName((IResource)tmpResource))).delete()) continue;
            searchIndexFile.deleteOnExit();
        }
    }

    public static int getResourceTypes(List<IResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return 0;
        }
        int types = 0;
        for (IResource resource : resources) {
            types |= resource.getType();
        }
        return types;
    }

    public static boolean containsOnlyNonProjects(List<IResource> resources) {
        int types = RefactorResourcesUtils.getResourceTypes(resources);
        if (types == 0) {
            return false;
        }
        return (types & 4) == 0;
    }

    public static boolean containsOnlyProjects(List<IResource> resources) {
        int types = RefactorResourcesUtils.getResourceTypes(resources);
        return types == 4;
    }

    public static boolean containsLinkedResource(List<IResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return false;
        }
        for (IResource resource : resources) {
            if (resource == null || !resource.isLinked()) continue;
            return true;
        }
        return false;
    }

    private static void checkSavedFile(IFile file, RefactoringStatus status) {
        if (!file.exists()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("ResourcesRefactoring.resourceNoExistError", file.getName())));
            return;
        }
        IEditorPart fileEditor = UiUtil.getEditorForFile((IFile)file, (boolean)false);
        if (fileEditor != null && fileEditor.isDirty()) {
            status.addFatalError(RefactorResourcesUtils.getString("ResourcesRefactoring.unsavedFile", file.getFullPath()));
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null && buffer.isDirty()) {
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                status.addWarning(RefactorResourcesUtils.getString("ResourcesRefactoring.unsavedFile", file.getFullPath()));
            } else {
                status.addFatalError(RefactorResourcesUtils.getString("ResourcesRefactoring.unsavedFile", file.getFullPath()));
            }
        }
    }

    public static void checkSavedResource(IResource resource, final RefactoringStatus status) {
        if (RefactorResourcesUtils.isClosedProject(resource)) {
            return;
        }
        try {
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource visitedResource) {
                    if (visitedResource instanceof IFile) {
                        RefactorResourcesUtils.checkSavedFile((IFile)visitedResource, status);
                    }
                    return true;
                }
            }, 2, false);
        }
        catch (CoreException ex) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)ex.getMessage()));
        }
    }

    private static void checkOpenEditors(IFile file, RefactoringStatus status) {
        if (!file.exists()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("ResourcesRefactoring.resourceNoExistError", file.getName())));
            return;
        }
        IEditorPart fileEditor = UiUtil.getEditorForFile((IFile)file, (boolean)false);
        if (fileEditor != null) {
            status.addFatalError(RefactorResourcesUtils.getString("ResourcesRefactoring.openEditorError", file.getFullPath()));
            return;
        }
    }

    public static void checkOpenEditors(IResource resource, final RefactoringStatus status) {
        if (RefactorResourcesUtils.isClosedProject(resource)) {
            return;
        }
        try {
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource visitedResource) {
                    if (visitedResource instanceof IFile) {
                        RefactorResourcesUtils.checkOpenEditors((IFile)visitedResource, status);
                    }
                    return true;
                }
            }, 2, false);
        }
        catch (CoreException ex) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)ex.getMessage()));
        }
    }

    public static void checkResourceExists(IResource resource, RefactoringStatus status) {
        if (!resource.exists()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("ResourcesRefactoring.resourceNoExistError", resource.getName())));
        }
    }

    public static void checkResourceSynched(IResource resource, RefactoringStatus status) {
        if (!resource.isSynchronized(2)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("ResourcesRefactoring.warningOutOfSync", resource.getFullPath())));
        }
    }

    public static void checkResourceWritable(IResource resource, RefactoringStatus status, int statusLevel, String statusMsg) {
        if (ModelUtil.isIResourceReadOnly((IResource)resource)) {
            switch (statusLevel) {
                case 1: {
                    status.merge(RefactoringStatus.createInfoStatus((String)statusMsg));
                    break;
                }
                case 2: {
                    status.merge(RefactoringStatus.createWarningStatus((String)statusMsg));
                    break;
                }
                default: {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)statusMsg));
                }
            }
        }
    }

    public static void checkModelResourceWritable(IResource resource, RefactoringStatus status, int statusLevel, String statusMsg) {
        try {
            ModelResource modelResource = ModelUtil.getModel((Object)resource);
            if (modelResource == null) {
                return;
            }
            if (modelResource.isReadOnly()) {
                switch (statusLevel) {
                    case 1: {
                        status.merge(RefactoringStatus.createInfoStatus((String)statusMsg));
                        break;
                    }
                    case 2: {
                        status.merge(RefactoringStatus.createWarningStatus((String)statusMsg));
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)statusMsg));
                        break;
                    }
                }
            }
        }
        catch (Exception err) {
            ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
            status.merge(RefactoringStatus.createFatalErrorStatus((String)err.getMessage()));
        }
    }

    public static void checkResourceIsNotProject(IResource resource, RefactoringStatus status) {
        if (resource instanceof IProject) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("ResourcesRefactoring.refactorProjectError", resource.getName())));
        }
    }

    public static void checkExtensionManager(IResource resource, IRefactorModelHandler.RefactorType refactorType, IProgressMonitor progressMonitor, RefactoringStatus status) {
        if (!RefactorModelExtensionManager.preProcess((IRefactorModelHandler.RefactorType)refactorType, (IResource)resource, (IProgressMonitor)progressMonitor)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("ResourcesRefactoring.extensionManagerError", new Object[0])));
        }
    }

    public static void calculateRelatedVdbResources(IResource resource, RefactoringStatus status, IResourceCallback callback) {
        Collection vdbResources = WorkspaceResourceFinderUtil.getVdbResourcesThatContain((IResource)resource);
        for (IFile vdb : vdbResources) {
            callback.checkValidFile(vdb, status);
            if (!status.isOK()) {
                return;
            }
            callback.indexVdb(resource, vdb, status);
        }
    }

    public static void calculateRelatedResources(IResource resource, RefactoringStatus status, IResourceCallback callback, RelatedResourceFinder.Relationship relationship) {
        RelatedResourceFinder finder = new RelatedResourceFinder(resource);
        Collection searchResults = finder.findRelatedResources(relationship);
        if (searchResults == null) {
            return;
        }
        for (IFile file : searchResults) {
            try {
                callback.checkValidFile(file, status);
                if (status.getSeverity() > 2) {
                    return;
                }
                callback.indexFile(resource, file, status);
            }
            catch (Exception ex) {
                UiConstants.Util.log((Throwable)ex);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)ex.getMessage()));
                return;
            }
        }
    }

    public static abstract class AbstractResourceCallback
    implements IResourceCallback {
        @Override
        public void checkValidFile(IFile relatedFile, RefactoringStatus status) {
        }

        @Override
        public void indexFile(IResource resource, IFile relatedFile, RefactoringStatus status) throws Exception {
        }

        @Override
        public void indexVdb(IResource resource, IFile vdbFile, RefactoringStatus status) {
        }
    }

    public static interface IResourceCallback {
        public void checkValidFile(IFile var1, RefactoringStatus var2);

        public void indexFile(IResource var1, IFile var2, RefactoringStatus var3) throws Exception;

        public void indexVdb(IResource var1, IFile var2, RefactoringStatus var3);
    }

    public static enum Option {
        EXCLUDE_FOLDERS;

    }
}

