/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.udp;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.ModelObjectPropertySource;
import org.teiid.designer.ui.properties.udp.ExtensionPropertyDescriptor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ExtensionPropertySource
implements IPropertySource {
    public static final AdapterFactoryContentProvider extensionPropertySourceProvider = ModelUtilities.getEmfAdapterFactoryContentProvider();
    EObject object;
    private EObject extension;
    private boolean isPrimaryMetamodelObject;
    private IItemPropertySource itemSource;
    private IPropertySource modelAnnotationExtensionSource;

    public ExtensionPropertySource(EObject object) {
        this.object = object;
        this.isPrimaryMetamodelObject = ModelObjectUtilities.isPrimaryMetamodelObject(object);
        if (this.isPrimaryMetamodelObject) {
            try {
                this.extension = ModelerCore.getModelEditor().getExtension(object);
            }
            catch (ModelerCoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
        } else if (object instanceof ModelAnnotation) {
            this.extension = object;
        }
        if (this.extension != null) {
            this.itemSource = (IItemPropertySource)extensionPropertySourceProvider.getAdapterFactory().adapt((Notifier)this.extension, IItemPropertySource.class);
        }
    }

    public boolean isExtensionProperty(Object id) {
        return id instanceof ExtensionPropertyDescriptor;
    }

    public Object getEditableValue() {
        return this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] result = new IPropertyDescriptor[]{};
        if (this.extension != null) {
            EList features = this.extension.eClass().getEStructuralFeatures();
            if (features.isEmpty()) {
                return result;
            }
            for (EStructuralFeature feature : features) {
                if (feature.getEType() != null) continue;
                return result;
            }
            IPropertySource propSource = ExtensionPropertyDescriptor.extensionPropertySourceProvider.getPropertySource((Object)this.extension);
            IPropertyDescriptor[] propArray = propSource.getPropertyDescriptors();
            result = new IPropertyDescriptor[propArray.length];
            int i = 0;
            while (i < result.length) {
                result[i] = new ExtensionPropertyDescriptor(this.extension, this.object, propArray[i]);
                ++i;
            }
            if (this.extension instanceof ModelAnnotation) {
                try {
                    EObject modelExtension = ModelerCore.getModelEditor().getExtension(this.extension);
                    if (modelExtension != null) {
                        this.modelAnnotationExtensionSource = ExtensionPropertyDescriptor.extensionPropertySourceProvider.getPropertySource((Object)modelExtension);
                        IPropertyDescriptor[] extensions = this.modelAnnotationExtensionSource.getPropertyDescriptors();
                        if (extensions != null && extensions.length > 0) {
                            IPropertyDescriptor[] myExtensions = new IPropertyDescriptor[extensions.length];
                            int i2 = 0;
                            while (i2 < extensions.length) {
                                myExtensions[i2] = new ModelAnnotationExtensionDescriptor(modelExtension, extensions[i2]);
                                ++i2;
                            }
                            ArrayList<IPropertyDescriptor> resultSoFar = new ArrayList<IPropertyDescriptor>(Arrays.asList(result));
                            resultSoFar.addAll(Arrays.asList(myExtensions));
                            result = new IPropertyDescriptor[resultSoFar.size()];
                            int i3 = 0;
                            while (i3 < resultSoFar.size()) {
                                result[i3] = (IPropertyDescriptor)resultSoFar.get(i3);
                                ++i3;
                            }
                        }
                    }
                }
                catch (ModelerCoreException e) {
                    UiConstants.Util.log((Throwable)e);
                }
            }
        }
        return result;
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof ModelAnnotationExtensionDescriptor) {
            ExtensionPropertyDescriptor extensionDescriptor = (ExtensionPropertyDescriptor)id;
            return this.modelAnnotationExtensionSource.getPropertyValue(extensionDescriptor.getDelegateId());
        }
        if (id instanceof ExtensionPropertyDescriptor && this.itemSource != null) {
            ItemPropertyDescriptor.PropertyValueWrapper wrapper;
            Object wrappedValue;
            ExtensionPropertyDescriptor extensionDescriptor = (ExtensionPropertyDescriptor)id;
            Object value = this.itemSource.getPropertyDescriptor((Object)this.extension, extensionDescriptor.getDelegateId()).getPropertyValue((Object)this.extension);
            if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper && (wrappedValue = (wrapper = (ItemPropertyDescriptor.PropertyValueWrapper)value).getEditableValue((Object)wrapper)) instanceof ModelType) {
                value = ((ModelType)wrappedValue).getDisplayName();
            }
            return value;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return this.getPropertyValue(id) != null;
    }

    public void resetPropertyValue(Object id) {
        this.setPropertyValue(id, null);
    }

    public void setPropertyValue(Object id, Object value) {
        if (id instanceof ModelAnnotationExtensionDescriptor) {
            ModelAnnotationExtensionDescriptor extensionDescriptor = (ModelAnnotationExtensionDescriptor)id;
            boolean started = ModelerCore.startTxn((String)(String.valueOf(ModelObjectPropertySource.SET) + extensionDescriptor.getDisplayName()), (Object)this);
            boolean succeeded = false;
            try {
                this.modelAnnotationExtensionSource.setPropertyValue(extensionDescriptor.getDelegateId(), value);
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        if (id instanceof ExtensionPropertyDescriptor) {
            boolean doIt = false;
            Object currentValue = this.getPropertyValue(id);
            if (currentValue instanceof ItemPropertyDescriptor.PropertyValueWrapper) {
                currentValue = ((ItemPropertyDescriptor.PropertyValueWrapper)currentValue).getEditableValue(id);
            }
            if (currentValue == null) {
                doIt = value != null;
            } else if (value == null) {
                doIt = true;
            } else {
                boolean bl = doIt = !currentValue.equals(value);
            }
            if (doIt) {
                ExtensionPropertyDescriptor extensionDescriptor = (ExtensionPropertyDescriptor)id;
                IItemPropertyDescriptor propDescriptor = this.itemSource.getPropertyDescriptor((Object)this.extension, extensionDescriptor.getDelegateId());
                boolean started = ModelerCore.startTxn((String)(String.valueOf(ModelObjectPropertySource.SET) + extensionDescriptor.getDisplayName()), (Object)this);
                boolean succeeded = false;
                try {
                    EStructuralFeature sf = (EStructuralFeature)propDescriptor.getFeature((Object)this.extension);
                    Object newValue = value;
                    EClassifier eClass = sf.getEType();
                    if (eClass instanceof EDataType) {
                        EDataType dt = (EDataType)eClass;
                        EPackage ePackage = dt.getEPackage();
                        EFactory fac = ePackage.getEFactoryInstance();
                        if (value instanceof String) {
                            newValue = fac.createFromString(dt, (String)value);
                        }
                    }
                    propDescriptor.setPropertyValue((Object)this.extension, newValue);
                    succeeded = true;
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    public boolean canConvertToCorrectDatatype(ExtensionPropertyDescriptor extensionDescriptor, Object value) {
        boolean canConvert = false;
        IItemPropertyDescriptor propDescriptor = this.itemSource.getPropertyDescriptor((Object)this.extension, extensionDescriptor.getDelegateId());
        try {
            EStructuralFeature sf = (EStructuralFeature)propDescriptor.getFeature((Object)this.extension);
            EDataType dt = (EDataType)sf.getEType();
            EPackage ePackage = dt.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            Object newValue = value;
            if (value instanceof String) {
                newValue = fac.createFromString(dt, (String)value);
            }
            if (newValue != null) {
                canConvert = true;
            }
        }
        catch (Exception exception) {
            canConvert = false;
        }
        return canConvert;
    }

    public class ModelAnnotationExtensionDescriptor
    extends ExtensionPropertyDescriptor {
        public ModelAnnotationExtensionDescriptor(EObject extensionObject, IPropertyDescriptor delegate) {
            super(extensionObject, ExtensionPropertySource.this.object, delegate);
        }
    }
}

