/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.sdt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.properties.ReadOnlyPropertyDescriptor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.w3c.dom.Node;

public class NodePropertyDescriptor
extends TextPropertyDescriptor {
    public static final String CATEGORY = UiConstants.Util.getString("RuntimeTypePropertyDescriptor.category", new Object[0]);
    private EObject eObject;
    private boolean isEditableProperty = true;
    private boolean showReadOnlyDialog = true;
    private String aDisplayName;

    public NodePropertyDescriptor(XSDSimpleTypeDefinition datatype, Node node) {
        super((Object)node, node.getNodeName());
        this.eObject = datatype;
        if (node.getNodeName().equals("UUID")) {
            this.isEditableProperty = false;
        }
        if (ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype((EObject)datatype)) {
            this.isEditableProperty = false;
        }
    }

    public NodePropertyDescriptor(XSDSimpleTypeDefinition datatype, Node node, String displayName) {
        this(datatype, node);
        this.aDisplayName = displayName;
    }

    public void setShowReadOnlyDialog(boolean enable) {
        this.showReadOnlyDialog = enable;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (!this.isEditableProperty) {
            return null;
        }
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject(this.eObject);
        if (modelResource == null) {
            return null;
        }
        if (ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource())) {
            if (this.showReadOnlyDialog) {
                Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)ReadOnlyPropertyDescriptor.READ_ONLY_TITLE, (String)ReadOnlyPropertyDescriptor.READ_ONLY_MESSAGE);
            }
            return null;
        }
        IFile file = (IFile)modelResource.getResource();
        if (file != null && !ModelEditorManager.isOpen(file)) {
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)ModelEditorManager.OPEN_EDITOR_TITLE, (String)ModelEditorManager.OPEN_EDITOR_MESSAGE)) {
                ModelEditorManager.open(this.eObject, true);
            }
            return null;
        }
        return super.createPropertyEditor(parent);
    }

    public String getDisplayName() {
        return this.aDisplayName != null ? this.aDisplayName : super.getDisplayName();
    }
}

