/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.extension;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.util.ErrorHandler;

final class ChooseFileDialogContentProvider
implements ITreeContentProvider {
    private IProject[] projects;
    private VdbHelper.VdbFolders vdbFolder;

    public ChooseFileDialogContentProvider(IProject project, VdbHelper.VdbFolders vdbFolder) {
        this.projects = new IProject[]{project};
        this.vdbFolder = vdbFolder;
    }

    public final void dispose() {
    }

    public final IResource[] getChildren(Object element) {
        IContainer container = (IContainer)element;
        ArrayList<IResource> children = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer && this.hasChildren(resource) || resource instanceof IFile && this.validFile((IFile)resource)) {
                    children.add(resource);
                }
                ++n2;
            }
        }
        catch (CoreException error) {
            ErrorHandler.toExceptionDialog(error);
        }
        return children.toArray(new IResource[children.size()]);
    }

    public Object[] getElements(Object inputElement) {
        return this.projects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        if (element instanceof IFile) {
            return false;
        }
        IContainer container = (IContainer)element;
        if (container instanceof IFolder && this.vdbFolder != null && VdbHelper.VdbFolders.UDF.equals((Object)this.vdbFolder) && !VdbHelper.VdbFolders.UDF.getReadFolder().equals(container.getName())) {
            return false;
        }
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer ? this.hasChildren(resource) : this.validFile((IFile)resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException error) {
            ErrorHandler.toExceptionDialog(error);
        }
        return false;
    }

    public final Object getParent(Object element) {
        return ((IResource)element).getParent();
    }

    boolean validFile(IFile file) {
        String ext = file.getFileExtension();
        switch (this.vdbFolder) {
            case UDF: {
                if (ext == null) {
                    return false;
                }
                ext = ext.toLowerCase();
                return "jar".equals(ext);
            }
            case OTHER_FILES: {
                if ("jar".equals(ext)) {
                    return false;
                }
                return !ModelUtil.isModelFile((IResource)file);
            }
        }
        return true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

