/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.core.extension.XClass;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.widget.accumulator.AccumulatorDialog;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;
import org.teiid.designer.ui.properties.IPropertyEditorFactory;
import org.teiid.designer.ui.properties.ModelObjectAccumulatorSourceImpl;
import org.teiid.designer.ui.properties.ModelObjectPropertyDescriptor;
import org.teiid.designer.ui.viewsupport.DatatypeSelectionDialog;
import org.teiid.designer.ui.viewsupport.IFilter;
import org.teiid.designer.ui.viewsupport.MetamodelTreeViewer;
import org.teiid.designer.ui.viewsupport.ModelObjectListDialog;
import org.teiid.designer.ui.viewsupport.ModelObjectPathLabelProvider;

public abstract class PropertyEditorFactory
implements UiConstants.ExtensionPoints.PropertyEditorFactoryExtension {
    private static final int COMBO_BOX_CHOICE_LIMIT = 10;
    static final ILabelProvider pathLabelProvider = new ModelObjectPathLabelProvider();
    private static final ModelEditor me = ModelerCore.getModelEditor();
    private static final ArrayList customPropertyFactories = new ArrayList();

    static {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "propertyEditorFactory");
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length > 0) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                Object extension = null;
                int j = 0;
                while (j < elements.length) {
                    try {
                        extension = elements[j].createExecutableExtension("name");
                        if (extension instanceof IPropertyEditorFactory) {
                            customPropertyFactories.add(extension);
                        } else {
                            UiConstants.Util.log(4, UiConstants.Util.getString("PropertyEditorFactory.wrongContributorClass", new Object[]{extension.getClass().getName()}));
                        }
                    }
                    catch (Exception theException) {
                        UiConstants.Util.log(4, (Throwable)theException, UiConstants.Util.getString("PropertyEditorFactory.contributorProblem", new Object[]{elements[j].getAttribute("name")}));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static CellEditor createPropertyEditor(Composite composite, IItemPropertyDescriptor itemPropertyDescriptor, IPropertyDescriptor propertyDescriptor, Object object) {
        return PropertyEditorFactory.createPropertyEditor(composite, itemPropertyDescriptor, propertyDescriptor, object, false);
    }

    public static CellEditor createPropertyEditor(Composite composite, IItemPropertyDescriptor itemPropertyDescriptor, IPropertyDescriptor propertyDescriptor, Object object, boolean lazyLoadChoices) {
        if (!itemPropertyDescriptor.canSetProperty(object)) {
            return null;
        }
        Object result = null;
        Object genericFeature = itemPropertyDescriptor.getFeature(object);
        if (genericFeature instanceof EReference[]) {
            result = PropertyEditorFactory.createComboEditor(composite, itemPropertyDescriptor, propertyDescriptor, object);
        } else if (genericFeature instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)genericFeature;
            if (!customPropertyFactories.isEmpty()) {
                for (IPropertyEditorFactory factory : customPropertyFactories) {
                    try {
                        if (!factory.supportsStructuralFeature(feature)) continue;
                        return factory.createPropertyEditor(composite, itemPropertyDescriptor, propertyDescriptor, object);
                    }
                    catch (Exception exception) {
                        UiConstants.Util.log(4, UiConstants.Util.getString("PropertyEditorFactory.errorInFactory", new Object[]{factory.getClass().getName()}));
                    }
                }
            }
            EClassifier eType = feature.getEType();
            String eTypeInstanceClassName = eType.getInstanceClassName();
            EObject target = null;
            if (propertyDescriptor instanceof ModelObjectPropertyDescriptor) {
                target = (EObject)((ModelObjectPropertyDescriptor)propertyDescriptor).getObject();
            }
            if (me.isDatatypeFeature(target, feature) || object instanceof XSDSimpleTypeDefinition && eTypeInstanceClassName.equals(EObject.class.getName())) {
                result = PropertyEditorFactory.createDatatypeEditor(composite, itemPropertyDescriptor, propertyDescriptor, object);
            } else if (object instanceof XClass && eTypeInstanceClassName.equals(EClass.class.getName())) {
                result = PropertyEditorFactory.createMetaclassEditor(composite, itemPropertyDescriptor, propertyDescriptor, object);
            } else if (eType instanceof EEnum) {
                if (feature.isMany() && object instanceof EObject) {
                    Iterator iter = itemPropertyDescriptor.getChoiceOfValues(object).iterator();
                    boolean containsLiterals = false;
                    while (iter.hasNext()) {
                        if (!(iter.next() instanceof EEnumLiteral)) continue;
                        containsLiterals = true;
                        break;
                    }
                    result = containsLiterals ? PropertyEditorFactory.createAccumulatorEnumEditor(composite, propertyDescriptor, feature, itemPropertyDescriptor, object) : PropertyEditorFactory.createComboEditor(composite, itemPropertyDescriptor, propertyDescriptor, object);
                } else {
                    result = PropertyEditorFactory.createComboEditor(composite, itemPropertyDescriptor, propertyDescriptor, object);
                }
            } else if (eType instanceof EDataType) {
                EDataType eDataType = (EDataType)eType;
                if (eDataType.isSerializable()) {
                    Collection choiceOfValues;
                    Collection choices;
                    result = feature.isMany() && object instanceof EObject ? (feature instanceof EAttribute ? ((choices = itemPropertyDescriptor.getChoiceOfValues(object)) == null || choices.isEmpty() ? ((ModelObjectPropertyDescriptor)propertyDescriptor).createDelegatePropertyEditor(composite) : PropertyEditorFactory.createAccumulatorEnumEditor(composite, propertyDescriptor, feature, itemPropertyDescriptor, object)) : PropertyEditorFactory.createAccumulatorEnumEditor(composite, propertyDescriptor, feature, itemPropertyDescriptor, object)) : (eDataType == EcorePackage.eINSTANCE.getEBoolean() || eDataType == EcorePackage.eINSTANCE.getEBooleanObject() ? PropertyEditorFactory.createBooleanEditor(composite, propertyDescriptor) : ((choiceOfValues = itemPropertyDescriptor.getChoiceOfValues(object)) != null ? (choiceOfValues.size() < 10 ? PropertyEditorFactory.createComboEditor(composite, itemPropertyDescriptor, propertyDescriptor, object) : PropertyEditorFactory.createListEditor(composite, propertyDescriptor, feature, itemPropertyDescriptor, object, choiceOfValues)) : new PropertyDescriptor.EDataTypeCellEditor(eDataType, composite)));
                }
            } else {
                if (object instanceof EObject) {
                    if (feature.isMany()) {
                        boolean valid = true;
                        if (valid) {
                            result = PropertyEditorFactory.createAccumulatorEditor(composite, propertyDescriptor, feature, itemPropertyDescriptor, object);
                        }
                    } else {
                        boolean useComboBox = false;
                        Collection choiceOfValues = null;
                        if (!lazyLoadChoices && (choiceOfValues = itemPropertyDescriptor.getChoiceOfValues(object)).size() < 10) {
                            useComboBox = true;
                        }
                        result = useComboBox ? PropertyEditorFactory.createComboEditor(composite, itemPropertyDescriptor, propertyDescriptor, object) : PropertyEditorFactory.createListEditor(composite, propertyDescriptor, feature, itemPropertyDescriptor, object, choiceOfValues);
                    }
                }
                if (result == null) {
                    result = PropertyEditorFactory.createComboEditor(composite, itemPropertyDescriptor, propertyDescriptor, object);
                }
            }
        }
        return result;
    }

    private static CellEditor createComboEditor(Composite composite, IItemPropertyDescriptor itemPropertyDescriptor, IPropertyDescriptor propertyDescriptor, Object object) {
        return new ExtendedComboBoxCellEditor(composite, new ArrayList(itemPropertyDescriptor.getChoiceOfValues(object)), propertyDescriptor.getLabelProvider(), true);
    }

    private static CellEditor createBooleanEditor(Composite composite, IPropertyDescriptor propertyDescriptor) {
        return new ExtendedComboBoxCellEditor(composite, Arrays.asList(new Boolean(false), new Boolean(true)), propertyDescriptor.getLabelProvider(), true);
    }

    private static CellEditor createDatatypeEditor(final Composite composite, IItemPropertyDescriptor itemPropertyDescriptor, IPropertyDescriptor propertyDescriptor, final Object object) {
        final Object feature = itemPropertyDescriptor.getFeature(object);
        if (feature instanceof EStructuralFeature) {
            return new ExtendedDialogCellEditor(composite, propertyDescriptor.getLabelProvider()){

                protected Object openDialogBox(Control cellEditorWindow) {
                    DatatypeSelectionDialog dialog = new DatatypeSelectionDialog(composite.getShell(), (EObject)object, (EStructuralFeature)feature);
                    Object originalValue = this.getValue();
                    Object[] selection = new Object[]{originalValue};
                    selection[0] = this.getValue();
                    dialog.setInitialSelections(selection);
                    int status = dialog.open();
                    if (status == 0) {
                        Object[] result = dialog.getResult();
                        if (result.length == 0) {
                            return null;
                        }
                        return result[0];
                    }
                    return originalValue;
                }
            };
        }
        return new ExtendedDialogCellEditor(composite, propertyDescriptor.getLabelProvider()){

            protected Object openDialogBox(Control cellEditorWindow) {
                DatatypeSelectionDialog dialog = new DatatypeSelectionDialog(composite.getShell(), (EObject)object);
                Object originalValue = this.getValue();
                Object[] selection = new Object[]{originalValue};
                selection[0] = this.getValue();
                dialog.setInitialSelections(selection);
                int status = dialog.open();
                if (status == 0) {
                    Object[] result = dialog.getResult();
                    if (result.length == 0) {
                        return null;
                    }
                    return result[0];
                }
                return originalValue;
            }
        };
    }

    private static CellEditor createMetaclassEditor(final Composite composite, IItemPropertyDescriptor itemPropertyDescriptor, IPropertyDescriptor propertyDescriptor, Object object) {
        return new ExtendedDialogCellEditor(composite, propertyDescriptor.getLabelProvider()){

            protected Object openDialogBox(Control cellEditorWindow) {
                SelectionDialog dialog = MetamodelTreeViewer.createSelectionDialog(composite.getShell(), true);
                Object originalValue = this.getValue();
                Object[] selection = new Object[]{originalValue};
                selection[0] = this.getValue();
                dialog.setInitialSelections(selection);
                int status = dialog.open();
                if (status == 0) {
                    Object[] result = dialog.getResult();
                    if (result.length == 0) {
                        return null;
                    }
                    return result[0];
                }
                return originalValue;
            }
        };
    }

    private static CellEditor createAccumulatorEditor(Composite composite, final IPropertyDescriptor propertyDescriptor, final EStructuralFeature feature, final IItemPropertyDescriptor itemPropertyDescriptor, final Object object) {
        return new ExtendedDialogCellEditor(composite, propertyDescriptor.getLabelProvider()){

            protected Object openDialogBox(Control cellEditorWindow) {
                EObject eObject = (EObject)object;
                List initialSelectionList = (List)eObject.eGet(feature);
                List initialSelectionListLocal = PropertyEditorFactory.copyList(initialSelectionList);
                ArrayList initialAvailableList = new ArrayList(itemPropertyDescriptor.getChoiceOfValues(object));
                PropertyEditorFactory.removeSelectedItemsFromAvailable(initialAvailableList, initialSelectionListLocal);
                ModelObjectAccumulatorSourceImpl accumulatorSource = new ModelObjectAccumulatorSourceImpl(pathLabelProvider, initialAvailableList);
                String availableLabel = EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_label");
                String selectedLabel = EMFEditUIPlugin.INSTANCE.getString("_UI_Feature_label");
                AccumulatorDialog accumulatorDialog = new AccumulatorDialog(cellEditorWindow.getShell(), (IAccumulatorSource)accumulatorSource, propertyDescriptor.getDisplayName(), (Collection)initialSelectionListLocal, pathLabelProvider, availableLabel, selectedLabel);
                int status = accumulatorDialog.open();
                List result = initialSelectionList;
                if (status == 0) {
                    result = new BasicEList(accumulatorDialog.getSelectedItems());
                }
                return result;
            }
        };
    }

    private static CellEditor createAccumulatorEnumEditor(Composite composite, final IPropertyDescriptor propertyDescriptor, final EStructuralFeature feature, final IItemPropertyDescriptor itemPropertyDescriptor, final Object object) {
        return new ExtendedDialogCellEditor(composite, propertyDescriptor.getLabelProvider()){

            protected Object openDialogBox(Control cellEditorWindow) {
                EObject eObject = (EObject)object;
                List initialSelectionList = (List)eObject.eGet(feature);
                List initialSelectionListLocal = PropertyEditorFactory.copyList(initialSelectionList);
                Collection choices = itemPropertyDescriptor.getChoiceOfValues(object);
                ArrayList choiceList = new ArrayList(choices);
                ArrayList initialAvailableList = new ArrayList(choiceList);
                PropertyEditorFactory.removeSelectedItemsFromAvailable(initialAvailableList, initialSelectionListLocal);
                ModelObjectAccumulatorSourceImpl accumulatorSource = new ModelObjectAccumulatorSourceImpl(propertyDescriptor.getLabelProvider(), initialAvailableList);
                String availableLabel = EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_label");
                String selectedLabel = EMFEditUIPlugin.INSTANCE.getString("_UI_Feature_label");
                AccumulatorDialog accumulatorDialog = new AccumulatorDialog(cellEditorWindow.getShell(), (IAccumulatorSource)accumulatorSource, propertyDescriptor.getDisplayName(), (Collection)initialSelectionListLocal, propertyDescriptor.getLabelProvider(), availableLabel, selectedLabel);
                int status = accumulatorDialog.open();
                if (status != 0) {
                    return null;
                }
                Collection selectedItems = accumulatorDialog.getSelectedItems();
                ArrayList<Integer> result = new ArrayList<Integer>(selectedItems.size());
                Iterator iter = selectedItems.iterator();
                while (iter.hasNext()) {
                    int index = choiceList.indexOf(iter.next());
                    if (index < 0) continue;
                    result.add(new Integer(index));
                }
                return new BasicEList(result);
            }
        };
    }

    private static CellEditor createListEditor(final Composite composite, final IPropertyDescriptor propertyDescriptor, EStructuralFeature feature, final IItemPropertyDescriptor itemPropertyDescriptor, final Object object, final Collection choiceOfValues) {
        return new ExtendedDialogCellEditor(composite, propertyDescriptor.getLabelProvider()){

            protected Object openDialogBox(Control cellEditorWindow) {
                ArrayList inputValues;
                ModelObjectListDialog dialog = new ModelObjectListDialog(composite.getShell(), propertyDescriptor.getLabelProvider(), true, false);
                dialog.setContentFilter(new IFilter(){

                    @Override
                    public boolean passes(Object object) {
                        if (object instanceof XSDComponent) {
                            return object instanceof XSDTypeDefinition || object instanceof XSDFeature;
                        }
                        return true;
                    }
                });
                Collection collection = inputValues = choiceOfValues != null ? choiceOfValues : itemPropertyDescriptor.getChoiceOfValues(object);
                if (inputValues.contains(null)) {
                    inputValues = new ArrayList(inputValues);
                    inputValues.remove(null);
                }
                dialog.setInput(inputValues);
                Object originalValue = this.getValue();
                Object[] selection = new Object[]{originalValue};
                dialog.setInitialSelections(selection);
                dialog.setFeatureName(propertyDescriptor.getDisplayName());
                int status = dialog.open();
                if (status == 0) {
                    Object[] result = dialog.getResult();
                    if (result.length == 0) {
                        if (this.isCorrect(null)) {
                            this.markDirty();
                            this.doSetValue(null);
                            this.fireApplyEditorValue();
                        }
                        return null;
                    }
                    return result[0];
                }
                return originalValue;
            }
        };
    }

    static List copyList(List inList) {
        ArrayList outList = new ArrayList(inList.size());
        Iterator it = inList.iterator();
        while (it.hasNext()) {
            outList.add(it.next());
        }
        return outList;
    }

    static void removeSelectedItemsFromAvailable(List available, List selected) {
        for (Object item : selected) {
            if (!available.contains(item)) continue;
            available.remove(item);
        }
    }

    private PropertyEditorFactory() {
    }
}

